/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import org.pac4j.core.client.ClientType;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.direct.DirectHttpClient;
import org.pac4j.http.credentials.TokenCredentials;
import org.pac4j.http.credentials.authenticator.TokenAuthenticator;
import org.pac4j.http.credentials.extractor.CookieExtractor;
import org.pac4j.http.profile.creator.ProfileCreator;

public class CookieClient
extends DirectHttpClient<TokenCredentials> {
    private String cookieName;

    public CookieClient() {
    }

    public CookieClient(TokenAuthenticator cookieAuthenticator) {
        this.setAuthenticator(cookieAuthenticator);
    }

    public CookieClient(TokenAuthenticator cookieAuthenticator, ProfileCreator profileCreator) {
        this.setAuthenticator(cookieAuthenticator);
        this.setProfileCreator(profileCreator);
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"cookieName", (String)this.cookieName);
        this.extractor = new CookieExtractor(this.cookieName, this.getName());
        super.internalInit(context);
    }

    protected CookieClient newClient() {
        CookieClient newClient = new CookieClient();
        newClient.setCookieName(this.cookieName);
        return newClient;
    }

    public ClientType getClientType() {
        return ClientType.COOKIE_BASED;
    }
}

