/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import org.pac4j.core.client.ClientType;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.direct.DirectHttpClient;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.pac4j.http.credentials.authenticator.UsernamePasswordAuthenticator;
import org.pac4j.http.credentials.extractor.FormExtractor;
import org.pac4j.http.profile.creator.ProfileCreator;

public class DirectFormClient
extends DirectHttpClient<UsernamePasswordCredentials> {
    public static final String DEFAULT_USERNAME_PARAMETER = "username";
    private String usernameParameter = "username";
    public static final String DEFAULT_PASSWORD_PARAMETER = "password";
    private String passwordParameter = "password";

    public DirectFormClient() {
    }

    public DirectFormClient(UsernamePasswordAuthenticator usernamePasswordAuthenticator) {
        this.setAuthenticator(usernamePasswordAuthenticator);
    }

    public DirectFormClient(UsernamePasswordAuthenticator usernamePasswordAuthenticator, ProfileCreator profileCreator) {
        this.setAuthenticator(usernamePasswordAuthenticator);
        this.setProfileCreator(profileCreator);
    }

    protected DirectHttpClient<UsernamePasswordCredentials> newClient() {
        DirectFormClient newClient = new DirectFormClient();
        newClient.setUsernameParameter(this.usernameParameter);
        newClient.setPasswordParameter(this.passwordParameter);
        return newClient;
    }

    @Override
    protected void internalInit(WebContext context) {
        this.extractor = new FormExtractor(this.usernameParameter, this.passwordParameter, this.getName());
        super.internalInit(context);
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    @Override
    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "usernameParameter", this.usernameParameter, "passwordParameter", this.passwordParameter, "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }

    public ClientType getClientType() {
        return ClientType.FORM_BASED;
    }
}

