/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.authenticator.Authenticator;
import org.pac4j.http.credentials.extractor.Extractor;
import org.pac4j.http.profile.creator.AuthenticatorProfileCreator;
import org.pac4j.http.profile.creator.ProfileCreator;

public abstract class DirectHttpClient<C extends Credentials>
extends DirectClient<C, CommonProfile> {
    protected Extractor<C> extractor;
    private Authenticator<C> authenticator;
    private ProfileCreator<C, CommonProfile> profileCreator = AuthenticatorProfileCreator.INSTANCE;

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"extractor", this.extractor);
        CommonHelper.assertNotNull((String)"authenticator", this.getAuthenticator());
        CommonHelper.assertNotNull((String)"profileCreator", this.getProfileCreator());
    }

    public DirectHttpClient<C> clone() {
        DirectHttpClient newClient = (DirectHttpClient)super.clone();
        newClient.setAuthenticator(this.authenticator);
        newClient.setProfileCreator(this.profileCreator);
        return newClient;
    }

    public C getCredentials(WebContext context) throws RequiresHttpAction {
        this.init(context);
        try {
            C credentials = this.extractor.extract(context);
            if (credentials == null) {
                return null;
            }
            this.getAuthenticator().validate(credentials);
            return credentials;
        }
        catch (CredentialsException e) {
            this.logger.error("Failed to retrieve or validate credentials", (Throwable)e);
            return null;
        }
    }

    protected CommonProfile retrieveUserProfile(C credentials, WebContext context) {
        CommonProfile profile = this.getProfileCreator().create(credentials);
        this.logger.debug("profile: {}", (Object)profile);
        return profile;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "extractor", this.extractor, "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }

    public Authenticator<C> getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator<C> authenticator) {
        this.authenticator = authenticator;
    }

    public ProfileCreator<C, CommonProfile> getProfileCreator() {
        return this.profileCreator;
    }

    public void setProfileCreator(ProfileCreator<C, CommonProfile> profileCreator) {
        this.profileCreator = profileCreator;
    }
}

