/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator;

import java.util.regex.Pattern;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.TokenCredentials;
import org.pac4j.http.credentials.authenticator.TokenAuthenticator;
import org.pac4j.http.profile.IpProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpRegexpAuthenticator
implements TokenAuthenticator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String regexPattern;
    private Pattern pattern;

    public IpRegexpAuthenticator() {
    }

    public IpRegexpAuthenticator(String regexpPattern) {
        this.setRegexpPattern(regexpPattern);
    }

    @Override
    public void validate(TokenCredentials credentials) {
        CommonHelper.assertNotNull((String)"pattern", (Object)this.pattern);
        String ip = credentials.getToken();
        if (!this.pattern.matcher(ip).matches()) {
            throw new CredentialsException("Unauthorized IP address: " + ip);
        }
        IpProfile profile = new IpProfile(ip);
        this.logger.debug("profile: {}", (Object)profile);
        credentials.setUserProfile((UserProfile)profile);
    }

    public void setRegexpPattern(String regexpPattern) {
        this.regexPattern = regexpPattern;
        this.pattern = Pattern.compile(regexpPattern);
    }

    public String toString() {
        return "IpRegexpAuthenticator[" + this.regexPattern + "]";
    }
}

