/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.http.credentials.TokenCredentials;
import org.pac4j.http.credentials.extractor.Extractor;

public class HeaderExtractor
implements Extractor<TokenCredentials> {
    private final String headerName;
    private final String prefixHeader;
    private final String clientName;

    public HeaderExtractor(String headerName, String prefixHeader, String clientName) {
        this.headerName = headerName;
        this.prefixHeader = prefixHeader;
        this.clientName = clientName;
    }

    @Override
    public TokenCredentials extract(WebContext context) {
        String header = context.getRequestHeader(this.headerName);
        if (header == null) {
            return null;
        }
        if (!header.startsWith(this.prefixHeader)) {
            throw new CredentialsException("Wrong prefix for header: " + this.headerName);
        }
        String headerWithoutPrefix = header.substring(this.prefixHeader.length());
        return new TokenCredentials(headerWithoutPrefix, this.clientName);
    }
}

