/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jwt.config.encryption;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.AESDecrypter;
import com.nimbusds.jose.crypto.AESEncrypter;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.nimbusds.jose.crypto.DirectEncrypter;
import java.io.UnsupportedEncodingException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.jwt.config.encryption.AbstractEncryptionConfiguration;

public class SecretEncryptionConfiguration
extends AbstractEncryptionConfiguration {
    private String secret;

    public SecretEncryptionConfiguration() {
        this.algorithm = JWEAlgorithm.DIR;
        this.method = EncryptionMethod.A256GCM;
    }

    public SecretEncryptionConfiguration(String secret) {
        this();
        this.secret = secret;
    }

    public SecretEncryptionConfiguration(String secret, JWEAlgorithm algorithm, EncryptionMethod method) {
        this.secret = secret;
        this.algorithm = algorithm;
        this.method = method;
    }

    @Override
    public boolean supports(JWEAlgorithm algorithm, EncryptionMethod method) {
        if (algorithm != null && method != null) {
            boolean isDirect = DirectDecrypter.SUPPORTED_ALGORITHMS.contains(algorithm) && DirectDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(method);
            boolean isAes = AESDecrypter.SUPPORTED_ALGORITHMS.contains(algorithm) && AESDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(method);
            return isDirect || isAes;
        }
        return false;
    }

    protected void internalInit() {
        CommonHelper.assertNotBlank((String)"secret", (String)this.secret);
        CommonHelper.assertNotNull((String)"algorithm", (Object)this.algorithm);
        CommonHelper.assertNotNull((String)"method", (Object)this.method);
        if (!this.supports(this.algorithm, this.method)) {
            throw new TechnicalException("Only the direct and AES algorithms are supported with the appropriate encryption method");
        }
    }

    @Override
    protected JWEEncrypter buildEncrypter() {
        try {
            if (DirectDecrypter.SUPPORTED_ALGORITHMS.contains(this.algorithm)) {
                return new DirectEncrypter(this.secret.getBytes("UTF-8"));
            }
            return new AESEncrypter(this.secret.getBytes("UTF-8"));
        }
        catch (KeyLengthException | UnsupportedEncodingException e) {
            throw new TechnicalException(e);
        }
    }

    @Override
    protected JWEDecrypter buildDecrypter() {
        try {
            if (DirectDecrypter.SUPPORTED_ALGORITHMS.contains(this.algorithm)) {
                return new DirectDecrypter(this.secret.getBytes("UTF-8"));
            }
            return new AESDecrypter(this.secret.getBytes("UTF-8"));
        }
        catch (KeyLengthException | UnsupportedEncodingException e) {
            throw new TechnicalException(e);
        }
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), (Object[])new Object[]{"secret", "[protected]", "algorithm", this.algorithm, "method", this.method});
    }
}

