/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jwt.credentials.authenticator;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.jwt.config.encryption.EncryptionConfiguration;
import org.pac4j.jwt.config.encryption.SecretEncryptionConfiguration;
import org.pac4j.jwt.config.signature.SecretSignatureConfiguration;
import org.pac4j.jwt.config.signature.SignatureConfiguration;
import org.pac4j.jwt.profile.JwtProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAuthenticator
implements Authenticator<TokenCredentials> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<EncryptionConfiguration> encryptionConfigurations = new ArrayList<EncryptionConfiguration>();
    private List<SignatureConfiguration> signatureConfigurations = new ArrayList<SignatureConfiguration>();

    public JwtAuthenticator() {
    }

    public JwtAuthenticator(List<SignatureConfiguration> signatureConfigurations) {
        this.signatureConfigurations = signatureConfigurations;
    }

    public JwtAuthenticator(List<SignatureConfiguration> signatureConfigurations, List<EncryptionConfiguration> encryptionConfigurations) {
        this.signatureConfigurations = signatureConfigurations;
        this.encryptionConfigurations = encryptionConfigurations;
    }

    public JwtAuthenticator(SignatureConfiguration signatureConfiguration, EncryptionConfiguration encryptionConfiguration) {
        this.setSignatureConfiguration(signatureConfiguration);
        this.setEncryptionConfiguration(encryptionConfiguration);
    }

    @Deprecated
    public JwtAuthenticator(String signingSecret) {
        this(signingSecret, signingSecret);
        this.logger.warn("Using the same key for signature and encryption may lead to security vulnerabilities. Consider using different keys");
    }

    @Deprecated
    public JwtAuthenticator(String signingSecret, String encryptionSecret) {
        if (signingSecret != null) {
            this.addSignatureConfiguration(new SecretSignatureConfiguration(signingSecret));
        }
        if (encryptionSecret != null) {
            this.addEncryptionConfiguration(new SecretEncryptionConfiguration(encryptionSecret));
        }
    }

    public Map<String, Object> validateTokenAndGetClaims(String token) {
        CommonProfile profile = this.validateToken(token);
        HashMap<String, Object> claims = new HashMap<String, Object>(profile.getAttributes());
        claims.put("sub", profile.getId());
        return claims;
    }

    public CommonProfile validateToken(String token) {
        TokenCredentials credentials = new TokenCredentials(token, "(validateToken)Method");
        try {
            this.validate(credentials, null);
        }
        catch (HttpAction e) {
            throw new TechnicalException((Throwable)e);
        }
        return credentials.getUserProfile();
    }

    public void validate(TokenCredentials credentials, WebContext context) throws HttpAction {
        String token = credentials.getToken();
        try {
            JWT jwt = JWTParser.parse((String)token);
            if (jwt instanceof PlainJWT) {
                this.logger.debug("JWT is not signed -> verified");
            } else {
                boolean found;
                SignedJWT signedJWT = null;
                if (jwt instanceof SignedJWT) {
                    signedJWT = (SignedJWT)jwt;
                }
                if (jwt instanceof EncryptedJWT) {
                    this.logger.debug("JWT is encrypted");
                    EncryptedJWT encryptedJWT = (EncryptedJWT)jwt;
                    found = false;
                    JWEHeader header = encryptedJWT.getHeader();
                    JWEAlgorithm algorithm = header.getAlgorithm();
                    EncryptionMethod method = header.getEncryptionMethod();
                    for (EncryptionConfiguration config : this.encryptionConfigurations) {
                        if (!config.supports(algorithm, method)) continue;
                        this.logger.debug("Using encryption configuration: {}", (Object)config);
                        try {
                            config.decrypt(encryptedJWT);
                            signedJWT = encryptedJWT.getPayload().toSignedJWT();
                            if (signedJWT != null) {
                                jwt = signedJWT;
                            }
                            found = true;
                            break;
                        }
                        catch (JOSEException e) {
                            this.logger.debug("Decryption fails with encryption configuration: {}, passing to the next one", (Object)config);
                        }
                    }
                    if (!found) {
                        throw new CredentialsException("No encryption algorithm found for JWT: " + token);
                    }
                }
                if (signedJWT != null) {
                    this.logger.debug("JWT is signed");
                    boolean verified = false;
                    found = false;
                    JWSAlgorithm algorithm = signedJWT.getHeader().getAlgorithm();
                    for (SignatureConfiguration config : this.signatureConfigurations) {
                        if (!config.supports(algorithm)) continue;
                        this.logger.debug("Using signature configuration: {}", (Object)config);
                        try {
                            verified = config.verify(signedJWT);
                            found = true;
                            break;
                        }
                        catch (JOSEException e) {
                            this.logger.debug("Verification fails with signature configuration: {}, passing to the next one", (Object)config);
                        }
                    }
                    if (!found) {
                        throw new CredentialsException("No signature algorithm found for JWT: " + token);
                    }
                    if (!verified) {
                        throw new CredentialsException("JWT verification failed: " + token);
                    }
                }
            }
            this.createJwtProfile(credentials, jwt);
        }
        catch (ParseException e) {
            throw new TechnicalException("Cannot decrypt / verify JWT", (Throwable)e);
        }
    }

    protected void createJwtProfile(TokenCredentials credentials, JWT jwt) throws ParseException {
        Date now;
        Date expirationTime;
        JWTClaimsSet claimSet = jwt.getJWTClaimsSet();
        String subject = claimSet.getSubject();
        if (subject == null) {
            throw new TechnicalException("JWT must contain a subject ('sub' claim)");
        }
        if (!subject.contains("#")) {
            subject = JwtProfile.class.getName() + "#" + subject;
        }
        if ((expirationTime = claimSet.getExpirationTime()) != null && expirationTime.before(now = new Date())) {
            this.logger.error("The JWT is expired: no profile is built");
            return;
        }
        HashMap attributes = new HashMap(claimSet.getClaims());
        attributes.remove("sub");
        List roles = (List)attributes.get("$int_roles");
        attributes.remove("$int_roles");
        List permissions = (List)attributes.get("$int_perms");
        attributes.remove("$int_perms");
        CommonProfile profile = ProfileHelper.buildProfile((String)subject, attributes);
        if (roles != null) {
            profile.addRoles(roles);
        }
        if (permissions != null) {
            profile.addPermissions(permissions);
        }
        credentials.setUserProfile(profile);
    }

    public List<SignatureConfiguration> getSignatureConfigurations() {
        return this.signatureConfigurations;
    }

    public void setSignatureConfiguration(SignatureConfiguration signatureConfiguration) {
        this.addSignatureConfiguration(signatureConfiguration);
    }

    public void addSignatureConfiguration(SignatureConfiguration signatureConfiguration) {
        CommonHelper.assertNotNull((String)"signatureConfiguration", (Object)signatureConfiguration);
        this.signatureConfigurations.add(signatureConfiguration);
    }

    public void setSignatureConfigurations(List<SignatureConfiguration> signatureConfigurations) {
        CommonHelper.assertNotNull((String)"signatureConfigurations", signatureConfigurations);
        this.signatureConfigurations = signatureConfigurations;
    }

    public List<EncryptionConfiguration> getEncryptionConfigurations() {
        return this.encryptionConfigurations;
    }

    public void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.addEncryptionConfiguration(encryptionConfiguration);
    }

    public void addEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        CommonHelper.assertNotNull((String)"encryptionConfiguration", (Object)encryptionConfiguration);
        this.encryptionConfigurations.add(encryptionConfiguration);
    }

    public void setEncryptionConfigurations(List<EncryptionConfiguration> encryptionConfigurations) {
        CommonHelper.assertNotNull((String)"encryptionConfigurations", encryptionConfigurations);
        this.encryptionConfigurations = encryptionConfigurations;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), (Object[])new Object[]{"signatureConfigurations", this.signatureConfigurations, "encryptionConfigurations", this.encryptionConfigurations});
    }
}

