/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.IterableMetadataSource;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.metadata.resolver.index.impl.RoleMetadataIndex;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAML2IdentityProviderMetadataResolver
implements SAML2MetadataResolver {
    private static final long NO_LAST_MODIFIED = -1L;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Resource idpMetadataResource;
    private final ReentrantLock lock = new ReentrantLock();
    private String idpEntityId;
    private MetadataResolver metadataResolver;
    private long lastModified = -1L;
    private Proxy proxy = Proxy.NO_PROXY;
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory sslSocketFactory;

    public SAML2IdentityProviderMetadataResolver(SAML2Configuration configuration) {
        this(configuration.getIdentityProviderMetadataResource(), configuration.getIdentityProviderEntityId());
        if (configuration.getSslSocketFactory() != null) {
            this.setSslSocketFactory(configuration.getSslSocketFactory());
        }
        if (configuration.getHostnameVerifier() != null) {
            this.setHostnameVerifier(configuration.getHostnameVerifier());
        }
    }

    public SAML2IdentityProviderMetadataResolver(Resource idpMetadataResource, @Nullable String idpEntityId) {
        CommonHelper.assertNotNull((String)"identityProviderMetadataResource", (Object)idpMetadataResource);
        this.idpMetadataResource = idpMetadataResource;
        this.idpEntityId = idpEntityId;
    }

    public void init() {
        this.metadataResolver = this.buildMetadataResolver();
        this.hasChanged();
    }

    @Override
    public final MetadataResolver resolve(boolean force) {
        if (this.lock.tryLock()) {
            try {
                boolean reload;
                boolean bl = reload = force || this.hasChanged();
                if (reload) {
                    this.metadataResolver = this.buildMetadataResolver();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.metadataResolver;
    }

    boolean hasChanged() {
        long newLastModified;
        try {
            newLastModified = this.idpMetadataResource.lastModified();
        }
        catch (Exception e) {
            newLastModified = -1L;
        }
        boolean hasChanged = this.lastModified != newLastModified;
        this.logger.debug("lastModified: {} / newLastModified: {} -> hasChanged: {}", new Object[]{this.lastModified, newLastModified, hasChanged});
        this.lastModified = newLastModified;
        return hasChanged;
    }

    protected MetadataResolver buildMetadataResolver() {
        DOMMetadataResolver resolver = this.initializeMetadataResolver();
        this.determineIdentityProviderEntityId((IterableMetadataSource)resolver);
        return resolver;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    private void determineIdentityProviderEntityId(IterableMetadataSource resolver) {
        Iterator it;
        if (this.idpEntityId == null && (it = resolver.iterator()).hasNext()) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)it.next();
            this.idpEntityId = entityDescriptor.getEntityID();
        }
        if (this.idpEntityId == null) {
            throw new SAMLException("No idp entityId found");
        }
    }

    private DOMMetadataResolver initializeMetadataResolver() {
        DOMMetadataResolver dOMMetadataResolver;
        block11: {
            InputStream in = this.getMetadataResourceInputStream();
            try {
                Document parsedInput = Configuration.getParserPool().parse(in);
                Element metadataRoot = parsedInput.getDocumentElement();
                DOMMetadataResolver resolver = new DOMMetadataResolver(metadataRoot);
                resolver.setIndexes(Collections.singleton(new RoleMetadataIndex()));
                resolver.setParserPool(Configuration.getParserPool());
                resolver.setFailFastInitialization(true);
                resolver.setRequireValidMetadata(true);
                resolver.setId(resolver.getClass().getCanonicalName());
                resolver.initialize();
                dOMMetadataResolver = resolver;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new TechnicalException("Error loading idp metadata", (Throwable)e);
                }
                catch (ComponentInitializationException e) {
                    throw new TechnicalException("Error initializing idp metadata resolver", (Throwable)e);
                }
                catch (XMLParserException e) {
                    throw new TechnicalException("Error parsing idp metadata", (Throwable)e);
                }
                catch (IOException e) {
                    throw new TechnicalException("Error getting idp metadata resource", (Throwable)e);
                }
            }
            in.close();
        }
        return dOMMetadataResolver;
    }

    protected InputStream getMetadataResourceInputStream() throws IOException {
        if (this.idpMetadataResource instanceof UrlResource) {
            URLConnection con = this.idpMetadataResource.getURL().openConnection(this.proxy);
            if (con instanceof HttpsURLConnection) {
                HttpsURLConnection connection = (HttpsURLConnection)con;
                if (this.sslSocketFactory != null) {
                    connection.setSSLSocketFactory(this.sslSocketFactory);
                }
                if (this.hostnameVerifier != null) {
                    connection.setHostnameVerifier(this.hostnameVerifier);
                }
            }
            try {
                return con.getInputStream();
            }
            catch (Exception e) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                throw new TechnicalException("Error getting idp metadata resource", (Throwable)e);
            }
        }
        return this.idpMetadataResource.getInputStream();
    }

    @Override
    public String getEntityId() {
        XMLObject md = this.getEntityDescriptorElement();
        if (md instanceof EntitiesDescriptor) {
            return ((EntityDescriptor)((EntitiesDescriptor)md).getEntityDescriptors().get(0)).getEntityID();
        }
        if (md instanceof EntityDescriptor) {
            return ((EntityDescriptor)md).getEntityID();
        }
        throw new SAMLException("No idp entityId found");
    }

    @Override
    public String getMetadata() {
        if (this.getEntityDescriptorElement() != null) {
            return Configuration.serializeSamlObject(this.getEntityDescriptorElement()).toString();
        }
        throw new TechnicalException("Metadata cannot be retrieved because entity descriptor is null");
    }

    @Override
    public final XMLObject getEntityDescriptorElement() {
        try {
            return (XMLObject)this.resolve().resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.idpEntityId)}));
        }
        catch (ResolverException e) {
            throw new SAMLException("Error initializing idpMetadataProvider", e);
        }
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }
}

