/*
 * Decompiled with CFR 0.152.
 */
package org.plutext.msgraph.convert;

import org.plutext.msgraph.convert.AuthConfig;
import org.plutext.msgraph.convert.OpenXmlToPDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenXmlToPDF
implements OpenXmlToPDF {
    private static final Logger log = LoggerFactory.getLogger(AbstractOpenXmlToPDF.class);
    protected AuthConfig authConfig;
    protected static final String DOCX_MIME_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    protected static final String PPTX_MIME_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    protected static final String XLSX_MIME_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    protected static final String DOCX_MEDIA_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document; charset=utf-8";
    protected static final String PPTX_MEDIA_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.presentation; charset=utf-8";
    protected static final String XLSX_MEDIA_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; charset=utf-8";

    public AbstractOpenXmlToPDF(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    protected String mimeTypeToExt(String mimetype) {
        if (mimetype.startsWith(DOCX_MIME_TYPE)) {
            return ".docx";
        }
        if (mimetype.startsWith(PPTX_MIME_TYPE)) {
            return ".pptx";
        }
        if (mimetype.startsWith(XLSX_MIME_TYPE)) {
            return ".xlsx";
        }
        log.error("Unknown mimetype " + mimetype);
        return ".docx";
    }
}

