/*
 * Decompiled with CFR 0.152.
 */
package lombok.core.configuration;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import lombok.ConfigurationKeys;
import lombok.core.configuration.ConfigurationProblemReporter;
import lombok.core.configuration.ConfigurationSource;
import lombok.core.configuration.StringConfigurationSource;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemSourceCache {
    private static String LOMBOK_CONFIG_FILENAME = "lombok.config";
    private static final long RECHECK_FILESYSTEM = TimeUnit.SECONDS.toMillis(2L);
    private static final long MISSING = -1L;
    private final ConcurrentMap<File, Content> cache = new ConcurrentHashMap<File, Content>();
    private static final ThreadLocal<byte[]> buffers = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[65536];
        }
    };

    public Iterable<ConfigurationSource> sourcesForJavaFile(URI javaFile, ConfigurationProblemReporter reporter) {
        if (javaFile == null) {
            return Collections.emptyList();
        }
        URI uri = javaFile.normalize();
        if (!uri.isAbsolute()) {
            uri = new File(".").toURI().resolve(uri);
            reporter.report(javaFile.toString(), "Somehow ended up with a relative path. This is a bug that the lombok authors cannot reproduce, so please help us out! Is this path: \"" + uri.toString() + "\" the correct absolute path for resource \"" + javaFile + "\"? If yes, or no, please report back to: https://code.google.com/p/projectlombok/issues/detail?id=683 and let us know. Thanks!", 0, "");
        }
        try {
            return this.sourcesForDirectory(new File(uri).getParentFile(), reporter);
        }
        catch (Exception e) {
            int filesOpenedWithEclipse = 0;
            String specialEclipseMessage = null;
            try {
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
                if (files == null) {
                    specialEclipseMessage = ".findFilesForLocationURI returned 'null'";
                }
                for (IFile file : files) {
                    InputStream in = file.getContents(true);
                    if (in == null) continue;
                    ++filesOpenedWithEclipse;
                    in.close();
                }
                if (filesOpenedWithEclipse == 0) {
                    specialEclipseMessage = ".findFilesForLocationURI did work and returned " + files.length + " entries, but none of those resulted in readable contents.";
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Lombok is trying to find the directory on disk where source file \"").append(javaFile.toString());
            sb.append("\" is located. We're trying to turn this URL into a file: \"").append(uri.toString());
            sb.append("\" but that isn't working. Please help us out by going to ");
            sb.append("https://code.google.com/p/projectlombok/issues/detail?id=683 and reporting this error. Thanks!\n\n");
            sb.append("Exception thrown: ").append(e.getClass().getName()).append("\nException msg: ").append(e.getMessage());
            if (specialEclipseMessage == null && filesOpenedWithEclipse > 0) {
                sb.append("\n\n Alternate strategy to read this resource via eclipse DID WORK however!! files read: " + filesOpenedWithEclipse);
            } else if (specialEclipseMessage != null) {
                sb.append("\n\n Alternate strategy to read this resource via eclipse produced a noteworthy result: ").append(specialEclipseMessage).append(" files read: ").append(filesOpenedWithEclipse);
            }
            reporter.report(javaFile.toString(), sb.toString(), 0, "");
            try {
                EclipseHandlerUtil.warning(sb.toString(), null);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            return Collections.emptyList();
        }
    }

    public Iterable<ConfigurationSource> sourcesForDirectory(URI directory, ConfigurationProblemReporter reporter) {
        if (directory == null) {
            return Collections.emptyList();
        }
        return this.sourcesForDirectory(new File(directory.normalize()), reporter);
    }

    private Iterable<ConfigurationSource> sourcesForDirectory(final File directory, final ConfigurationProblemReporter reporter) {
        return new Iterable<ConfigurationSource>(){

            @Override
            public Iterator<ConfigurationSource> iterator() {
                return new Iterator<ConfigurationSource>(){
                    File currentDirectory;
                    ConfigurationSource next;
                    boolean stopBubbling;
                    {
                        this.currentDirectory = directory;
                        this.stopBubbling = false;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next != null) {
                            return true;
                        }
                        if (this.stopBubbling) {
                            return false;
                        }
                        this.next = this.findNext();
                        return this.next != null;
                    }

                    @Override
                    public ConfigurationSource next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ConfigurationSource result = this.next;
                        this.next = null;
                        return result;
                    }

                    private ConfigurationSource findNext() {
                        while (this.currentDirectory != null && this.next == null) {
                            this.next = FileSystemSourceCache.this.getSourceForDirectory(this.currentDirectory, reporter);
                            this.currentDirectory = this.currentDirectory.getParentFile();
                        }
                        if (this.next != null) {
                            ConfigurationSource.Result stop = this.next.resolve(ConfigurationKeys.STOP_BUBBLING);
                            this.stopBubbling = stop != null && Boolean.TRUE.equals(stop.getValue());
                        }
                        return this.next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationSource getSourceForDirectory(File directory, ConfigurationProblemReporter reporter) {
        Content content;
        if (!directory.exists() && !directory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + directory);
        }
        long now = System.currentTimeMillis();
        File configFile = new File(directory, LOMBOK_CONFIG_FILENAME);
        Content content2 = content = this.ensureContent(directory);
        synchronized (content2) {
            if (content.lastChecked != -1L && now - content.lastChecked < RECHECK_FILESYSTEM && FileSystemSourceCache.getLastModified(configFile) == content.lastModified) {
                return content.source;
            }
            content.lastChecked = now;
            long previouslyModified = content.lastModified;
            content.lastModified = FileSystemSourceCache.getLastModified(configFile);
            if (content.lastModified != previouslyModified) {
                content.source = content.lastModified == -1L ? null : this.parse(configFile, reporter);
            }
            return content.source;
        }
    }

    private Content ensureContent(File directory) {
        Content content = (Content)this.cache.get(directory);
        if (content != null) {
            return content;
        }
        this.cache.putIfAbsent(directory, Content.empty());
        return (Content)this.cache.get(directory);
    }

    private ConfigurationSource parse(File configFile, ConfigurationProblemReporter reporter) {
        String contentDescription = configFile.getAbsolutePath();
        try {
            return StringConfigurationSource.forString(FileSystemSourceCache.fileToString(configFile), reporter, contentDescription);
        }
        catch (Exception e) {
            reporter.report(contentDescription, "Exception while reading file: " + e.getMessage(), 0, null);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String fileToString(File configFile) throws Exception {
        byte[] b = buffers.get();
        FileInputStream fis = new FileInputStream(configFile);
        try {
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((r = fis.read(b)) != -1) {
                out.write(b, 0, r);
            }
            String string = new String(out.toByteArray(), "UTF-8");
            return string;
        }
        finally {
            fis.close();
        }
    }

    private static final long getLastModified(File file) {
        if (!file.exists() || !file.isFile()) {
            return -1L;
        }
        return file.lastModified();
    }

    private static class Content {
        ConfigurationSource source;
        long lastModified;
        long lastChecked;

        private Content(ConfigurationSource source, long lastModified, long lastChecked) {
            this.source = source;
            this.lastModified = lastModified;
            this.lastChecked = lastChecked;
        }

        static Content empty() {
            return new Content(null, -1L, -1L);
        }
    }
}

