/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.RemoveLeadingLineBreakAndSpacesParser;
import org.rythmengine.internal.parser.build_in.IfThenToken;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;

public class ContinueParser
extends KeywordParserFactory {
    private static final String R = "^(\\n?[ \\t\\x0B\\f]*%s%s\\s*((?@()))?[\\s;]*)";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(IContext c) {
        return new RemoveLeadingLineBreakAndSpacesParser(c){

            @Override
            public Token go() {
                Regex r = ContinueParser.this.reg(this.dialect());
                if (r.search(this.remain())) {
                    IContext.Continue c;
                    this.step(r.stringMatched().length());
                    String condition = r.stringMatched(3);
                    if (null != condition) {
                        condition = S.stripBrace(condition);
                    }
                    if (null == (c = this.ctx().peekContinue())) {
                        this.raiseParseException("Bad @continue statement: No loop context", new Object[0]);
                    }
                    if (S.notEmpty(condition)) {
                        return new IfThenToken(condition, "continue", this.ctx());
                    }
                    return new CodeToken(c.getStatement(), this.ctx());
                }
                this.raiseParseException("Bad @continue statement. Correct usage: @continue()", new Object[0]);
                return null;
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.CONTINUE;
    }
}

