/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.IfThenToken;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;

public class ReturnIfParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.RETURN_IF;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public Token go() {
                Regex r0;
                String matched;
                Regex r = ReturnIfParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("error parsing @returnIf, correct usage: @returnIf(<expression>)", new Object[0]);
                }
                if ((matched = r.stringMatched()).startsWith("\n") || matched.endsWith("\n")) {
                    String blank;
                    r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    String blank;
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                this.step(matched.length());
                String condition = r.stringMatched(2);
                if (null != condition) {
                    condition = S.stripBrace(condition);
                }
                if (S.empty(condition)) {
                    this.raiseParseException("expression required by @returnIf directive", new Object[0]);
                }
                return new IfThenToken(condition, "return this", this.ctx());
            }
        };
    }

    @Override
    protected String patternStr() {
        return "^(\\n?[ \\t\\x0B\\f]*%s%s\\s*((?@()))[\\s;]*)";
    }
}

