/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mvel2.MVEL;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.VariableResolverFactory;
import org.rythmengine.Rythm;
import org.rythmengine.Sandbox;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.exception.RythmException;
import org.rythmengine.exception.TagLoadException;
import org.rythmengine.extension.ICacheService;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.IDateFormatFactory;
import org.rythmengine.extension.IDurationParser;
import org.rythmengine.extension.IFormatter;
import org.rythmengine.extension.ILoggerFactory;
import org.rythmengine.extension.IPropertyAccessor;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.extension.Transformer;
import org.rythmengine.internal.EventBus;
import org.rythmengine.internal.ExtensionManager;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.IEvent;
import org.rythmengine.internal.IEventDispatcher;
import org.rythmengine.internal.IJavaExtension;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.RythmEvents;
import org.rythmengine.internal.compiler.ClassReloadException;
import org.rythmengine.internal.compiler.ParamTypeInferencer;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.internal.compiler.TemplateClassCache;
import org.rythmengine.internal.compiler.TemplateClassLoader;
import org.rythmengine.internal.compiler.TemplateClassManager;
import org.rythmengine.internal.dialect.AutoToString;
import org.rythmengine.internal.dialect.BasicRythm;
import org.rythmengine.internal.dialect.DialectManager;
import org.rythmengine.internal.dialect.ToString;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.logger.NullLogger;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.StringTemplateResource;
import org.rythmengine.resource.TemplateResourceManager;
import org.rythmengine.resource.ToStringTemplateResource;
import org.rythmengine.sandbox.RythmSecurityManager;
import org.rythmengine.sandbox.SandboxExecutingService;
import org.rythmengine.sandbox.SandboxThreadFactory;
import org.rythmengine.template.EmptyTemplate;
import org.rythmengine.template.ITag;
import org.rythmengine.template.ITemplate;
import org.rythmengine.template.JavaTagBase;
import org.rythmengine.template.TemplateBase;
import org.rythmengine.toString.ToStringOption;
import org.rythmengine.toString.ToStringStyle;
import org.rythmengine.utils.F;
import org.rythmengine.utils.JSONWrapper;
import org.rythmengine.utils.S;
import osgl.version.Version;
import osgl.version.Versioned;

@Versioned
public class RythmEngine
implements IEventDispatcher {
    public static final Version VERSION = Version.of(RythmEngine.class);
    private static final ILogger logger = Logger.get(RythmEngine.class);
    private static final String version = VERSION.getVersion();
    private static final InheritableThreadLocal<RythmEngine> _engine = new InheritableThreadLocal();
    private RythmConfiguration _conf = null;
    private Rythm.Mode _mode = null;
    private String _id = null;
    private TemplateResourceManager _resourceManager;
    private TemplateClassManager _classes;
    private TemplateClassLoader _classLoader = null;
    private TemplateClassCache _classCache = null;
    private ExtensionManager _extensionManager;
    private final DialectManager _dialectManager = new DialectManager();
    private ICacheService _cacheService = null;
    private IDateFormatFactory _dateFormatFactory = IDateFormatFactory.DefaultDateFormatFactory.INSTANCE;
    public RenderSettings renderSettings;
    private String secureCode = null;
    private Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private Set<String> nonExistsTemplates = new CopyOnWriteArraySet<String>();
    private NonExistsTemplatesChecker nonExistsTemplatesChecker = null;
    private Map<String, Serializable> mvels = new ConcurrentHashMap<String, Serializable>();
    private final Map<String, ITemplate> _templates = new ConcurrentHashMap<String, ITemplate>();
    private final Map<String, JavaTagBase> _tags = new ConcurrentHashMap<String, JavaTagBase>();
    private final Set<String> _nonTmpls = new CopyOnWriteArraySet<String>();
    private Set<String> _nonExistsTags = new CopyOnWriteArraySet<String>();
    private Map<TemplateClass, Set<TemplateClass>> extendMap = new ConcurrentHashMap<TemplateClass, Set<TemplateClass>>();
    private SandboxExecutingService _secureExecutor = null;
    private IEventDispatcher eventDispatcher = null;
    private static final InheritableThreadLocal<OutputMode> outputMode = new InheritableThreadLocal<OutputMode>(){

        @Override
        protected OutputMode initialValue() {
            return OutputMode.str;
        }
    };
    public static final String[] VALID_SUFFIXES = new String[]{".html", ".json", ".js", ".css", ".csv", ".tag", ".xml", ".txt", ".rythm"};
    private IShutdownListener shutdownListener = null;
    private boolean zombie = false;

    public static boolean set(RythmEngine engine) {
        if (_engine.get() == null) {
            _engine.set(engine);
            return true;
        }
        return false;
    }

    public static void clear() {
        _engine.remove();
    }

    public static RythmEngine get() {
        return (RythmEngine)_engine.get();
    }

    public static boolean insideSandbox() {
        return Sandbox.sandboxMode();
    }

    public String toString() {
        return null == this._conf ? "rythm-engine-uninitialized" : this.id();
    }

    public RythmConfiguration conf() {
        if (null == this._conf) {
            throw new IllegalStateException("Rythm engine not initialized");
        }
        return this._conf;
    }

    public String version() {
        return version + "-" + this.conf().pluginVersion();
    }

    public Rythm.Mode mode() {
        if (null == this._mode) {
            this._mode = (Rythm.Mode)((Object)this.conf().get(RythmConfigurationKey.ENGINE_MODE));
        }
        return this._mode;
    }

    public String id() {
        if (null == this._id) {
            this._id = (String)this.conf().get(RythmConfigurationKey.ENGINE_ID);
        }
        return this._id;
    }

    public String getId() {
        return this.id();
    }

    public boolean isSingleton() {
        return Rythm.engine == this;
    }

    public boolean isProdMode() {
        return this.mode() == Rythm.Mode.prod;
    }

    public boolean isDevMode() {
        return this.mode() != Rythm.Mode.prod;
    }

    public TemplateResourceManager resourceManager() {
        return this._resourceManager;
    }

    public TemplateClassManager classes() {
        return this._classes;
    }

    public TemplateClassLoader classLoader() {
        return this._classLoader;
    }

    public TemplateClassCache classCache() {
        return this._classCache;
    }

    public ExtensionManager extensionManager() {
        return this._extensionManager;
    }

    public DialectManager dialectManager() {
        return this._dialectManager;
    }

    public void setDateFormatFactory(IDateFormatFactory factory) {
        this._dateFormatFactory = Objects.requireNonNull(factory);
    }

    public IDateFormatFactory dateFormatFactory() {
        return this._dateFormatFactory;
    }

    public final RythmEngine prepare(ICodeType codeType, Locale locale, Map<String, Object> usrCtx) {
        this.renderSettings.init(codeType).init(locale).init(usrCtx);
        return this;
    }

    public final RythmEngine prepare(ICodeType codeType) {
        this.renderSettings.init(codeType);
        return this;
    }

    public final RythmEngine prepare(Locale locale) {
        this.renderSettings.init(locale);
        return this;
    }

    public final RythmEngine prepare(Map<String, Object> userContext) {
        this.renderSettings.init(userContext);
        return this;
    }

    private void _initLogger(Map<String, ?> conf) {
        boolean logEnabled = (Boolean)RythmConfigurationKey.LOG_ENABLED.getConfiguration(conf);
        if (logEnabled) {
            ILoggerFactory factory = (ILoggerFactory)RythmConfigurationKey.LOG_FACTORY_IMPL.getConfiguration(conf);
            Logger.registerLoggerFactory(factory);
        } else {
            Logger.registerLoggerFactory(new NullLogger.Factory());
        }
    }

    private Map<String, Object> _processConf(Map<String, ?> conf) {
        ConcurrentHashMap<String, Object> m = new ConcurrentHashMap<String, Object>(conf.size());
        for (String s : conf.keySet()) {
            Object o = conf.get(s);
            if (s.startsWith("rythm.")) {
                s = s.replaceFirst("rythm\\.", "");
            }
            m.put(s, o);
        }
        return m;
    }

    private void _initConf(Map<String, ?> conf, File confFile) {
        RythmConfiguration rc;
        Map<String, Object> rawConf = this._loadConfFromDisk(confFile);
        rawConf = this._processConf(rawConf);
        Properties sysProps = System.getProperties();
        rawConf.putAll(sysProps);
        if (null != conf) {
            rawConf.putAll(this._processConf(conf));
        }
        this._initLogger(rawConf);
        this._conf = rc = new RythmConfiguration(rawConf, this);
        ILoggerFactory logFact = (ILoggerFactory)rc.get(RythmConfigurationKey.LOG_FACTORY_IMPL);
        Logger.registerLoggerFactory(logFact);
        if (rawConf.containsKey("rythm.debug_conf") && Boolean.parseBoolean(rawConf.get("rythm.debug_conf").toString())) {
            rc.debug();
        }
    }

    public RythmEngine() {
        this.init(null, null);
    }

    public RythmEngine(File file) {
        this.init(null, file);
    }

    public RythmEngine(Properties userConfiguration) {
        this((Map<String, ?>)userConfiguration);
    }

    public RythmEngine(Map<String, ?> userConfiguration) {
        this.init(userConfiguration, null);
    }

    public void setProperty(String key, Object val) {
        this.properties.put(key, val);
    }

    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map _loadConfFromDisk(File conf) {
        InputStream is;
        block18: {
            is = null;
            boolean emptyConf = false;
            if (null == conf) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (null == cl) {
                    cl = Rythm.class.getClassLoader();
                }
                is = cl.getResourceAsStream("rythm.conf");
            } else {
                try {
                    is = new FileInputStream(conf);
                }
                catch (IOException e) {
                    if (emptyConf) break block18;
                    logger.warn(e, "Error opening conf file:" + conf, new Object[0]);
                }
            }
        }
        if (null != is) {
            Properties p = new Properties();
            try {
                p.load(is);
                Properties properties = p;
                return properties;
            }
            catch (Exception e) {
                logger.warn(e, "Error loading rythm.conf", new Object[0]);
            }
            finally {
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return new ConcurrentHashMap();
    }

    private void init(Map<String, ?> conf, File file) {
        boolean enableBuiltInTemplateLang;
        if (null == file || file.isDirectory()) {
            this._initConf(conf, null);
            if (null != file) {
                this._conf.setTemplateHome(file);
            }
        } else if (file.isFile() && file.canRead()) {
            this._initConf(conf, file);
        }
        this.renderSettings = new RenderSettings(this._conf);
        this._mode = (Rythm.Mode)((Object)this._conf.get(RythmConfigurationKey.ENGINE_MODE));
        this._classes = new TemplateClassManager(this);
        this._classLoader = new TemplateClassLoader(this);
        this._classCache = new TemplateClassCache(this);
        this._resourceManager = new TemplateResourceManager(this);
        this._extensionManager = new ExtensionManager(this);
        int ttl = (Integer)this._conf.get(RythmConfigurationKey.DEFAULT_CACHE_TTL);
        this._cacheService = (ICacheService)this._conf.get(RythmConfigurationKey.CACHE_SERVICE_IMPL);
        this._cacheService.setDefaultTTL(ttl);
        this._cacheService.startup();
        boolean enableBuiltInJavaExtensions = (Boolean)this._conf.get(RythmConfigurationKey.BUILT_IN_TRANSFORMER_ENABLED);
        if (enableBuiltInJavaExtensions) {
            this.registerTransformer("rythm", "([^a-zA-Z0-9_]s\\(\\)|^s\\(\\))", S.class);
        }
        if (enableBuiltInTemplateLang = ((Boolean)this._conf.get(RythmConfigurationKey.BUILT_IN_CODE_TYPE_ENABLED)).booleanValue()) {
            ExtensionManager em = this.extensionManager();
            em.registerCodeType(ICodeType.DefImpl.HTML);
            em.registerCodeType(ICodeType.DefImpl.JS);
            em.registerCodeType(ICodeType.DefImpl.JSON);
            em.registerCodeType(ICodeType.DefImpl.CSV);
            em.registerCodeType(ICodeType.DefImpl.CSS);
        }
        this._templates.clear();
        this._templates.put("chain", new JavaTagBase(){

            @Override
            protected void call(ITag.__ParameterList params, ITag.__Body body) {
                body.render(this.__getBuffer(), new Object[0]);
            }
        });
        List<Class> udts = this._conf.getList(RythmConfigurationKey.EXT_TRANSFORMER_IMPLS, Class.class);
        this.registerTransformer(udts.toArray(new Class[0]));
        List<IPropertyAccessor> udpa = this._conf.getList(RythmConfigurationKey.EXT_PROP_ACCESSOR_IMPLS, IPropertyAccessor.class);
        this.registerPropertyAccessor(udpa.toArray(new IPropertyAccessor[0]));
        List<Class> udfmt = this._conf.getList(RythmConfigurationKey.EXT_FORMATTER_IMPLS, Class.class);
        this.registerFormatter(udfmt.toArray(new Class[0]));
        try {
            Class.forName("org.joda.time.DateTime");
            Class<?> fmtCls = Class.forName("org.rythmengine.extension.JodaDateTimeFormatter");
            IFormatter fmt = (IFormatter)fmtCls.newInstance();
            this.extensionManager().registerFormatter(fmt);
        }
        catch (Exception e) {
            logger.info("joda time class not found. Formatter to joda time not registered", new Object[0]);
        }
        if (this.conf().autoScan()) {
            this.resourceManager().scan();
        }
        if (this.conf().gae()) {
            logger.warn("Rythm engine : GAE in cloud enabled", new Object[0]);
        }
        logger.debug("Rythm-%s started in %s mode", new Object[]{version, this.mode()});
    }

    public void registerFormatter(Class<IFormatter> ... formatterClasses) {
        for (Class<IFormatter> cls : formatterClasses) {
            try {
                IFormatter fmt = cls.newInstance();
                this.extensionManager().registerFormatter(fmt);
            }
            catch (Exception e) {
                Logger.error(e, "Error get formatter instance from class[%s]", cls);
            }
        }
    }

    public void registerFormatter(IFormatter ... formatters) {
        for (IFormatter fmt : formatters) {
            this.extensionManager().registerFormatter(fmt);
        }
    }

    public void registerTransformer(Class<?> ... transformerClasses) {
        this.registerTransformer((String)null, (String)null, transformerClasses);
    }

    public void registerTransformer(String namespace, String waivePattern, Class<?> ... transformerClasses) {
        ExtensionManager jem = this.extensionManager();
        for (Class<?> extensionClass : transformerClasses) {
            Transformer t = extensionClass.getAnnotation(Transformer.class);
            boolean classAnnotated = null != t;
            String nmsp = namespace;
            boolean namespaceIsEmpty = S.empty(namespace);
            if (classAnnotated && namespaceIsEmpty) {
                nmsp = t.value();
            }
            String waive = waivePattern;
            boolean waiveIsEmpty = S.empty(waive);
            if (classAnnotated && waiveIsEmpty) {
                waive = t.waivePattern();
            }
            boolean clsRequireTemplate = null == t ? false : t.requireTemplate();
            boolean clsLastParam = null == t ? false : t.lastParam();
            for (Method m : extensionClass.getDeclaredMethods()) {
                boolean methodAnnotated;
                int len;
                int flag = m.getModifiers();
                if (!Modifier.isPublic(flag) || !Modifier.isStatic(flag) || (len = m.getParameterTypes().length) <= 0) continue;
                Transformer tm = m.getAnnotation(Transformer.class);
                boolean bl = methodAnnotated = null != tm;
                if (!methodAnnotated && !classAnnotated) continue;
                String mnmsp = nmsp;
                if (methodAnnotated && namespaceIsEmpty && S.empty(mnmsp = tm.value())) {
                    mnmsp = nmsp;
                }
                String mwaive = waive;
                if (methodAnnotated && waiveIsEmpty && S.empty(mwaive = tm.waivePattern())) {
                    mwaive = waive;
                }
                String cn = extensionClass.getSimpleName();
                if (S.empty(mwaive)) {
                    mwaive = cn;
                }
                boolean requireTemplate = clsRequireTemplate;
                if (null != tm && tm.requireTemplate()) {
                    requireTemplate = true;
                }
                boolean lastParam = clsLastParam;
                if (null != tm && tm.lastParam()) {
                    lastParam = true;
                }
                String cn0 = extensionClass.getName();
                String mn = m.getName();
                String fullName = String.format("%s.%s", cn0, mn);
                if (S.notEmpty(mnmsp) && !"rythm".equals(mnmsp)) {
                    mn = mnmsp + "_" + mn;
                }
                if (len == 1) {
                    jem.registerJavaExtension(new IJavaExtension.VoidParameterExtension(mwaive, mn, fullName, requireTemplate));
                    continue;
                }
                jem.registerJavaExtension(new IJavaExtension.ParameterExtension(mwaive, mn, ".+", fullName, requireTemplate, lastParam));
            }
        }
    }

    public void registerPropertyAccessor(IPropertyAccessor ... accessors) {
        for (IPropertyAccessor a : accessors) {
            this._registerPropertyAccessor(a);
        }
        PropertyHandlerFactory.unregisterPropertyHandler(Serializable.class);
    }

    private void _registerPropertyAccessor(final IPropertyAccessor a) {
        PropertyHandlerFactory.registerPropertyHandler((Class)a.getTargetType(), (PropertyHandler)new PropertyHandler(){

            public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
                return a.getProperty(name, contextObj);
            }

            public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
                return a.setProperty(name, contextObj, value);
            }
        });
    }

    public void registerResourceLoader(ITemplateResourceLoader ... loaders) {
        if (null == this._resourceManager) {
            throw new IllegalStateException("Engine not initialized");
        }
        for (int i = loaders.length - 1; i >= 0; --i) {
            ITemplateResourceLoader loader = loaders[i];
            this._resourceManager.prependResourceLoader(loader);
        }
    }

    private void setRenderArgs(ITemplate t, Object ... args) {
        if (null == args) {
            t.__setRenderArg(0, null);
        } else if (1 == args.length) {
            Object o0 = args[0];
            if (o0 instanceof Map) {
                t.__setRenderArgs((Map)args[0]);
            } else if (o0 instanceof JSONWrapper) {
                t.__setRenderArg((JSONWrapper)o0);
            } else {
                t.__setRenderArgs(args);
            }
        } else {
            t.__setRenderArgs(args);
        }
    }

    @Deprecated
    private void handleCCE(ClassCastException ce) {
    }

    private ITemplate getTemplate(IDialect dialect, String template, Object ... args) {
        TemplateClass tc;
        if (S.empty(template)) {
            return EmptyTemplate.INSTANCE;
        }
        boolean typeInferenceEnabled = this.conf().typeInferenceEnabled();
        if (typeInferenceEnabled) {
            ParamTypeInferencer.registerParams(this, args);
        }
        String key = template;
        if (typeInferenceEnabled) {
            key = key + ParamTypeInferencer.uuid();
        }
        if (null == (tc = this.classes().getByTemplate(key))) {
            tc = new TemplateClass(template, this, dialect);
        }
        ITemplate t = tc.asTemplate(this);
        this.setRenderArgs(t, args);
        return t;
    }

    public ITemplate getTemplate(String template, Object ... args) {
        return this.getTemplate(null, template, args);
    }

    public TemplateClass getTemplateClass(ITemplateResource resource) {
        String key = S.str(resource.getKey());
        TemplateClass tc = this.classes().getByTemplate(key);
        if (null == tc) {
            tc = new TemplateClass(resource, this);
        }
        return tc;
    }

    public ITemplate getTemplate(File file, Object ... args) {
        ITemplate t;
        TemplateClass tc;
        boolean typeInferenceEnabled = this.conf().typeInferenceEnabled();
        if (typeInferenceEnabled) {
            ParamTypeInferencer.registerParams(this, args);
        }
        String key = S.str(this.resourceManager().get(file).getKey());
        if (typeInferenceEnabled) {
            key = key + ParamTypeInferencer.uuid();
        }
        if (null == (tc = this.classes().getByTemplate(key))) {
            tc = new TemplateClass(file, this);
            t = tc.asTemplate(this);
            if (null == t) {
                return null;
            }
            this._templates.put(tc.getKey(), t);
        } else {
            t = tc.asTemplate(this);
        }
        this.setRenderArgs(t, args);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String render(String template, Object ... args) {
        try {
            ITemplate t = this.getTemplate(template, args);
            String string = t.render();
            return string;
        }
        finally {
            RythmEngine.renderCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(OutputStream os, String template, Object ... args) {
        outputMode.set(OutputMode.os);
        try {
            ITemplate t = this.getTemplate(template, args);
            t.render(os);
        }
        finally {
            RythmEngine.renderCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Writer w, String template, Object ... args) {
        outputMode.set(OutputMode.writer);
        try {
            ITemplate t = this.getTemplate(template, args);
            t.render(w);
        }
        finally {
            RythmEngine.renderCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String render(File file, Object ... args) {
        try {
            if (!file.exists()) {
                throw new RuntimeException("template '" + file.getName() + "' does not exist!");
            }
            if (!file.canRead()) {
                throw new RuntimeException("template '" + file.getName() + "' not readable!");
            }
            ITemplate t = this.getTemplate(file, args);
            if (t == null) {
                throw new RuntimeException("template '" + file.getName() + "' load failed!");
            }
            String string = t.render();
            return string;
        }
        finally {
            RythmEngine.renderCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(OutputStream os, File file, Object ... args) {
        outputMode.set(OutputMode.os);
        try {
            ITemplate t = this.getTemplate(file, args);
            t.render(os);
        }
        finally {
            RythmEngine.renderCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Writer w, File file, Object ... args) {
        outputMode.set(OutputMode.writer);
        try {
            ITemplate t = this.getTemplate(file, args);
            t.render(w);
        }
        finally {
            RythmEngine.renderCleanUp();
        }
    }

    public String renderStr(String key, String template, Object ... args) {
        return this.renderString(key, template, args);
    }

    public String renderStr(String template, Object ... args) {
        return this.renderString(template, args);
    }

    public String renderString(String template, Object ... args) {
        return this.renderString(template, template, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderString(String key, String template, Object ... args) {
        boolean typeInferenceEnabled = this.conf().typeInferenceEnabled();
        if (typeInferenceEnabled) {
            ParamTypeInferencer.registerParams(this, args);
        }
        if (typeInferenceEnabled) {
            key = key + ParamTypeInferencer.uuid();
        }
        try {
            TemplateClass tc = this.classes().getByTemplate(key, false);
            if (null == tc) {
                tc = new TemplateClass(new StringTemplateResource(key, template), this);
            }
            ITemplate t = tc.asTemplate(this);
            this.setRenderArgs(t, args);
            String string = t.render();
            return string;
        }
        finally {
            RythmEngine.renderCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String substitute(String template, Object ... args) {
        try {
            ITemplate t = this.getTemplate(BasicRythm.INSTANCE, template, args);
            String string = t.render();
            return string;
        }
        finally {
            RythmEngine.renderCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String substitute(File file, Object ... args) {
        try {
            ITemplate t = this.getTemplate(file, args, BasicRythm.INSTANCE);
            String string = t.render();
            return string;
        }
        finally {
            RythmEngine.renderCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(String template, Object obj) {
        Class<?> argClass = obj.getClass();
        String clsName = argClass.getName();
        if (clsName.matches(".*\\$[0-9].*")) {
            argClass = obj.getClass().getSuperclass();
        }
        String key = template + argClass;
        try {
            TemplateClass tc = this.classes().getByTemplate(key);
            if (null == tc) {
                tc = new TemplateClass(template, this, (IDialect)new ToString(argClass));
            }
            ITemplate t = tc.asTemplate(this);
            t.__setRenderArg(0, obj);
            String string = t.render();
            return string;
        }
        finally {
            RythmEngine.renderCleanUp();
        }
    }

    public String toString(Object obj) {
        return this.toString(obj, ToStringOption.DEFAULT_OPTION, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Object obj, ToStringOption option, ToStringStyle style) {
        Class<?> c = obj.getClass();
        AutoToString.AutoToStringData key = new AutoToString.AutoToStringData(c, option, style);
        try {
            TemplateClass tc = this.classes().getByTemplate(key);
            if (null == tc) {
                tc = new TemplateClass((ITemplateResource)new ToStringTemplateResource(key), this, (IDialect)new AutoToString(c, key));
            }
            ITemplate t = tc.asTemplate(this);
            t.__setRenderArg(0, obj);
            String string = t.render();
            return string;
        }
        finally {
            RythmEngine.renderCleanUp();
        }
    }

    public String commonsToString(Object obj, ToStringOption option, org.apache.commons.lang3.builder.ToStringStyle style) {
        return this.toString(obj, option, ToStringStyle.fromApacheStyle(style));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderIfTemplateExists(String template, Object ... args) {
        boolean typeInferenceEnabled = this.conf().typeInferenceEnabled();
        if (typeInferenceEnabled) {
            ParamTypeInferencer.registerParams(this, args);
        }
        if (this.nonExistsTemplates.contains(template)) {
            return "";
        }
        String key = template;
        if (typeInferenceEnabled) {
            key = key + ParamTypeInferencer.uuid();
        }
        try {
            TemplateClass tc = this.classes().getByTemplate(template);
            if (null == tc) {
                ITemplateResource rsrc = this.resourceManager().getResource(template);
                if (rsrc.isValid()) {
                    tc = new TemplateClass(rsrc, this);
                } else {
                    this.nonExistsTemplates.add(template);
                    if (this.isDevMode() && this.nonExistsTemplatesChecker == null) {
                        this.nonExistsTemplatesChecker = new NonExistsTemplatesChecker();
                    }
                    String string = "";
                    return string;
                }
            }
            ITemplate t = tc.asTemplate(this);
            this.setRenderArgs(t, args);
            String string = t.render();
            return string;
        }
        finally {
            RythmEngine.renderCleanUp();
        }
    }

    public Object eval(String script) {
        return this.eval(script, Collections.emptyMap());
    }

    public Object eval(String script, Map<String, Object> params) {
        Serializable ce = this.mvels.get(script);
        if (null == ce) {
            ce = MVEL.compileExpression((String)script);
            this.mvels.put(script, ce);
        }
        return MVEL.executeExpression((Object)ce, params);
    }

    public Object eval(String script, Object context, Map<String, Object> params) {
        Serializable ce = this.mvels.get(script);
        if (null == ce) {
            ce = MVEL.compileExpression((String)script);
            this.mvels.put(script, ce);
        }
        return MVEL.executeExpression((Object)ce, (Object)context, params);
    }

    public boolean templateRegistered(String tmplName) {
        return this._templates.containsKey(tmplName) || this._tags.containsKey(tmplName);
    }

    public ITemplate getRegisteredTemplate(String tmplName) {
        return this._templates.get(tmplName);
    }

    public TemplateClass getRegisteredTemplateClass(String name) {
        TemplateBase tmpl = (TemplateBase)this._templates.get(name);
        if (null == tmpl) {
            return null;
        }
        return tmpl.__getTemplateClass(false);
    }

    public RythmEngine registerTemplateClass(TemplateClass tc) {
        this.classes().add(tc);
        return this;
    }

    public TemplateTestResult testTemplate(String name, TemplateClass callerClass, ICodeType codeType) {
        int pos;
        String callerName;
        TemplateTestResult result = new TemplateTestResult();
        if (Keyword.THIS.toString().equals(name)) {
            result.setFullName(callerClass.getTagName());
            return result;
        }
        if (this.mode().isProd() && this._nonTmpls.contains(name)) {
            return null;
        }
        if (this.templateRegistered(name)) {
            result.setFullName(name);
            return result;
        }
        if (null != callerClass.importPaths) {
            for (String s : callerClass.importPaths) {
                String name0;
                if (s.startsWith("java") || !this._templates.containsKey(name0 = s + "." + name)) continue;
                result.setFullName(name0);
                return result;
            }
        }
        if (null != (callerName = callerClass.getTagName()) && -1 != (pos = callerName.lastIndexOf("."))) {
            String s = callerName.substring(0, pos);
            String name0 = s + "." + name;
            if (this._templates.containsKey(name0)) {
                result.setFullName(name0);
                return result;
            }
            pos = s.lastIndexOf(".");
            if (-1 != pos && this._templates.containsKey(name0 = (s = callerName.substring(0, pos)) + "." + name)) {
                result.setFullName(name0);
                return result;
            }
        }
        try {
            TemplateClass tc = this.resourceManager().tryLoadTemplate(name, callerClass, codeType);
            if (null == tc) {
                if (this.mode().isProd()) {
                    this._nonTmpls.add(name);
                }
                return null;
            }
            result.setFullName(tc.getTagName());
            result.tc = tc;
            return result;
        }
        catch (TagLoadException e) {
            throw e;
        }
        catch (RythmException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e, "error trying load tag[%s]", name);
            return null;
        }
    }

    public void registerFastTag(JavaTagBase tag) {
        this._tags.put(tag.__getName(), tag);
    }

    public void registerTemplate(ITemplate template) {
        String name;
        if (template instanceof JavaTagBase) {
            name = template.__getName();
        } else {
            name = template.__getTemplateClass(false).getTagName();
            if (S.isEmpty(name)) {
                name = template.__getTemplateClass(false).getKey();
            }
        }
        this.registerTemplate(name, template);
    }

    public void registerTemplate(String name, ITemplate template) {
        if (null == template) {
            throw new NullPointerException();
        }
        this._templates.put(name, template);
    }

    public void invokeTemplate(int line, String name, ITemplate caller, ITag.__ParameterList params, ITag.__Body body, ITag.__Body context) {
        this.invokeTemplate(line, name, caller, params, body, context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeTemplate(int line, String name, ITemplate caller, ITag.__ParameterList params, ITag.__Body body, ITag.__Body context, boolean ignoreNonExistsTag) {
        if (this._nonExistsTags.contains(name)) {
            return;
        }
        Sandbox.enterSafeZone(this.secureCode);
        RythmEvents.ENTER_INVOKE_TEMPLATE.trigger(this, (TemplateBase)caller);
        try {
            ITemplate t = this._tags.get(name);
            if (null == t) {
                t = this._templates.get(name);
            }
            if (null == t && S.isEqual(name, caller.__getName())) {
                t = caller;
            }
            if (null == t) {
                String name0;
                TemplateClass tc = caller.__getTemplateClass(true);
                if (null != tc.importPaths) {
                    for (String s : tc.importPaths) {
                        if (s.startsWith("java")) continue;
                        name0 = s + "." + name;
                        t = this._tags.get(name0);
                        if (null == t) {
                            t = this._templates.get(name0);
                        }
                        if (null == t) continue;
                        break;
                    }
                }
                if (null == t) {
                    String callerName = tc.getTagName();
                    int pos = -1;
                    if (null != callerName) {
                        pos = callerName.lastIndexOf(".");
                    }
                    if (-1 != pos && null == (t = (ITemplate)this._tags.get(name0 = callerName.substring(0, pos) + "." + name))) {
                        t = this._templates.get(name0);
                    }
                }
                if (null == t) {
                    tc = this.resourceManager().tryLoadTemplate(name, tc, caller.__curCodeType());
                    if (null != tc) {
                        t = this._templates.get(tc.getTagName());
                    }
                    if (null == t) {
                        if (ignoreNonExistsTag) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("cannot find tag: " + name, new Object[0]);
                            }
                            this._nonExistsTags.add(name);
                            if (this.isDevMode() && this.nonExistsTemplatesChecker == null) {
                                this.nonExistsTemplatesChecker = new NonExistsTemplatesChecker();
                            }
                            return;
                        }
                        throw new NullPointerException("cannot find tag: " + name);
                    }
                    t = t.__cloneMe(this, caller);
                }
            }
            if (!(t instanceof JavaTagBase)) {
                String cn = t.getClass().getName();
                TemplateClass tc0 = this.classes().getByClassName(cn);
                if (null == tc0) {
                    throw new NullPointerException(String.format("null tc0 found. t.class: %s, name: %s, caller.class: %s", cn, name, caller.getClass()));
                }
                t = tc0.asTemplate(caller, this);
            } else {
                t = t.__cloneMe(this, caller);
            }
            if (null != params) {
                if (t instanceof JavaTagBase) {
                    ((JavaTagBase)t).__setRenderArgs0(params);
                } else {
                    for (int i = 0; i < params.size(); ++i) {
                        ITag.__Parameter param = params.get(i);
                        if (null != param.name && null != param.value) {
                            t.__setRenderArg(param.name, param.value);
                            continue;
                        }
                        if (null == param.value) continue;
                        t.__setRenderArg(i, param.value);
                    }
                }
            }
            if (null == body && null != params && null == (body = (ITag.__Body)params.getByName("__body"))) {
                body = (ITag.__Body)params.getByName("_body");
            }
            if (null != body) {
                t.__setRenderArg("__body", (Object)body);
                t.__setRenderArg("_body", (Object)body);
            }
            RythmEvents.ON_TAG_INVOCATION.trigger(this, F.T2((TemplateBase)caller, t));
            try {
                if (null != context) {
                    t.__setBodyContext(context);
                }
                t.__setSecureCode(this.secureCode).__call(line);
            }
            finally {
                RythmEvents.TAG_INVOKED.trigger(this, F.T2((TemplateBase)caller, t));
            }
        }
        finally {
            RythmEvents.EXIT_INVOKE_TEMPLATE.trigger(this, (TemplateBase)caller);
            Sandbox.leaveCurZone(this.secureCode);
        }
    }

    public void cache(String key, Object o, int ttl, Object ... args) {
        String value;
        if (this.conf().cacheDisabled()) {
            return;
        }
        ICacheService cacheService = this._cacheService;
        String string = null == o ? "" : (value = o instanceof Serializable ? (Serializable)o : o.toString());
        if (args.length > 0) {
            StringBuilder sb = new StringBuilder(key);
            for (Object arg : args) {
                sb.append("-").append(arg);
            }
            key = sb.toString();
        }
        cacheService.put(key, (Serializable)((Object)value), ttl);
    }

    public void cache(String key, Object o, String duration, Object ... args) {
        if (this.conf().cacheDisabled()) {
            return;
        }
        IDurationParser dp = this.conf().durationParser();
        int ttl = null == duration ? 0 : dp.parseDuration(duration);
        this.cache(key, o, ttl, args);
    }

    public void evict(String key) {
        if (this.conf().cacheDisabled()) {
            return;
        }
        this._cacheService.evict(key);
    }

    public Serializable cached(String key, Object ... args) {
        if (this.conf().cacheDisabled()) {
            return null;
        }
        ICacheService cacheService = this._cacheService;
        if (args.length > 0) {
            StringBuilder sb = new StringBuilder(key);
            for (Object arg : args) {
                sb.append("-").append(arg);
            }
            key = sb.toString();
        }
        return cacheService.get(key);
    }

    public void addExtendRelationship(TemplateClass parent, TemplateClass child) {
        if (this.mode().isProd()) {
            return;
        }
        Set<TemplateClass> children = this.extendMap.get(parent);
        if (null == children) {
            children = new CopyOnWriteArraySet<TemplateClass>();
            this.extendMap.put(parent, children);
        }
        children.add(child);
    }

    public void invalidate(TemplateClass parent) {
        if (this.mode().isProd()) {
            return;
        }
        Set<TemplateClass> children = this.extendMap.get(parent);
        if (null == children) {
            return;
        }
        for (TemplateClass child : children) {
            this.invalidate(child);
            child.reset();
        }
    }

    public synchronized Sandbox sandbox() {
        RythmSecurityManager rsm;
        String code;
        if (null != this._secureExecutor) {
            return new Sandbox(this, this._secureExecutor);
        }
        int poolSize = (Integer)this.conf().get(RythmConfigurationKey.SANDBOX_POOL_SIZE);
        SecurityManager csm = (SecurityManager)this.conf().get(RythmConfigurationKey.SANDBOX_SECURITY_MANAGER_IMPL);
        int timeout = (Integer)this.conf().get(RythmConfigurationKey.SANDBOX_TIMEOUT);
        SandboxThreadFactory fact = (SandboxThreadFactory)this.conf().get(RythmConfigurationKey.SANBOX_THREAD_FACTORY_IMPL);
        SecurityManager ssm = System.getSecurityManager();
        if (null == ssm || !(ssm instanceof RythmSecurityManager)) {
            code = (String)this.conf().get(RythmConfigurationKey.SANDBOX_SECURE_CODE);
            rsm = new RythmSecurityManager(csm, code, this);
        } else {
            rsm = (RythmSecurityManager)ssm;
            code = rsm.getCode();
        }
        this.secureCode = code;
        this._secureExecutor = new SandboxExecutingService(poolSize, fact, timeout, this, code);
        Sandbox sandbox = new Sandbox(this, this._secureExecutor);
        if (ssm != rsm) {
            System.setSecurityManager(rsm);
        }
        return sandbox;
    }

    public Sandbox sandbox(Map<String, Object> context) {
        return this.sandbox().setUserContext(context);
    }

    public IEventDispatcher eventDispatcher() {
        if (null == this.eventDispatcher) {
            this.eventDispatcher = new EventBus(this);
        }
        return this.eventDispatcher;
    }

    @Override
    public Object accept(IEvent event, Object param) {
        return this.eventDispatcher().accept(event, param);
    }

    public static OutputMode outputMode() {
        return (OutputMode)((Object)outputMode.get());
    }

    public static void renderCleanUp() {
        outputMode.remove();
        TemplateResourceManager.cleanUpTmplBlackList();
    }

    public void restart(RuntimeException cause) {
        if (this.isProdMode()) {
            throw cause;
        }
        if (!(cause instanceof ClassReloadException)) {
            String msg = cause.getMessage();
            if (cause instanceof RythmException) {
                RythmException re = (RythmException)cause;
                msg = re.getSimpleMessage();
            }
            logger.warn("restarting rythm engine due to %s", msg);
        }
        this.restart();
    }

    private void restart() {
        if (this.isProdMode()) {
            return;
        }
        this._classLoader = new TemplateClassLoader(this);
        ArrayList<String> templateTags = new ArrayList<String>();
        for (Map.Entry<String, ITemplate> entry : this._templates.entrySet()) {
            ITag tag = entry.getValue();
            if (tag instanceof JavaTagBase) continue;
            templateTags.add(entry.getKey());
        }
        for (String name : templateTags) {
            this._templates.remove(name);
        }
    }

    void setShutdownListener(IShutdownListener listener) {
        this.shutdownListener = listener;
    }

    public void shutdown() {
        if (this.zombie) {
            return;
        }
        logger.info("Shutting down Rythm Engine: [%s]", this.id());
        if (null != this._cacheService) {
            try {
                this._cacheService.shutdown();
            }
            catch (Exception e) {
                logger.error(e, "Error shutdown cache service", new Object[0]);
            }
        }
        if (null != this._secureExecutor) {
            try {
                this._secureExecutor.shutdown();
            }
            catch (Exception e) {
                logger.error(e, "Error shutdown secure executor", new Object[0]);
            }
        }
        if (null != this._resourceManager) {
            try {
                this._resourceManager.shutdown();
            }
            catch (Exception e) {
                logger.error(e, "Error shutdown resource manager", new Object[0]);
            }
        }
        if (null != this.shutdownListener) {
            try {
                this.shutdownListener.onShutdown();
            }
            catch (Exception e) {
                logger.error(e, "Error execute shutdown listener", new Object[0]);
            }
        }
        if (null != this.nonExistsTemplatesChecker) {
            this.nonExistsTemplatesChecker.onShutdown();
        }
        if (null != this._templates) {
            this._templates.clear();
        }
        if (null != this._classes) {
            this._classes.clear();
        }
        if (null != this._nonExistsTags) {
            this._nonExistsTags.clear();
        }
        if (null != this.nonExistsTemplates) {
            this.nonExistsTemplates.clear();
        }
        if (null != this._nonTmpls) {
            this._nonTmpls.clear();
        }
        this._classLoader = null;
        Rythm.RenderTime.clear();
        this.zombie = true;
    }

    static interface IShutdownListener {
        public void onShutdown();
    }

    public static enum OutputMode {
        os,
        writer,
        str{

            @Override
            public boolean writeOutput() {
                return false;
            }
        };


        public boolean writeOutput() {
            return true;
        }
    }

    public static class TemplateTestResult {
        private String fullName;
        TemplateClass tc;

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public Throwable getError() {
            if (this.tc == null) {
                return null;
            }
            if (this.tc.templateResource != null && this.tc.templateResource.getError() != null) {
                return this.tc.templateResource.getError();
            }
            return null;
        }
    }

    private class NonExistsTemplatesChecker
    implements IShutdownListener {
        boolean started = false;
        private ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(1);

        NonExistsTemplatesChecker() {
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ArrayList<String> toBeRemoved = new ArrayList<String>();
                    for (String template : RythmEngine.this.nonExistsTemplates) {
                        ITemplateResource rsrc = RythmEngine.this.resourceManager().getResource(template);
                        if (!rsrc.isValid()) continue;
                        toBeRemoved.add(template);
                    }
                    RythmEngine.this.nonExistsTemplates.removeAll(toBeRemoved);
                    toBeRemoved.clear();
                    TemplateClass tc = RythmEngine.this.classes().all().get(0);
                    for (String tag : RythmEngine.this._nonExistsTags) {
                        if (null == RythmEngine.this.resourceManager().tryLoadTemplate(tag, tc, null)) continue;
                        toBeRemoved.add(tag);
                    }
                    RythmEngine.this._nonExistsTags.removeAll(toBeRemoved);
                    toBeRemoved.clear();
                }
            }, 0L, 10000L, TimeUnit.MILLISECONDS);
        }

        @Override
        public void onShutdown() {
            this.scheduler.shutdown();
        }
    }

    public class RenderSettings {
        private final RythmConfiguration conf;
        private final ThreadLocal<Locale> _locale = new ThreadLocal<Locale>(){

            @Override
            protected Locale initialValue() {
                return RenderSettings.this.conf.locale();
            }
        };
        private final ThreadLocal<ICodeType> _codeType = new ThreadLocal();
        private final ThreadLocal<Map<String, Object>> _usrCtx = new ThreadLocal();

        private RenderSettings(RythmConfiguration conf) {
            this.conf = conf;
        }

        public final RenderSettings init(ICodeType codeType) {
            if (null != codeType) {
                this._codeType.set(codeType);
            } else {
                this._codeType.remove();
            }
            return this;
        }

        public final RenderSettings init(Locale locale) {
            if (null != locale) {
                this._locale.set(locale);
            } else {
                this._locale.remove();
            }
            return this;
        }

        public final RenderSettings init(Map<String, Object> usrCtx) {
            if (null != usrCtx) {
                this._usrCtx.set(usrCtx);
            } else {
                this._usrCtx.remove();
            }
            return this;
        }

        public final Locale locale() {
            return this._locale.get();
        }

        public final ICodeType codeType() {
            return this._codeType.get();
        }

        public final Map<String, Object> userContext() {
            return this._usrCtx.get();
        }

        public final RythmEngine clear() {
            this._locale.remove();
            this._codeType.remove();
            this._usrCtx.remove();
            return RythmEngine.this;
        }
    }
}

