/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser;

import com.stevesoft.pat.Regex;
import java.util.regex.Pattern;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.Sandbox;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.build_in.CaretParserFactoryBase;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.utils.S;

public abstract class ParserBase
implements IParser {
    public static final ParserBase NULL_INST = new ParserBase(){

        @Override
        public Token go() {
            return null;
        }
    };
    protected static final ILogger logger = Logger.get(IParser.class);
    private final IDialect d_;
    private final IContext c_;
    protected final RythmEngine engine_;

    public static Pattern pattern(String regex, Object ... args) {
        if (0 < args.length) {
            regex = String.format(regex, args);
        }
        return Pattern.compile(regex, 34);
    }

    private ParserBase() {
        this.d_ = null;
        this.c_ = null;
        this.engine_ = null;
    }

    protected ParserBase(IContext context) {
        if (null == context) {
            throw new NullPointerException();
        }
        this.d_ = context.getDialect();
        this.c_ = context;
        this.engine_ = context.getEngine();
    }

    protected final IDialect dialect() {
        return this.d_;
    }

    protected final String a() {
        return this.d_.a();
    }

    protected final String remain() {
        return this.c_.getRemain();
    }

    protected final int currentLine() {
        return this.c_.currentLine();
    }

    protected final char peek() {
        return this.c_.peek();
    }

    protected final char pop() {
        return this.c_.pop();
    }

    @Override
    public final IContext ctx() {
        return this.c_;
    }

    protected final CodeBuilder builder() {
        return this.c_.getCodeBuilder();
    }

    protected final void step(int i) {
        this.c_.step(i);
    }

    protected final void raiseParseException(String msg, Object ... args) {
        CaretParserFactoryBase.raiseParseException(this.ctx(), msg, args);
    }

    protected final void checkRestrictedClass(String code) {
        String s;
        if (Rythm.insideSandbox() && S.notEmpty(s = Sandbox.hasAccessToRestrictedClasses(this.ctx().getEngine(), code))) {
            this.raiseParseException("Access to restricted class [%s] is blocked in sandbox mode", s);
        }
    }

    protected boolean isLastBuilderLiteral() {
        IContext ctx = this.ctx();
        if (ctx.cursor() == 0) {
            return false;
        }
        CodeBuilder cb = ctx.getCodeBuilder();
        return cb.isLastBuilderLiteral();
    }

    protected void processFollowingOpenBraceAndLineBreak(boolean leadingLB) {
        IContext ctx = this.ctx();
        int cnt = 0;
        int lbCnt = 0;
        StringBuilder sb = new StringBuilder();
        boolean braceOpen = false;
        while (ctx.hasRemain()) {
            char c0 = ctx.pop();
            --cnt;
            if (c0 == ' ' || c0 == '\t') {
                if (!braceOpen) continue;
                sb.append(c0);
                continue;
            }
            if (c0 == '\n') {
                if (braceOpen) {
                    if (!leadingLB) {
                        sb.append("\n");
                    }
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken(sb.toString(), ctx));
                    break;
                }
                ++lbCnt;
                continue;
            }
            if (c0 == '{') {
                if (!braceOpen) {
                    braceOpen = true;
                    cnt = 0;
                    continue;
                }
                ctx.step(cnt);
                break;
            }
            ctx.step(cnt);
            break;
        }
    }

    public static void p(int i, Regex r) {
        if (0 == i) {
            System.out.println(i + ": " + r.stringMatched());
        } else {
            System.out.println(i + ": " + r.stringMatched(i));
        }
    }

    public static void p(String s, Regex r) {
        if (r.search(s)) {
            ParserBase.p(r);
        }
    }

    public static void p(String s, Regex r, int max) {
        if (r.search(s)) {
            ParserBase.p(r, max);
        }
    }

    public static void p(Regex r, int max) {
        for (int i = 0; i < max; ++i) {
            ParserBase.p(i, r);
        }
    }

    public static void p(Regex r) {
        ParserBase.p(r, 6);
    }
}

