/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.dialect.Rythm;
import org.rythmengine.internal.parser.RemoveLeadingLineBreakAndSpacesParser;
import org.rythmengine.internal.parser.build_in.ExecMacroToken;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;

public class ExpandParser
extends KeywordParserFactory {
    private static final String R = "(^%s(%s\\s*((?@()))\\s*))";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(IContext c) {
        return new RemoveLeadingLineBreakAndSpacesParser(c){

            @Override
            public Token go() {
                Regex r = ExpandParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("Error parsing @expand statement. Correct usage: @expand(\"my-macro\")", new Object[0]);
                }
                int curLine = this.ctx().currentLine();
                this.step(r.stringMatched().length());
                String s = r.stringMatched(3);
                if (S.isEmpty(s)) {
                    this.raiseParseException("Error parsing @expand statement. Correct usage: @expand(\"my-macro\")", new Object[0]);
                }
                String macro = S.stripBraceAndQuotation(s);
                return new ExecMacroToken(macro, this.ctx(), curLine);
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.EXPAND;
    }

    public static void main(String[] args) {
        String s;
        ExpandParser p = new ExpandParser();
        Regex r = p.reg(Rythm.INSTANCE);
        if (r.search(s = "@expand(\"x.y.z\") \n@sayHi(\"green\")")) {
            ExpandParser.p(r);
        }
    }
}

