/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classpath;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.Enumeration;
import sbt.io.IO$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001\u0002\b\u0010\u0005aA\u0001\"\t\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\tE\u0001\u0011\t\u0011)A\u00053!A\u0001\u0003\u0001B\u0001B\u0003%1\u0005C\u00037\u0001\u0011\u0005q\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003D\u0001\u0011\u0005C\t\u0003\u0004I\u0001\u0001\u0006I!\u0013\u0005\u0006%\u0002!\te\u0015\u0005\u0007U\u0002\u0001K\u0011B6\t\rM\u0004\u0001\u0015\"\u0003u\u0011\u0015i\b\u0001\"\u0011\u007f\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bA\u0001\"!\u0006\u0001A\u0013%\u0011q\u0003\u0002\u0010\u00072\f7o\u001d9bi\"4\u0015\u000e\u001c;fe*\u0011\u0001#E\u0001\nG2\f7o\u001d9bi\"T!AE\n\u0002\u0007%t7M\u0003\u0002\u0015+\u0005A\u0011N\u001c;fe:\fGNC\u0001\u0017\u0003\r\u0019(\r^\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b?5\t1D\u0003\u0002\u001d;\u0005!A.\u00198h\u0015\u0005q\u0012\u0001\u00026bm\u0006L!\u0001I\u000e\u0003\u0017\rc\u0017m]:M_\u0006$WM]\u0001\u0007a\u0006\u0014XM\u001c;\u0002\tI|w\u000e\u001e\t\u0004I5\u0002dBA\u0013,!\t1\u0013&D\u0001(\u0015\tAs#\u0001\u0004=e>|GO\u0010\u0006\u0002U\u0005)1oY1mC&\u0011A&K\u0001\u0007!J,G-\u001a4\n\u00059z#aA*fi*\u0011A&\u000b\t\u0003cQj\u0011A\r\u0006\u0003gu\t!![8\n\u0005U\u0012$\u0001\u0002$jY\u0016\fa\u0001P5oSRtD\u0003\u0002\u001d;wq\u0002\"!\u000f\u0001\u000e\u0003=AQ!\t\u0003A\u0002eAQA\t\u0003A\u0002eAQ\u0001\u0005\u0003A\u0002\r\nQa\u00197pg\u0016$\u0012a\u0010\t\u0003\u0001\u0006k\u0011!K\u0005\u0003\u0005&\u0012A!\u00168ji\u0006AAo\\*ue&tw\rF\u0001F!\t!c)\u0003\u0002H_\t11\u000b\u001e:j]\u001e\f1\u0002Z5sK\u000e$xN]5fgB\u0019!j\u0014\u0019\u000f\u0005-keB\u0001\u0014M\u0013\u0005Q\u0013B\u0001(*\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001U)\u0003\u0007M+\u0017O\u0003\u0002OS\u0005IAn\\1e\u00072\f7o\u001d\u000b\u0004)\u000e,\u0007GA+[!\r!c\u000bW\u0005\u0003/>\u0012Qa\u00117bgN\u0004\"!\u0017.\r\u0001\u0011I1\fCA\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0004?\u0012*\u0014CA/a!\t\u0001e,\u0003\u0002`S\t9aj\u001c;iS:<\u0007C\u0001!b\u0013\t\u0011\u0017FA\u0002B]fDQ\u0001\u001a\u0005A\u0002\u0015\u000b\u0011b\u00197bgNt\u0015-\\3\t\u000b\u0019D\u0001\u0019A4\u0002\u000fI,7o\u001c7wKB\u0011\u0001\t[\u0005\u0003S&\u0012qAQ8pY\u0016\fg.A\u0007ge>l7\t\\1tgB\fG\u000f\u001b\u000b\u0003O2DQ!\\\u0005A\u00029\f\u0011a\u0019\u0019\u0003_F\u00042\u0001\n,q!\tI\u0016\u000fB\u0005sY\u0006\u0005\t\u0011!B\u00019\n\u0019q\f\n\u001c\u0002\u0017=t7\t\\1tgB\fG\u000f\u001b\u000b\u0003OVDQA\u001e\u0006A\u0002]\f1a\u001d:d!\tA80D\u0001z\u0015\tQX$A\u0002oKRL!\u0001`=\u0003\u0007U\u0013F*A\u0006hKR\u0014Vm]8ve\u000e,GCA<\u0000\u0011\u0019\t\ta\u0003a\u0001\u000b\u0006!a.Y7f\u000319W\r\u001e*fg>,(oY3t)\u0011\t9!a\u0005\u0011\u000b\u0005%\u0011qB<\u000e\u0005\u0005-!bAA\u0007;\u0005!Q\u000f^5m\u0013\u0011\t\t\"a\u0003\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u0005\u0007\u0003\u0003a\u0001\u0019A#\u0002\u001b%t7\r\\;eK2{\u0017\rZ3s)\u00159\u0017\u0011DA\u000e\u0011\u0015iW\u00021\u0001\u001a\u0011\u0019\ti\"\u0004a\u00013\u0005!!-Y:fQ\ri\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002,\u0005\u0015\"a\u0002;bS2\u0014Xm\u0019")
public final class ClasspathFilter
extends ClassLoader {
    private final ClassLoader parent;
    private final ClassLoader root;
    private final Set<File> classpath;
    private final Seq<File> directories;

    public void close() {
        ClassLoader classLoader = this.parent;
        if (classLoader instanceof URLClassLoader) {
            ((URLClassLoader)classLoader).close();
            return;
        }
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(85).append("|ClasspathFilter(\n        |  parent = ").append(this.parent).append("\n        |  root = ").append(this.root).append("\n        |  cp = ").append(this.classpath).append("\n        |)").toString())).stripMargin();
    }

    @Override
    public Class<?> loadClass(String className, boolean resolve) {
        Class<?> c = super.loadClass(className, resolve);
        if (this.includeLoader(c.getClassLoader(), this.root) || this.fromClasspath(c)) {
            return c;
        }
        throw new ClassNotFoundException(className);
    }

    private boolean fromClasspath(Class<?> c) {
        CodeSource codeSource = c.getProtectionDomain().getCodeSource();
        return codeSource == null || this.onClasspath(codeSource.getLocation());
    }

    private boolean onClasspath(URL src) {
        block8: {
            block7: {
                boolean bl;
                if (src == null) break block7;
                Option option = IO$.MODULE$.urlAsFile(src);
                if (option instanceof Some) {
                    File f = (File)((Some)option).value();
                    bl = this.classpath.apply((Object)f) || this.directories.exists((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)ClasspathFilter.$anonfun$onClasspath$1(f, dir)));
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError((Object)option);
                }
                if (!bl) break block8;
            }
            return true;
        }
        return false;
    }

    @Override
    public URL getResource(String name) {
        URL u = super.getResource(name);
        if (this.onClasspath(u)) {
            return u;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        Enumeration<URL> us = super.getResources(name);
        if (us != null) {
            return JavaConverters$.MODULE$.asJavaEnumerationConverter(((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(us).asScala()).filter((Function1 & Serializable & scala.Serializable)src -> BoxesRunTime.boxToBoolean((boolean)this.onClasspath(src)))).asJavaEnumeration();
        }
        return null;
    }

    private boolean includeLoader(ClassLoader c, ClassLoader base) {
        while (base != null && c != null) {
            if (c != base) {
                c = c.getParent();
                continue;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$onClasspath$1(File f$1, File dir) {
        return IO$.MODULE$.relativize(dir, f$1).isDefined();
    }

    public ClasspathFilter(ClassLoader parent, ClassLoader root, Set<File> classpath) {
        this.parent = parent;
        this.root = root;
        this.classpath = classpath;
        super(parent);
        this.directories = (Seq)classpath.toSeq().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()));
    }
}

