/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector$;
import breeze.linalg.max$;
import breeze.linalg.min$;
import breeze.linalg.norm$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.support.CanTranspose;
import breeze.math.MutableInnerProductVectorSpace;
import breeze.numerics.package$abs$;
import breeze.numerics.package$abs$absDoubleImpl$;
import breeze.numerics.package$sqrt$;
import breeze.numerics.package$sqrt$sqrtDoubleImpl$;
import breeze.util.LazyLogger;
import breeze.util.SerializableLogging;
import breeze.util.SerializableLogging$class;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LSMR$
implements SerializableLogging {
    public static final LSMR$ MODULE$;
    private volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;

    static {
        new LSMR$();
    }

    @Override
    public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
        return this.breeze$util$SerializableLogging$$_the_logger;
    }

    @Override
    public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
        this.breeze$util$SerializableLogging$$_the_logger = x$1;
    }

    @Override
    public LazyLogger logger() {
        return SerializableLogging$class.logger(this);
    }

    public <M, MT, V> V solve(M A, V b, double regularization, double tolerance, int maxIter, boolean quiet, UFunc.UImpl2<OpMulMatrix$, M, V, V> multMV, CanTranspose<M, MT> transA, UFunc.UImpl2<OpMulMatrix$, MT, V, V> multMTV, MutableInnerProductVectorSpace<V, Object> ispace) {
        double lambda = package$.MODULE$.sqrt(regularization);
        MT At = transA.apply(A);
        double atol = tolerance;
        double btol = tolerance;
        Object u = ispace.copy().apply(b);
        double normb = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(u, ispace.normImpl()));
        double beta = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(u, ispace.normImpl()));
        Object object = beta > 0.0 ? ispace.hasOps(u).$div$eq(BoxesRunTime.boxToDouble((double)beta), ispace.divIntoVS()) : BoxedUnit.UNIT;
        V v = multMTV.apply(At, u);
        Object x = ispace.hasOps(v).$times(BoxesRunTime.boxToDouble((double)0.0), ispace.mulVS_M());
        double alpha = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(v, ispace.normImpl()));
        Object object2 = alpha > 0.0 ? ispace.hasOps(v).$div$eq(BoxesRunTime.boxToDouble((double)alpha), ispace.divIntoVS()) : BoxedUnit.UNIT;
        double alphabar = alpha;
        double zetabar = alpha * beta;
        double rho = 1.0;
        double rhobar = 1.0;
        double cbar = 1.0;
        double sbar = 0.0;
        double zeta = 0.0;
        V h = v;
        Object hbar = ispace.hasOps(h).$times(BoxesRunTime.boxToDouble((double)0.0), ispace.mulVS_M());
        double betadd = beta;
        double betad = 0.0;
        double rhodold = 1.0;
        double thetatilde = 0.0;
        double tautildeold = 0.0;
        double d = 0.0;
        double normA2 = this.sqr$1(alpha);
        double maxrbar = 0.0;
        double minrbar = 1.0E100;
        boolean converged = false;
        int iter = 0;
        while (!converged && iter < maxIter) {
            ++iter;
            u = ispace.hasOps(multMV.apply(A, v)).$minus(ispace.hasOps(u).$times(BoxesRunTime.boxToDouble((double)alpha), ispace.mulVS_M()), ispace.subVV());
            beta = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(u, ispace.normImpl()));
            if (beta > 0.0) {
                ispace.hasOps(u).$div$eq(BoxesRunTime.boxToDouble((double)beta), ispace.divIntoVS());
                v = ispace.hasOps(multMTV.apply(At, u)).$minus(ispace.hasOps(v).$times(BoxesRunTime.boxToDouble((double)beta), ispace.mulVS_M()), ispace.subVV());
            }
            Object object3 = (alpha = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(v, ispace.normImpl()))) > 0.0 ? ispace.hasOps(v).$div$eq(BoxesRunTime.boxToDouble((double)alpha), ispace.divIntoVS()) : BoxedUnit.UNIT;
            double alphahat = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(DenseVector$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{alphabar, lambda}), ClassTag$.MODULE$.Double()), DenseVector$.MODULE$.canNorm(ispace.scalars())));
            double chat = alphabar / alphahat;
            double shat = lambda / alphahat;
            double rhoold = rho;
            rho = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(DenseVector$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{alphahat, beta}), ClassTag$.MODULE$.Double()), DenseVector$.MODULE$.canNorm(ispace.scalars())));
            double c = alphahat / rho;
            double s = beta / rho;
            double thetanew = s * alpha;
            alphabar = c * alpha;
            double rhobarold = rhobar;
            double zetaold = zeta;
            double thetabar = sbar * rho;
            double rhotemp = cbar * rho;
            rhobar = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(DenseVector$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{cbar * rho, thetanew}), ClassTag$.MODULE$.Double()), DenseVector$.MODULE$.canNorm(ispace.scalars())));
            cbar = cbar * rho / rhobar;
            sbar = thetanew / rhobar;
            zeta = cbar * zetabar;
            zetabar = -sbar * zetabar;
            hbar = ispace.hasOps(h).$minus(ispace.hasOps(hbar).$times(BoxesRunTime.boxToDouble((double)(thetabar * rho / (rhoold * rhobarold))), ispace.mulVS_M()), ispace.subVV());
            x = ispace.hasOps(x).$plus(ispace.hasOps(hbar).$times(BoxesRunTime.boxToDouble((double)(zeta / (rho * rhobar))), ispace.mulVS_M()), ispace.addVV());
            h = ispace.hasOps(v).$minus(ispace.hasOps(h).$times(BoxesRunTime.boxToDouble((double)(thetanew / rho)), ispace.mulVS_M()), ispace.subVV());
            double betaacute = chat * betadd;
            double betacheck = -shat * betadd;
            double betahat = c * betaacute;
            betadd = -s * betaacute;
            double thetatildeold = thetatilde;
            double rhotildeold = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(DenseVector$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{rhodold, thetabar}), ClassTag$.MODULE$.Double()), DenseVector$.MODULE$.canNorm(ispace.scalars())));
            double ctildeold = rhodold / rhotildeold;
            double stildeold = thetabar / rhotildeold;
            thetatilde = stildeold * rhobar;
            rhodold = ctildeold * rhobar;
            betad = -stildeold * betad + ctildeold * betahat;
            tautildeold = (zetaold - thetatildeold * tautildeold) / rhotildeold;
            double taud = (zeta - thetatilde * tautildeold) / rhodold;
            double normr = package$sqrt$.MODULE$.apply$mDDc$sp((d += this.sqr$1(betacheck)) + this.sqr$1(betad - taud) + this.sqr$1(betadd), package$sqrt$sqrtDoubleImpl$.MODULE$);
            double normA = package$sqrt$.MODULE$.apply$mDDc$sp(normA2 += this.sqr$1(beta), package$sqrt$sqrtDoubleImpl$.MODULE$);
            normA2 += this.sqr$1(alpha);
            maxrbar = max$.MODULE$.apply$mDDDc$sp(maxrbar, rhobarold, max$.MODULE$.maxImpl2_Double());
            if (iter > 1) {
                minrbar = min$.MODULE$.apply$mDDDc$sp(minrbar, rhobarold, min$.MODULE$.minImpl2_Double());
            }
            double condA = max$.MODULE$.apply$mDDDc$sp(maxrbar, rhotemp, max$.MODULE$.maxImpl2_Double()) / min$.MODULE$.apply$mDDDc$sp(minrbar, rhotemp, min$.MODULE$.minImpl2_Double());
            maxrbar = max$.MODULE$.apply$mDDDc$sp(maxrbar, rhobarold, max$.MODULE$.maxImpl2_Double());
            if (iter > 1) {
                minrbar = min$.MODULE$.apply$mDDDc$sp(minrbar, rhobarold, min$.MODULE$.minImpl2_Double());
            }
            condA = max$.MODULE$.apply$mDDDc$sp(maxrbar, rhotemp, max$.MODULE$.maxImpl2_Double()) / min$.MODULE$.apply$mDDDc$sp(minrbar, rhotemp, min$.MODULE$.minImpl2_Double());
            double normAr = package$abs$.MODULE$.apply$mDDc$sp(zetabar, package$abs$absDoubleImpl$.MODULE$);
            double normx = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(x, ispace.normImpl()));
            double test1 = normr / normb;
            double test2 = normAr / (normA * normr);
            double rtol = btol + atol * normA * normx / normb;
            if (!quiet) {
                this.logger().info((Function0<String>)new Serializable(atol, normr, normAr, test1, test2, rtol){
                    public static final long serialVersionUID = 0L;
                    private final double atol$1;
                    private final double normr$1;
                    private final double normAr$1;
                    private final double test1$1;
                    private final double test2$1;
                    private final double rtol$1;

                    public final String apply() {
                        double arg$macro$56 = this.normr$1;
                        double arg$macro$57 = this.normAr$1;
                        double arg$macro$58 = this.test1$1;
                        double arg$macro$59 = this.rtol$1;
                        double arg$macro$60 = this.test2$1;
                        double arg$macro$61 = this.atol$1;
                        return new StringBuilder().append((Object)new StringOps("Residual: %.2g %.2g ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$56), BoxesRunTime.boxToDouble((double)arg$macro$57)}))).append((Object)new StringOps(":: convtest1: %.2g <? %.2g :: convtest2: %.2g <? %.2g").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$58), BoxesRunTime.boxToDouble((double)arg$macro$59), BoxesRunTime.boxToDouble((double)arg$macro$60), BoxesRunTime.boxToDouble((double)arg$macro$61)}))).toString();
                    }
                    {
                        this.atol$1 = atol$1;
                        this.normr$1 = normr$1;
                        this.normAr$1 = normAr$1;
                        this.test1$1 = test1$1;
                        this.test2$1 = test2$1;
                        this.rtol$1 = rtol$1;
                    }
                });
            }
            converged = normr == 0.0 || iter >= maxIter || test1 < rtol || test2 < atol;
        }
        return x;
    }

    public <M, MT, V> double solve$default$3() {
        return 0.0;
    }

    public <M, MT, V> double solve$default$4() {
        return 1.0E-9;
    }

    public <M, MT, V> int solve$default$5() {
        return 1000;
    }

    public <M, MT, V> boolean solve$default$6() {
        return false;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final double sqr$1(double x) {
        return x * x;
    }

    private LSMR$() {
        MODULE$ = this;
        SerializableLogging$class.$init$(this);
    }
}

