/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.media.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class PlayerMessage {
    private final Level level;
    private final String message;

    public PlayerMessage(Level level, String message) {
        this.level = Objects.requireNonNull(level, "level is required");
        this.message = Objects.requireNonNull(message, "message is required");
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    private static PlayerMessage fromJson(JsonInput input) {
        Level level = null;
        String message = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "level": {
                    level = Level.fromString(input.nextString());
                    continue block8;
                }
                case "message": {
                    message = input.nextString();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PlayerMessage(level, message);
    }

    public static enum Level {
        ERROR("error"),
        WARNING("warning"),
        INFO("info"),
        DEBUG("debug");

        private String value;

        private Level(String value) {
            this.value = value;
        }

        public static Level fromString(String s) {
            return Arrays.stream(Level.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Level "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Level fromJson(JsonInput input) {
            return Level.fromString(input.nextString());
        }
    }
}

