/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.http;

import java.net.URL;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class HttpException
extends RuntimeException {
    private final int code;

    public HttpException(URL requestUrl, int statusCode, String statusText, @Nullable String body) {
        super(HttpException.formatMessage(requestUrl, statusCode, statusText, body));
        this.code = statusCode;
    }

    private static String formatMessage(URL requestUrl, int code, String statusText, @Nullable String body) {
        String message = "GET " + String.valueOf(requestUrl) + " failed with HTTP " + code;
        if (StringUtils.isNotBlank((CharSequence)statusText)) {
            message = message + " " + statusText;
        }
        if (LoggerFactory.getLogger(HttpException.class).isDebugEnabled() && StringUtils.isNotBlank((CharSequence)body)) {
            message = message + "\n" + body;
        }
        return message;
    }

    public int getCode() {
        return this.code;
    }
}

