/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.logging.LogBase;
import com.persistit.logging.PersistitLogMessage;
import com.persistit.mxbeans.AlertMonitorMXBean;
import com.persistit.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public final class AlertMonitor
extends NotificationBroadcasterSupport
implements AlertMonitorMXBean {
    private static final int DEFAULT_HISTORY_LENGTH = 10;
    private static final int MINIMUM_HISTORY_LENGTH = 1;
    private static final int MAXIMUM_HISTORY_LENGTH = 1000;
    private static final long DEFAULT_WARN_INTERVAL = 600000L;
    private static final long MINIMUM_WARN_INTERVAL = 1000L;
    private static final long MAXIMUM_WARN_INTERVAL = 86400000L;
    private static final long DEFAULT_ERROR_INTERVAL = 15000L;
    private static final long MINIMUM_ERROR_INTERVAL = 1000L;
    private static final long MAXIMUM_ERROR_INTERVAL = 86400000L;
    protected static final String EVENT_FORMAT = "event %,5d: %s";
    protected static final String AGGREGATION_FORMAT = "Minimum=%,d Maximum=%,d Total=%,d";
    protected static final String EXTRA_FORMAT = "Extra=%s";
    static final String NOTIFICATION_TYPE = "com.persistit.AlertMonitor";
    private final Map<String, History> _historyMap = new TreeMap<String, History>();
    private volatile long _warnLogTimeInterval = 600000L;
    private volatile long _errorLogTimeInterval = 15000L;
    private volatile int _historyLength = 10;
    private final AtomicLong _notificationSequence = new AtomicLong();
    private volatile ObjectName _objectName;

    AlertMonitor() {
        super(Executors.newCachedThreadPool());
    }

    void setObjectName(ObjectName on) {
        this._objectName = on;
    }

    ObjectName getObjectName() {
        return this._objectName;
    }

    public final synchronized void post(Event event, String category) {
        History history = this._historyMap.get(category);
        if (history == null) {
            history = new History();
            this._historyMap.put(category, history);
        }
        history.addEvent(event);
        history.poll(event.getTime(), false);
    }

    @Override
    public synchronized void reset() {
        this._historyMap.clear();
    }

    @Override
    public long getWarnLogTimeInterval() {
        return this._warnLogTimeInterval;
    }

    @Override
    public void setWarnLogTimeInterval(long warnLogTimeInterval) {
        Util.rangeCheck(warnLogTimeInterval, 1000L, 86400000L);
        this._warnLogTimeInterval = warnLogTimeInterval;
    }

    @Override
    public long getErrorLogTimeInterval() {
        return this._errorLogTimeInterval;
    }

    @Override
    public void setErrorLogTimeInterval(long errorLogTimeInterval) {
        Util.rangeCheck(errorLogTimeInterval, 1000L, 86400000L);
        this._errorLogTimeInterval = errorLogTimeInterval;
    }

    @Override
    public int getHistoryLength() {
        return this._historyLength;
    }

    public synchronized History getHistory(String name) {
        return this._historyMap.get(name);
    }

    public synchronized SortedMap<String, History> getHistoryMap() {
        return new TreeMap<String, History>(this._historyMap);
    }

    @Override
    public synchronized void setHistoryLength(int historyLength) {
        Util.rangeCheck(historyLength, 1, 1000);
        this._historyLength = historyLength;
        for (History history : this._historyMap.values()) {
            history.trim(historyLength);
        }
    }

    public synchronized AlertRecord[] getAlertRecordArray() {
        ArrayList<AlertRecord> list = new ArrayList<AlertRecord>();
        for (Map.Entry<String, History> entry : this._historyMap.entrySet()) {
            for (Event event : entry.getValue().getEventList()) {
                list.add(new AlertRecord(entry.getKey(), event));
            }
        }
        return list.toArray(new AlertRecord[list.size()]);
    }

    @Override
    public synchronized void poll(boolean force) {
        for (History history : this._historyMap.values()) {
            history.poll(System.currentTimeMillis(), force);
        }
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, History> entry : this._historyMap.entrySet()) {
            sb.append(String.format("%12s: %s\n", entry.getKey(), entry.getValue()));
        }
        return sb.toString();
    }

    @Override
    public String getSummary() {
        return this.toString();
    }

    @Override
    public synchronized String getDetailedHistory(String select) {
        Pattern pattern = Util.pattern(select, true);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, History> entry : this._historyMap.entrySet()) {
            if (!pattern.matcher(entry.getKey()).matches()) continue;
            sb.append(String.format("%s:\n", entry.getKey()));
            sb.append(entry.getValue().getDetailedHistory());
        }
        return sb.toString();
    }

    @Override
    public synchronized String getAlertLevel() {
        AlertLevel level = AlertLevel.NORMAL;
        for (Map.Entry<String, History> entry : this._historyMap.entrySet()) {
            if (entry.getValue().getLevel().compareTo(level) <= 0) continue;
            level = entry.getValue().getLevel();
        }
        return level.toString();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{NOTIFICATION_TYPE};
        String name = Notification.class.getName();
        String description = "Alert raised by Akiban PersistIT";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, "Alert raised by Akiban PersistIT");
        return new MBeanNotificationInfo[]{info};
    }

    private void log(History history) {
        Event event = history.getLastEvent();
        if (event != null && event.getLogItem().isEnabled()) {
            if (history.getCount() == 1) {
                event.getLogItem().log(event.getArgs());
            } else {
                event.getLogItem().logRecurring(history.getCount(), history.getDuration(), event.getArgs());
            }
        }
    }

    private void sendNotification(History history) {
        Event event = history.getLastEvent();
        if (event != null && event.getLogItem().isEnabled()) {
            String description = LogBase.recurring(event.getLogItem().logMessage(event.getArgs()), history.getCount(), history.getDuration());
            Notification notification = new Notification(NOTIFICATION_TYPE, (Object)this.getClass().getName(), this._notificationSequence.incrementAndGet(), description);
            this.sendNotification(notification);
        }
    }

    private String format(Event event) {
        return event == null ? "null" : event.toString();
    }

    public static class AlertRecord {
        final String _category;
        final AlertLevel _level;
        final long _time;
        final String _message;

        private AlertRecord(String category, Event event) {
            this._category = category;
            this._level = event.getLevel();
            this._time = event.getTime();
            this._message = event.logMessage();
        }

        public String getCategory() {
            return this._category;
        }

        public AlertLevel getLevel() {
            return this._level;
        }

        public long getTime() {
            return this._time;
        }

        public String getMessage() {
            return this._message;
        }
    }

    public static class Event {
        private final AlertLevel _level;
        private final PersistitLogMessage.LogItem _logItem;
        private final Object[] _args;
        private final long _time;

        public Event(AlertLevel level, PersistitLogMessage.LogItem logItem, Object ... args) {
            this(level, System.currentTimeMillis(), logItem, args);
        }

        public Event(AlertLevel level, long time, PersistitLogMessage.LogItem logItem, Object ... args) {
            this._level = level;
            this._logItem = logItem;
            this._args = args;
            this._time = time;
        }

        public AlertLevel getLevel() {
            return this._level;
        }

        public PersistitLogMessage.LogItem getLogItem() {
            return this._logItem;
        }

        public long getTime() {
            return this._time;
        }

        public Object[] getArgs() {
            return this._args;
        }

        public Object getFirstArg() {
            return this._args.length > 0 ? this._args[0] : null;
        }

        protected void added(History history) {
        }

        protected void removed(History history) {
        }

        public String logMessage() {
            return this._logItem.logMessage(this._args);
        }

        public String toString() {
            return Util.date(this._time) + " " + this.logMessage();
        }
    }

    public class History {
        private AlertLevel _level = AlertLevel.NORMAL;
        private final List<Event> _eventList = new ArrayList<Event>();
        private volatile long _firstEventTime = Long.MAX_VALUE;
        private volatile long _lastWarnLogTime = Long.MIN_VALUE;
        private volatile long _lastErrorLogTime = Long.MIN_VALUE;
        private volatile int _reportedCount;
        private volatile Event _firstEvent;
        private volatile int _count;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder sb = new StringBuilder();
            AlertMonitor alertMonitor = AlertMonitor.this;
            synchronized (alertMonitor) {
                Event event = this.getLastEvent();
                if (this._count > 0) {
                    sb.append(String.format(AlertMonitor.EVENT_FORMAT, this._count, event == null ? "missing" : AlertMonitor.this.format(event)));
                }
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDetailedHistory() {
            StringBuilder sb = new StringBuilder();
            AlertMonitor alertMonitor = AlertMonitor.this;
            synchronized (alertMonitor) {
                int size = this._eventList.size();
                if (this._count > 0) {
                    int index;
                    sb.append(String.format(AlertMonitor.EVENT_FORMAT, 1, AlertMonitor.this.format(this._firstEvent)));
                    int n = index = this._count > size ? 0 : 1;
                    while (index < size) {
                        if (sb.length() > 0) {
                            sb.append(Util.NEW_LINE);
                        }
                        sb.append(String.format(AlertMonitor.EVENT_FORMAT, this._count - size + index + 1, AlertMonitor.this.format(this._eventList.get(index))));
                        ++index;
                    }
                }
            }
            return sb.toString();
        }

        public AlertLevel getLevel() {
            return this._level;
        }

        public long getFirstEventTime() {
            return this._firstEventTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLastEventTime() {
            AlertMonitor alertMonitor = AlertMonitor.this;
            synchronized (alertMonitor) {
                if (this._eventList.size() > 0) {
                    return this._eventList.get(this._eventList.size() - 1)._time;
                }
                return Long.MIN_VALUE;
            }
        }

        public long getDuration() {
            long latest = this.getLastEventTime();
            if (latest == Long.MIN_VALUE) {
                return 0L;
            }
            return (latest - this._firstEventTime) / 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Event> getEventList() {
            AlertMonitor alertMonitor = AlertMonitor.this;
            synchronized (alertMonitor) {
                return new ArrayList<Event>(this._eventList);
            }
        }

        public Event getFirstEvent() {
            return this._firstEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Event getLastEvent() {
            AlertMonitor alertMonitor = AlertMonitor.this;
            synchronized (alertMonitor) {
                if (this._eventList.isEmpty()) {
                    return null;
                }
                return this._eventList.get(this._eventList.size() - 1);
            }
        }

        public int getCount() {
            return this._count;
        }

        public void poll(long now, boolean force) {
            int count = this.getCount();
            if (count > this._reportedCount) {
                switch (this._level) {
                    case ERROR: {
                        if (!force && now <= this._lastErrorLogTime + AlertMonitor.this._errorLogTimeInterval) break;
                        this._lastErrorLogTime = now;
                        AlertMonitor.this.log(this);
                        AlertMonitor.this.sendNotification(this);
                        this._reportedCount = count;
                        break;
                    }
                    case WARN: {
                        if (!force && now <= this._lastWarnLogTime + AlertMonitor.this._warnLogTimeInterval) break;
                        this._lastWarnLogTime = now;
                        AlertMonitor.this.log(this);
                        AlertMonitor.this.sendNotification(this);
                        this._reportedCount = count;
                        break;
                    }
                }
            }
        }

        private void addEvent(Event event) {
            this.trim(AlertMonitor.this._historyLength - 1);
            this._eventList.add(event);
            ++this._count;
            if (event.getTime() < this._firstEventTime) {
                this._firstEventTime = event.getTime();
                this._firstEvent = event;
            }
            event.added(this);
            this._level = event.getLevel();
        }

        private void trim(int size) {
            while (this._eventList.size() > size) {
                this._eventList.get(0).removed(this);
                this._eventList.remove(0);
            }
        }
    }

    public static enum AlertLevel {
        NORMAL,
        WARN,
        ERROR;

    }
}

