/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.DefaultValueCoder;
import com.persistit.Persistit;
import com.persistit.encoding.CoderManager;
import com.persistit.encoding.CollectionValueCoder;
import com.persistit.encoding.EnumValueCoder;
import com.persistit.encoding.KeyCoder;
import com.persistit.encoding.SerialValueCoder;
import com.persistit.encoding.ValueCoder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public final class DefaultCoderManager
implements CoderManager {
    private static final Class<?>[] COLLECTION_CLASSES = new Class[]{ArrayList.class, LinkedList.class, Stack.class, Vector.class, Properties.class, HashMap.class, HashSet.class, Hashtable.class, TreeMap.class, TreeSet.class, LinkedHashMap.class, LinkedHashSet.class};
    private static Class<?> ENUM_CLASS = Enum.class;
    private static ValueCoder ENUM_VALUE_CODER = new EnumValueCoder();
    private final Persistit _persistit;
    private final Map<Class<?>, KeyCoder> _keyCodersByClass = new ConcurrentHashMap();
    private final Map<Class<?>, ValueCoder> _valueCodersByClass = new ConcurrentHashMap();
    private ClassSelector[] _serialOverrides = new ClassSelector[0];

    public DefaultCoderManager(Persistit persistit) {
        this(persistit, persistit.getConfiguration().getSerialOverride());
    }

    public DefaultCoderManager(Persistit persistit, String patterns) {
        this._persistit = persistit;
        if (patterns == null) {
            if (this._serialOverrides == null || this._serialOverrides.length != 0) {
                this._serialOverrides = new ClassSelector[0];
            }
        } else {
            int count = 0;
            if (patterns.length() > 0) {
                count = 1;
            }
            int p = -1;
            while ((p = patterns.indexOf(44, p + 1)) != -1) {
                ++count;
            }
            int q = 0;
            ClassSelector[] overrides = new ClassSelector[count];
            for (int index = 0; index < count; ++index) {
                int p2 = patterns.indexOf(44, q);
                if (p2 == -1) {
                    p2 = patterns.length();
                }
                overrides[index] = new ClassSelector(patterns.substring(q, p2));
                q = p2 + 1;
            }
            this._serialOverrides = overrides;
            Iterator<Class<?>> iter = this._valueCodersByClass.keySet().iterator();
            while (iter.hasNext()) {
                Class<?> clazz = iter.next();
                if (!this.isSerialOverride(clazz)) continue;
                iter.remove();
            }
        }
        this.registerDefaultCoveredClasses();
    }

    @Override
    public CoderManager getParent() {
        return null;
    }

    @Override
    public KeyCoder registerKeyCoder(Class<?> clazz, KeyCoder coder) {
        return this._keyCodersByClass.put(clazz, coder);
    }

    @Override
    public KeyCoder unregisterKeyCoder(Class<?> clazz) {
        return this._keyCodersByClass.remove(clazz);
    }

    @Override
    public int unregisterKeyCoder(KeyCoder coder) {
        int count = 0;
        Iterator<Class<?>> iter = this._keyCodersByClass.keySet().iterator();
        while (iter.hasNext()) {
            Class<?> clazz = iter.next();
            if (!coder.equals(this._keyCodersByClass.get(clazz))) continue;
            iter.remove();
            ++count;
        }
        return count;
    }

    public Map<Class<?>, ValueCoder> getRegisteredValueCoders() {
        TreeMap newMap = new TreeMap(new ClassComparator());
        newMap.putAll(this._valueCodersByClass);
        return Collections.unmodifiableMap(newMap);
    }

    public Map<Class<?>, KeyCoder> getRegisteredKeyCoders() {
        TreeMap newMap = new TreeMap(new ClassComparator());
        newMap.putAll(this._keyCodersByClass);
        return Collections.unmodifiableMap(newMap);
    }

    @Override
    public KeyCoder lookupKeyCoder(Class<?> clazz) {
        return this._keyCodersByClass.get(clazz);
    }

    @Override
    public ValueCoder registerValueCoder(Class<?> clazz, ValueCoder coder) {
        return this._valueCodersByClass.put(clazz, coder);
    }

    @Override
    public ValueCoder unregisterValueCoder(Class<?> clazz) {
        return this._valueCodersByClass.remove(clazz);
    }

    @Override
    public int unregisterValueCoder(ValueCoder coder) {
        int count = 0;
        Iterator<Class<?>> iter = this._valueCodersByClass.keySet().iterator();
        while (iter.hasNext()) {
            Class<?> clazz = iter.next();
            if (!coder.equals(this._valueCodersByClass.get(clazz))) continue;
            iter.remove();
            ++count;
        }
        return count;
    }

    @Override
    public ValueCoder lookupValueCoder(Class<?> clazz) {
        return this._valueCodersByClass.get(clazz);
    }

    @Override
    public ValueCoder getValueCoder(Class<?> clazz) {
        ValueCoder coder = this.lookupValueCoder(clazz);
        if (coder == null) {
            boolean serialOverride = this.isSerialOverride(clazz);
            coder = serialOverride ? new SerialValueCoder(clazz) : (ENUM_CLASS != null && ENUM_VALUE_CODER != null && ENUM_CLASS.isAssignableFrom(clazz) ? ENUM_VALUE_CODER : new DefaultValueCoder(this._persistit, clazz));
            this.registerValueCoder(clazz, coder);
        }
        return coder;
    }

    public String getSerialOverridePatterns() {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < this._serialOverrides.length; ++index) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(this._serialOverrides[index]);
        }
        return sb.toString();
    }

    public boolean isSerialOverride(Class<?> clazz) {
        while (Serializable.class.isAssignableFrom(clazz)) {
            String className = clazz.getName();
            for (int index = 0; index < this._serialOverrides.length; ++index) {
                if (!this._serialOverrides[index].isSelected(className)) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    private void registerDefaultCoveredClasses() {
        CollectionValueCoder coder = new CollectionValueCoder();
        for (int index = 0; index < COLLECTION_CLASSES.length; ++index) {
            Class<?> clazz = COLLECTION_CLASSES[index];
            if (this.isSerialOverride(clazz)) continue;
            this.registerValueCoder(COLLECTION_CLASSES[index], coder);
        }
    }

    private static class ClassSelector {
        private String _startsWith;
        private String _endsWith;
        private boolean _exact;
        private boolean _multiPath;

        private ClassSelector(String pattern) {
            int p = pattern.indexOf(42);
            int q = pattern.lastIndexOf(42);
            if (p == -1) {
                this._startsWith = pattern;
                this._endsWith = "";
                this._exact = true;
            } else if (q - p <= 1) {
                this._startsWith = pattern.substring(0, p);
                this._endsWith = pattern.substring(q + 1);
                this._exact = false;
                this._multiPath = q > p;
            } else {
                throw new IllegalArgumentException("Class selector pattern must be in the form  xxx, xxx*yyy or xxx**yyy");
            }
        }

        private boolean isSelected(String className) {
            int q;
            if (!className.startsWith(this._startsWith) || !className.endsWith(this._endsWith)) {
                return false;
            }
            int p = this._startsWith.length();
            if (p > (q = className.length() - this._endsWith.length()) || this._exact && p < q) {
                return false;
            }
            for (int index = p; index < q; ++index) {
                char c = className.charAt(index);
                if (!(c == '.' ? !this._multiPath : !Character.isJavaIdentifierPart(c))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this._startsWith);
            if (!this._exact) {
                sb.append('*');
                if (this._multiPath) {
                    sb.append('*');
                }
                sb.append(this._endsWith);
            }
            return sb.toString();
        }
    }

    private static final class ClassComparator<T>
    implements Comparator<T> {
        private ClassComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Class c1 = (Class)o1;
            Class c2 = (Class)o2;
            return c1.getName().compareTo(c2.getName());
        }
    }
}

