/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Buffer;
import com.persistit.util.Debug;

class FastIndex {
    static final int BYTES_PER_ENTRY = 2;
    private final short[] _findexElements;
    private boolean _isValid;
    private final Buffer _buffer;

    FastIndex(Buffer buffer, int elementSize) {
        this._buffer = buffer;
        this._findexElements = new short[elementSize];
        this._isValid = false;
    }

    int size() {
        return this._findexElements.length;
    }

    void putRunCount(int index, int runCount) {
        this._findexElements[index] = (short)runCount;
    }

    int getRunCount(int index) {
        return this._findexElements[index];
    }

    int getEbc(int index) {
        int kbData = this._buffer.getInt((index << 2) + 32);
        int ebc = Buffer.decodeKeyBlockEbc(kbData);
        return ebc;
    }

    boolean isValid() {
        return this._isValid;
    }

    void invalidate() {
        this._isValid = false;
    }

    void recompute() {
        if (this._buffer.isDataPage() || this._buffer.isIndexPage()) {
            int start = this._buffer.getKeyBlockStart();
            int end = this._buffer.getKeyBlockEnd();
            int ebc0 = 0;
            int runCountFixupIndex = 0;
            int crossCountFixupIndex = -1;
            int lastIndex = (end - start) / 4;
            int i = 0;
            int p = start;
            while (i <= lastIndex) {
                int ebc;
                if (i < lastIndex || i == 0) {
                    int kbData = this._buffer.getInt(p);
                    ebc = Buffer.decodeKeyBlockEbc(kbData);
                } else {
                    ebc = -1;
                }
                if (ebc != ebc0) {
                    int runCount = i - runCountFixupIndex - 1;
                    this.putRunCount(runCountFixupIndex, runCount);
                    runCountFixupIndex = i;
                    if (ebc > ebc0) {
                        this.putRunCount(i - 1, crossCountFixupIndex);
                        crossCountFixupIndex = i - 1;
                    } else {
                        int j = crossCountFixupIndex;
                        while (j != -1) {
                            int ccFixupEbc = this.getEbc(j);
                            if (ebc <= ccFixupEbc) {
                                int crossCount = -(i - j - 1);
                                crossCountFixupIndex = this.getRunCount(j);
                                this.putRunCount(j, crossCount);
                                j = crossCountFixupIndex;
                                continue;
                            }
                            crossCountFixupIndex = j;
                            break;
                        }
                    }
                    ebc0 = ebc;
                } else {
                    this.putRunCount(i, 0);
                }
                ++i;
                p += 4;
            }
            this._isValid = true;
        } else {
            this._isValid = false;
        }
    }

    boolean verify() {
        if (!this.isValid()) {
            return false;
        }
        int start = this._buffer.getKeyBlockStart();
        int end = this._buffer.getKeyBlockEnd();
        int ebc = -1;
        int ebc2 = Buffer.decodeKeyBlockEbc(this._buffer.getInt(start));
        int faultAt = -1;
        int i = 0;
        for (int p = start; p < end; p += 4) {
            int ebc0 = ebc;
            ebc = ebc2;
            int n = ebc2 = p + 4 < end ? Buffer.decodeKeyBlockEbc(this._buffer.getInt(p + 4)) : 0;
            if (ebc2 > ebc) {
                if (this.getRunCount(i) >= 0) {
                    if (faultAt < 0) {
                        faultAt = i;
                    }
                    return false;
                }
            } else if (ebc > ebc0 && this.getRunCount(i) < 0) {
                if (faultAt < 0) {
                    faultAt = i;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    synchronized void insertKeyBlock(int foundAt, int previousEbc, boolean fixupSuccessor) {
        int runCount;
        if (!this.isValid()) {
            return;
        }
        int start = 32;
        int end = this._buffer.getKeyBlockEnd();
        int runIndex = -1;
        int p = foundAt;
        if (p > end) {
            p = end;
        }
        int insertIndex = (foundAt - 32) / 4;
        int lastIndex = (end - 32) / 4;
        System.arraycopy(this._findexElements, insertIndex, this._findexElements, insertIndex + 1, lastIndex - insertIndex - 1);
        int insertedEbc = this.getEbc(insertIndex);
        int index = 0;
        while (index < insertIndex) {
            int runCount2 = this.getRunCount(index);
            int ebc = this.getEbc(index);
            runIndex = -1;
            if (runCount2 < 0) {
                int nextSibling = index - runCount2 + 1;
                if (insertIndex > nextSibling) {
                    index = nextSibling;
                    continue;
                }
                if (nextSibling == insertIndex && insertedEbc <= ebc) {
                    index = nextSibling;
                    continue;
                }
                if (insertedEbc > ebc) {
                    this.putRunCount(index, runCount2 - 1);
                }
                ++index;
                continue;
            }
            if (runCount2 == 0) {
                if (insertedEbc >= ebc) {
                    runIndex = index;
                }
                ++index;
                continue;
            }
            if (insertedEbc >= ebc) {
                runIndex = index;
            }
            if (this.getRunCount(index += runCount2) < 0) continue;
            ++index;
        }
        if (runIndex == -1) {
            runCount = this.getRunCount(insertIndex);
            if (insertedEbc > this.getEbc(insertIndex + 1)) {
                Debug.$assert0.t(!fixupSuccessor);
                this.putRunCount(insertIndex, 0);
            } else if (fixupSuccessor) {
                int successorEbc = Buffer.decodeKeyBlockEbc(this._buffer.getInt(p + 4));
                if (runCount < 0) {
                    runCount = 0;
                }
                this.fixupSuccessor(lastIndex, insertIndex, insertIndex, runCount, previousEbc, successorEbc);
            } else if (insertIndex + 1 >= lastIndex) {
                this.putRunCount(insertIndex, 0);
            } else if (runCount >= 0) {
                this.putRunCount(insertIndex, runCount + 1);
                this.putRunCount(insertIndex + 1, 0);
            } else {
                this.putRunCount(insertIndex, 1);
            }
        } else {
            runCount = this.getRunCount(runIndex);
            int ebc = this.getEbc(runIndex);
            Debug.$assert0.t(runCount + runIndex + 1 >= insertIndex);
            if (runCount + runIndex + 1 > insertIndex) {
                if (insertedEbc == ebc) {
                    if (fixupSuccessor) {
                        this.putRunCount(runIndex, insertIndex - runIndex);
                        int successorEbc = Buffer.decodeKeyBlockEbc(this._buffer.getInt(p + 4));
                        this.fixupSuccessor(lastIndex, insertIndex, runIndex, runCount, ebc, successorEbc);
                    } else {
                        this.putRunCount(runIndex, runCount + 1);
                        this.putRunCount(insertIndex, 0);
                    }
                } else {
                    Debug.$assert0.t(!fixupSuccessor);
                    if (insertIndex - 1 > runIndex) {
                        this.putRunCount(runIndex, insertIndex - runIndex - 1);
                    }
                    this.putRunCount(insertIndex - 1, -1);
                    this.putRunCount(insertIndex, 0);
                    if (runIndex + runCount > insertIndex) {
                        this.putRunCount(insertIndex + 1, runCount - (insertIndex - runIndex));
                    }
                }
            } else if (insertedEbc == ebc) {
                Debug.$assert0.t(!fixupSuccessor);
                this.putRunCount(runIndex, runCount + 1);
                this.putRunCount(insertIndex, 0);
            } else {
                Debug.$assert0.t(insertedEbc > ebc && !fixupSuccessor && this.getRunCount(insertIndex - 1) >= 0);
                this.putRunCount(insertIndex - 1, -1);
                this.putRunCount(insertIndex, 0);
            }
        }
    }

    private void fixupSuccessor(int lastIndex, int insertIndex, int runIndex, int runCount, int ebc, int successorEbc) {
        if (insertIndex > runIndex) {
            this.putRunCount(runIndex, insertIndex - runIndex);
        }
        if (runIndex + runCount > insertIndex) {
            this.putRunCount(insertIndex, -1);
            this.putRunCount(insertIndex + 1, 0);
            int remainingRunCount = runCount - (insertIndex - runIndex) - 1;
            if (insertIndex + 2 < lastIndex && remainingRunCount > 0) {
                this.putRunCount(insertIndex + 2, remainingRunCount);
            }
        } else {
            Debug.$assert0.t(runIndex + runCount == insertIndex);
            this.putRunCount(insertIndex, runCount - 1);
            int successorRunCount = insertIndex + 1 < lastIndex ? this.getRunCount(insertIndex + 1) : 0;
            Debug.$assert0.t(successorRunCount <= 0);
            this.putRunCount(insertIndex, successorRunCount - 1);
            if (insertIndex + 2 < lastIndex) {
                int secondSuccessorEbc = this.getEbc(insertIndex + 2);
                if (successorEbc == secondSuccessorEbc) {
                    int secondSuccessorRunCount = this.getRunCount(insertIndex + 2);
                    if (secondSuccessorRunCount >= 0) {
                        this.putRunCount(insertIndex + 1, secondSuccessorRunCount + 1);
                        this.putRunCount(insertIndex + 2, 0);
                    } else {
                        this.putRunCount(insertIndex + 1, 1);
                    }
                } else {
                    int newCrossCount = successorEbc < secondSuccessorEbc ? this.computeCrossCount(successorEbc, insertIndex + 1, lastIndex, insertIndex) : 0;
                    this.putRunCount(insertIndex + 1, newCrossCount);
                }
            } else {
                Debug.$assert0.t(insertIndex + 1 < lastIndex);
                this.putRunCount(insertIndex + 1, 0);
            }
        }
    }

    private int computeCrossCount(int ebc0, int start, int end, int insertIndex) {
        int index = start + 1;
        while (index < end) {
            int ebc = this.getEbc(index);
            if (ebc <= ebc0) {
                return start - index + 1;
            }
            int runCount = this.getRunCount(index);
            if (runCount < 0) {
                index = index + 1 - runCount;
                continue;
            }
            index = index + 1 + runCount;
        }
        return start - end + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Buffer buffer = this._buffer;
        if (buffer == null) {
            sb.append("buffer=null");
        } else {
            for (int index = 0; index < buffer.getKeyCount(); ++index) {
                int p = index * 4 + 32;
                int kbData = buffer.getInt(p);
                sb.append(String.format("%4d: runCount=%6d || Buffer p=%5d: ebc=%4d  db=%3d\n", index, this.getRunCount(index), p, Buffer.decodeKeyBlockEbc(kbData), Buffer.decodeKeyBlockDb(kbData)));
            }
        }
        return sb.toString();
    }
}

