/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Key;
import java.io.Serializable;

public class KeyState
implements Comparable,
Serializable {
    public static final long serialVersionUID = 107136093587833709L;
    public static final KeyState LEFT_GUARD_KEYSTATE = new KeyState(Key.LEFT_GUARD_KEY);
    public static final KeyState RIGHT_GUARD_KEYSTATE = new KeyState(Key.RIGHT_GUARD_KEY);
    private final byte[] _bytes;
    private int _hashCode = -1;

    public KeyState(Key key) {
        int length = key.getEncodedSize();
        this._bytes = new byte[length];
        System.arraycopy(key.getEncodedBytes(), 0, this._bytes, 0, length);
    }

    public KeyState(byte[] data) {
        this._bytes = data;
    }

    public void copyTo(Key key) {
        if (key.getMaximumSize() < this._bytes.length) {
            throw new IllegalArgumentException("Too small");
        }
        key.clear();
        System.arraycopy(this._bytes, 0, key.getEncodedBytes(), 0, this._bytes.length);
        key.setEncodedSize(this._bytes.length);
    }

    public int hashCode() {
        if (this._hashCode < 0) {
            int hashCode = 0;
            for (int index = 0; index < this._bytes.length; ++index) {
                hashCode = hashCode * 17 ^ this._bytes[index] & 0xFF;
            }
            this._hashCode = hashCode & Integer.MAX_VALUE;
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Key) {
            Key key = (Key)obj;
            if (key.getEncodedSize() != this._bytes.length) {
                return false;
            }
            byte[] valueBytes = key.getEncodedBytes();
            for (int i = 0; i < this._bytes.length; ++i) {
                if (valueBytes[i] == this._bytes[i]) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof KeyState) {
            KeyState keyState = (KeyState)obj;
            if (keyState._bytes.length != this._bytes.length) {
                return false;
            }
            for (int i = 0; i < this._bytes.length; ++i) {
                if (keyState._bytes[i] == this._bytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object obj) {
        int size;
        byte[] bytes;
        if (obj instanceof Key) {
            Key key = (Key)obj;
            bytes = key.getEncodedBytes();
            size = key.getEncodedSize();
        } else if (obj instanceof KeyState) {
            KeyState ks = (KeyState)obj;
            bytes = ks._bytes;
            size = bytes.length;
        } else {
            throw new ClassCastException();
        }
        int length = Math.min(size, this._bytes.length);
        for (int i = 0; i < length; ++i) {
            int a = this._bytes[i] & 0xFF;
            int b = bytes[i] & 0xFF;
            if (a == b) continue;
            return a < b ? -1 : 1;
        }
        if (size != this._bytes.length) {
            return this._bytes.length < size ? -1 : 1;
        }
        return 0;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public String toString() {
        return new Key(null, this).toString();
    }
}

