/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Management;
import com.persistit.Persistit;
import com.persistit.Tree;
import com.persistit.Volume;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.TaskEndedException;
import com.persistit.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Task
implements Runnable {
    public static final int STATE_NOT_STARTED = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_SUSPENDED = 2;
    public static final int STATE_DONE = 3;
    public static final int STATE_FAILED = 4;
    public static final int STATE_ENDED = 5;
    public static final int STATE_EXPIRED = 6;
    public static final String[] STATE_NAMES = new String[]{"notStarted", "running", "suspended", "done", "failed", "ended", "expired"};
    public static final int LOG_NORMAL = 0;
    public static final int LOG_VERBOSE = 1;
    public static final int DEFAULT_MAX_MESSAGE_LOG_SIZE = 500;
    protected Persistit _persistit;
    protected long _taskId;
    protected String _description;
    protected String _owner;
    protected long _startTime;
    protected long _finishTime;
    protected long _expirationTime;
    protected long _suspendedDuration;
    protected AtomicBoolean _stop = new AtomicBoolean();
    protected AtomicBoolean _suspend = new AtomicBoolean();
    protected Exception _lastException;
    protected int _state = 0;
    protected int _maxMessageLogSize = 500;
    protected int _culledMessageCount;
    protected int _messageLogVerbosity;
    protected final ArrayList<String> _messageLog = new ArrayList();
    protected PrintWriter _messageWriter;
    protected Thread _thread;

    static boolean isFinalStatus(int statusCode) {
        return statusCode == 3 || statusCode == 5 || statusCode == 6 || statusCode == 4;
    }

    protected Task() {
    }

    protected Task(Persistit persistit) {
        this.setPersistit(persistit);
    }

    public void setPersistit(Persistit persistit) {
        this._persistit = persistit;
    }

    protected abstract void runTask() throws Exception;

    protected void poll() {
        long now = System.currentTimeMillis();
        if (this._startTime == 0L) {
            this._startTime = now;
        }
        if (this._expirationTime == 0L) {
            this._expirationTime = Long.MAX_VALUE;
        }
        if (now - this._suspendedDuration > this._expirationTime) {
            this._state = 6;
            throw new TaskEndedException("Expired");
        }
        if (this._stop.get()) {
            this._state = 5;
            throw new TaskEndedException("Stopped");
        }
        if (this._suspend.get()) {
            while (this._suspend.get()) {
                if (this._stop.get()) {
                    this._state = 5;
                    throw new TaskEndedException("Stopped");
                }
                this._state = 2;
                try {
                    Util.sleep(500L);
                }
                catch (PersistitInterruptedException ie) {
                    throw new TaskEndedException("Interrupted");
                }
            }
            this._suspendedDuration += System.currentTimeMillis() - now;
            this._state = 1;
        }
    }

    protected Tree[] parseTreeList(String specification) throws PersistitException {
        ArrayList<Tree> list = new ArrayList<Tree>();
        StringBuilder sb = new StringBuilder();
        Volume volume = null;
        int end = specification.length();
        for (int index = 0; index <= end; ++index) {
            int c;
            int n = c = index < end ? (int)specification.charAt(index) : -1;
            if (c == 92) {
                if (index++ >= specification.length()) continue;
                sb.append(specification.charAt(index));
                continue;
            }
            if (c == 59 || c == 44 || c == -1) {
                String name = sb.toString();
                sb.setLength(0);
                if (volume == null) {
                    volume = this._persistit.getVolume(name);
                    list.add(volume.getDirectoryTree());
                } else {
                    Tree tree = volume.getTree(name, false);
                    if (tree != null) {
                        list.add(tree);
                    }
                }
                if (c == 44) continue;
                volume = null;
                continue;
            }
            sb.append((char)c);
        }
        Tree[] result = list.toArray(new Tree[list.size()]);
        return result;
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    public void setup(long taskId, String description, String owner, long maxTime, int verbosity) throws Exception {
        this._taskId = taskId;
        this._description = description;
        this._owner = owner;
        this._messageLogVerbosity = verbosity;
        this._expirationTime = maxTime > 0L ? this.now() + maxTime : Long.MAX_VALUE;
    }

    public void start() {
        if (this._thread != null) {
            throw new IllegalStateException("Already started");
        }
        this._thread = new Thread(this);
        this._thread.start();
    }

    public void stop() {
        this._stop.set(true);
    }

    public void suspend() {
        this._suspend.set(true);
    }

    public void resume() {
        this._suspend.set(false);
    }

    public void setMaximumTime(long maxTime) {
        long now = this.now();
        this._expirationTime = now + maxTime;
        if (this._expirationTime < now) {
            this._expirationTime = Long.MAX_VALUE;
        }
    }

    public void setMessageLogVerbosity(int verbosity) {
        this._messageLogVerbosity = verbosity;
    }

    public int getMessageLogVerbosity() {
        return this._messageLogVerbosity;
    }

    public void setMessageWriter(PrintWriter pw) {
        this._messageWriter = pw;
    }

    public PrintWriter getMessageWriter() {
        return this._messageWriter;
    }

    public abstract String getStatus();

    public String getStatusDetail() {
        return this.getStatus();
    }

    public long getRemainingTime() {
        if (this._expirationTime == 0L || this._expirationTime == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this._expirationTime - this.now() + this._suspendedDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postMessage(String message, int level) {
        if (level <= this._messageLogVerbosity) {
            ArrayList<String> arrayList = this._messageLog;
            synchronized (arrayList) {
                if (this._messageLog.size() >= this._maxMessageLogSize) {
                    this._messageLog.remove(0);
                }
                this._messageLog.add(message);
            }
            if (this._messageWriter != null) {
                this._messageWriter.println();
                this._messageWriter.print(message);
                this._messageWriter.flush();
            }
        }
    }

    protected void endMessage(int level) {
        if (level <= this._messageLogVerbosity && this._messageWriter != null) {
            this._messageWriter.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendMessage(String fragment, int level) {
        if (level <= this._messageLogVerbosity) {
            ArrayList<String> arrayList = this._messageLog;
            synchronized (arrayList) {
                int index = this._messageLog.size() - 1;
                if (index >= 0) {
                    String s = this._messageLog.get(index) + fragment;
                    this._messageLog.set(index, s);
                }
            }
            if (this._messageWriter != null) {
                this._messageWriter.print(fragment);
                this._messageWriter.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageLogSize() {
        ArrayList<String> arrayList = this._messageLog;
        synchronized (arrayList) {
            return this._messageLog.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMessages(int from) {
        ArrayList<String> arrayList = this._messageLog;
        synchronized (arrayList) {
            int size;
            if ((from -= this._culledMessageCount) < 0) {
                from = 0;
            }
            if ((size = this._messageLog.size() - from) < 0) {
                size = 0;
            }
            String[] results = new String[size];
            for (int index = 0; index < size; ++index) {
                results[index] = this._messageLog.get(index + from);
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cullMessages(int to) {
        ArrayList<String> arrayList = this._messageLog;
        synchronized (arrayList) {
            if ((to -= this._culledMessageCount) >= this._messageLog.size()) {
                this._messageLog.clear();
            } else {
                int index = to;
                while (--index >= 0) {
                    this._messageLog.remove(index);
                    ++this._culledMessageCount;
                }
            }
        }
    }

    @Override
    public void run() {
        this._startTime = this.now();
        try {
            this._state = 1;
            this.runTask();
            this._state = 3;
        }
        catch (Exception e) {
            this._lastException = e;
            this._state = e instanceof TaskEndedException ? 5 : 4;
        }
        this._finishTime = this.now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateTaskStatus(Management.TaskStatus ts, boolean details, boolean clearMessages) {
        ts.taskId = this._taskId;
        ts.state = this._state;
        ts.stateName = STATE_NAMES[this._state];
        ts.description = this._description;
        ts.owner = this._owner;
        ts.startTime = this._startTime;
        ts.finishTime = this._finishTime;
        ts.expirationTime = this._expirationTime;
        ts.lastException = this._lastException == null ? "none" : this._lastException.toString();
        ts.statusSummary = this.getStatus();
        if (details) {
            ArrayList<String> arrayList = this._messageLog;
            synchronized (arrayList) {
                ts.newMessages = this.getMessages(0);
                ts.statusDetail = this.getStatusDetail();
                if (clearMessages) {
                    this.cullMessages(Integer.MAX_VALUE);
                }
            }
        }
    }

    public boolean isImmediate() {
        return false;
    }
}

