/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Accumulator;
import com.persistit.IOTaskRunnable;
import com.persistit.Persistit;
import com.persistit.TimestampAllocator;
import com.persistit.TransactionIndexBucket;
import com.persistit.TransactionStatus;
import com.persistit.exception.RetryException;
import com.persistit.exception.TimeoutException;
import com.persistit.mxbeans.TransactionIndexMXBean;
import com.persistit.util.Debug;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

class TransactionIndex
implements TransactionIndexMXBean {
    static final String POLLING_TASK_NAME = "TXN_UPDATE";
    static final long POLLING_TASK_INTERVAL = 10L;
    static final int DEFAULT_LONG_RUNNING_THRESHOLD = 5;
    static final int DEFAULT_MAX_FREE_LIST_SIZE = 20;
    static final int DEFAULT_MAX_FREE_DELTA_LIST_SIZE = 50;
    static final long VERY_LONG_TIMEOUT = 60000L;
    static final long SHORT_TIMEOUT = 10L;
    static final int CYCLE_LIMIT = 10;
    private static final int INITIAL_ACTIVE_TRANSACTIONS_SIZE = 1000;
    static final int VERSION_HANDLE_MULTIPLIER = 100;
    private final TransactionIndexBucket[] _hashTable;
    volatile int _longRunningThreshold = 5;
    volatile int _maxFreeListSize = 20;
    volatile int _maxFreeDeltaListSize = 50;
    private final ActiveTransactionCache _atCache1;
    private final ActiveTransactionCache _atCache2;
    private final ReentrantLock _atCacheLock = new ReentrantLock();
    private volatile ActiveTransactionCache _atCache;
    private final AtomicLong _deadlockCounter = new AtomicLong();
    private final AtomicLong _accumulatorSnapshotRetryCounter = new AtomicLong();
    private final AtomicLong _accumulatorCheckpointRetryCounter = new AtomicLong();
    private final TimestampAllocator _timestampAllocator;
    private ActiveTransactionCachePollTask _activeTransactionCachePollTask;

    public static long vh2ts(long versionHandle) {
        return versionHandle / 100L;
    }

    public static long ts2vh(long ts) {
        return ts * 100L;
    }

    public static long tss2vh(long timestamp, int step) {
        return TransactionIndex.ts2vh(timestamp) + (long)step;
    }

    public static int vh2step(long versionHandle) {
        return (int)(versionHandle % 100L);
    }

    TransactionIndex(TimestampAllocator timestampAllocator, int hashTableSize) {
        this._timestampAllocator = timestampAllocator;
        this._hashTable = new TransactionIndexBucket[hashTableSize];
        for (int hashIndex = 0; hashIndex < hashTableSize; ++hashIndex) {
            this._hashTable[hashIndex] = new TransactionIndexBucket(this, hashIndex);
        }
        this._atCache1 = new ActiveTransactionCache();
        this._atCache2 = new ActiveTransactionCache();
        this._atCache = this._atCache1;
    }

    int getHashTableSize() {
        return this._hashTable.length;
    }

    int getMaxFreeListSize() {
        return this._maxFreeListSize;
    }

    int getMaxFreeDeltaListSize() {
        return this._maxFreeDeltaListSize;
    }

    int getLongRunningThreshold() {
        return this._longRunningThreshold;
    }

    TimestampAllocator getTimestampAllocator() {
        return this._timestampAllocator;
    }

    long commitStatus(long versionHandle, long ts, int step) throws InterruptedException, TimeoutException {
        long tsv = TransactionIndex.vh2ts(versionHandle);
        if (tsv == 0L) {
            return 0L;
        }
        if (tsv == ts) {
            int stepv = TransactionIndex.vh2step(versionHandle);
            if (stepv <= step) {
                return tsv;
            }
            return Long.MAX_VALUE;
        }
        if (tsv > ts) {
            return Long.MAX_VALUE;
        }
        int hashIndex = this.hashIndex(tsv);
        TransactionIndexBucket bucket = this._hashTable[hashIndex];
        if ((bucket.getCurrent() == null || tsv < bucket.getFloor()) && bucket.getLongRunning() == null && bucket.getAborted() == null) {
            return tsv;
        }
        long commitTimestamp = tsv;
        TransactionStatus status = this.getStatus(tsv);
        if (status != null) {
            long tc = status.getTc();
            while (status.getTs() == tsv) {
                if (tc >= ts) {
                    return Long.MAX_VALUE;
                }
                if (tc >= 0L) {
                    return tc;
                }
                if (tc == Long.MIN_VALUE) {
                    return tc;
                }
                if (!status.wwLock(10L)) continue;
                tc = status.getTc();
                status.wwUnlock();
            }
        }
        return commitTimestamp;
    }

    TransactionStatus registerTransaction() throws TimeoutException, InterruptedException {
        return this.registerTransaction(false);
    }

    TransactionStatus registerCheckpointTransaction() throws TimeoutException, InterruptedException {
        return this.registerTransaction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionStatus registerTransaction(boolean forCheckpoint) throws TimeoutException, InterruptedException {
        TransactionStatus status;
        block13: {
            TransactionIndexBucket bucket;
            Debug.suspend();
            TransactionIndex transactionIndex = this;
            synchronized (transactionIndex) {
                long ts = forCheckpoint ? this._timestampAllocator.allocateCheckpointTimestamp() : this._timestampAllocator.updateTimestamp();
                int index = this.hashIndex(ts);
                bucket = this._hashTable[index];
                bucket.lock();
                try {
                    status = bucket.allocateTransactionStatus();
                    status.initialize(ts);
                    bucket.addCurrent(status);
                }
                finally {
                    bucket.unlock();
                }
            }
            try {
                if (!status.wwLock(60000L)) {
                    throw new IllegalStateException("wwLock was unavailable on newly allocated TransactionStatus");
                }
                if (bucket.getCurrentCount() <= this._longRunningThreshold) break block13;
                bucket.lock();
                try {
                    bucket.reduce();
                }
                finally {
                    bucket.unlock();
                }
            }
            catch (InterruptedException ie) {
                status.abort();
                status.complete(0L);
                throw ie;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCompleted(TransactionStatus status, long timestamp) {
        int hashIndex = this.hashIndex(status.getTs());
        TransactionIndexBucket bucket = this._hashTable[hashIndex];
        bucket.lock();
        try {
            bucket.notifyCompleted(status, timestamp);
        }
        finally {
            bucket.unlock();
        }
    }

    public boolean hasConcurrentTransaction(long ts1, long ts2) {
        return this._atCache.hasConcurrentTransaction(ts1, ts2);
    }

    @Override
    public long getActiveTransactionFloor() {
        return this._atCache._floor;
    }

    @Override
    public long getActiveTransactionCeiling() {
        return this._atCache._ceiling;
    }

    @Override
    public long getActiveTransactionCount() {
        return this._atCache._count;
    }

    ActiveTransactionCache getActiveTransactionCache() {
        return this._atCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionStatus getStatus(long tsv) {
        if (tsv == 0L) {
            return null;
        }
        int hashIndex = this.hashIndex(tsv);
        TransactionIndexBucket bucket = this._hashTable[hashIndex];
        long floor = bucket.getFloor();
        if ((tsv >= floor && bucket.getCurrent() == null || tsv < floor) && bucket.getLongRunning() == null && bucket.getAborted() == null && floor == bucket.getFloor()) {
            return null;
        }
        bucket.lock();
        try {
            TransactionStatus s;
            if (tsv >= bucket.getFloor()) {
                for (s = bucket.getCurrent(); s != null; s = s.getNext()) {
                    if (s.getTs() != tsv) continue;
                    TransactionStatus transactionStatus = s;
                    return transactionStatus;
                }
            }
            for (s = bucket.getAborted(); s != null; s = s.getNext()) {
                if (s.getTs() != tsv) continue;
                TransactionStatus transactionStatus = s;
                return transactionStatus;
            }
            for (s = bucket.getLongRunning(); s != null; s = s.getNext()) {
                if (s.getTs() != tsv) continue;
                TransactionStatus transactionStatus = s;
                return transactionStatus;
            }
        }
        finally {
            bucket.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long wwDependency(long versionHandle, TransactionStatus source, long timeout) throws InterruptedException, IllegalArgumentException {
        long tsv = TransactionIndex.vh2ts(versionHandle);
        if (tsv == source.getTs()) {
            return 0L;
        }
        TransactionStatus target = this.getStatus(tsv);
        if (target == null) {
            return 0L;
        }
        long tcommit = target.getTc();
        if (target.getTs() != tsv) {
            return 0L;
        }
        if (tcommit > 0L && tcommit < source.getTs() || tcommit == Long.MIN_VALUE) {
            return 0L;
        }
        long start = System.currentTimeMillis();
        do {
            source.setDepends(target);
            if (this.isDeadlocked(source)) {
                this._deadlockCounter.incrementAndGet();
                long l = Long.MAX_VALUE;
                return l;
            }
            if (target.wwLock(Math.min(timeout, 10L))) {
                try {
                    if (target.getTs() != tsv) {
                        long l = 0L;
                        return l;
                    }
                    long tc = target.getTc();
                    if (tc == Long.MIN_VALUE) {
                        long l = 0L;
                        return l;
                    }
                    if (tc < 0L || tc == Long.MAX_VALUE) {
                        throw new IllegalStateException("Commit incomplete");
                    }
                    if (tc > source.getTs()) {
                        long l = tc;
                        return l;
                    }
                    long l = 0L;
                    return l;
                }
                finally {
                    target.wwUnlock();
                }
            }
            if (timeout == 0L) {
                long l = -9223372036854775807L;
                return l;
            }
            if (!this.isDeadlocked(source)) continue;
            this._deadlockCounter.incrementAndGet();
            long l = Long.MAX_VALUE;
            return l;
            finally {
                source.setDepends(null);
            }
        } while (timeout > 0L && System.currentTimeMillis() - start < timeout);
        return -9223372036854775807L;
    }

    boolean isDeadlocked(TransactionStatus source) {
        TransactionStatus s = source;
        for (int count = 0; count < 10; ++count) {
            if ((s = s.getDepends()) == null || s.getTc() == Long.MIN_VALUE) {
                return false;
            }
            if (s != source) continue;
            return true;
        }
        return true;
    }

    long decrementMvvCount(long versionHandle) {
        long tsv = TransactionIndex.vh2ts(versionHandle);
        TransactionStatus status = this.getStatus(tsv);
        if (status == null || status.getTs() != tsv || status.getTc() != Long.MIN_VALUE) {
            throw new IllegalArgumentException("No such aborted transaction " + versionHandle);
        }
        return status.decrementMvvCount();
    }

    private int hashIndex(long ts) {
        return (((int)ts ^ (int)(ts >>> 32)) & Integer.MAX_VALUE) % this._hashTable.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void injectAbortedTransaction(long ts) throws InterruptedException {
        TransactionIndex transactionIndex = this;
        synchronized (transactionIndex) {
            int index = this.hashIndex(ts);
            TransactionIndexBucket bucket = this._hashTable[index];
            bucket.lock();
            try {
                TransactionStatus status = bucket.allocateTransactionStatus();
                status.initializeAsAborted(ts);
                bucket.addAborted(status);
            }
            finally {
                bucket.unlock();
            }
        }
    }

    public void updateActiveTransactionCache(long ts) {
        if (this._atCache._floor < ts) {
            this.updateActiveTransactionCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateActiveTransactionCache() {
        Debug.suspend();
        this._atCacheLock.lock();
        try {
            ActiveTransactionCache alternate = this._atCache == this._atCache1 ? this._atCache2 : this._atCache1;
            alternate.recompute();
            this._atCache = alternate;
        }
        finally {
            this._atCacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        this.updateActiveTransactionCache();
        for (TransactionIndexBucket bucket : this._hashTable) {
            bucket.lock();
            try {
                bucket.reduce();
            }
            finally {
                bucket.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int resetMVVCounts(long timestamp) {
        int count = 0;
        for (TransactionIndexBucket bucket : this._hashTable) {
            bucket.lock();
            try {
                count += bucket.resetMVVCounts(timestamp);
            }
            finally {
                bucket.unlock();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getAccumulatorSnapshot(Accumulator accumulator, long timestamp, int step, long initialValue) throws InterruptedException {
        long result = initialValue;
        for (TransactionIndexBucket bucket : this._hashTable) {
            boolean again = true;
            while (again) {
                again = false;
                bucket.lock();
                try {
                    result = accumulator.applyValue(result, bucket.getAccumulatorSnapshot(accumulator, timestamp, step));
                }
                catch (RetryException e) {
                    again = true;
                }
                finally {
                    bucket.unlock();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkpointAccumulatorSnapshots(long timestamp, List<Accumulator> accumulators) throws InterruptedException {
        HashMap<Accumulator, Accumulator> lookupMap = new HashMap<Accumulator, Accumulator>();
        for (Accumulator accumulator : accumulators) {
            lookupMap.put(accumulator, accumulator);
            accumulator.setCheckpointValueAndTimestamp(accumulator.getBaseValue(), Long.MIN_VALUE);
        }
        for (TransactionIndexBucket bucket : this._hashTable) {
            boolean again = true;
            while (again) {
                again = false;
                bucket.lock();
                try {
                    for (Accumulator accumulator : accumulators) {
                        accumulator.setCheckpointTemp(accumulator.getBucketValue(bucket.getIndex()));
                    }
                    bucket.checkpointAccumulatorSnapshots(timestamp);
                    for (Accumulator accumulator : accumulators) {
                        accumulator.setCheckpointValueAndTimestamp(accumulator.applyValue(accumulator.getCheckpointValue(), accumulator.getCheckpointTemp()), timestamp);
                    }
                }
                catch (RetryException e) {
                    again = true;
                }
                finally {
                    bucket.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accumulator.Delta addDelta(TransactionStatus status) {
        int hashIndex = this.hashIndex(status.getTs());
        TransactionIndexBucket bucket = this._hashTable[hashIndex];
        bucket.lock();
        try {
            Accumulator.Delta delta = bucket.allocateDelta();
            status.addDelta(delta);
            Accumulator.Delta delta2 = delta;
            return delta2;
        }
        finally {
            bucket.unlock();
        }
    }

    void addOrCombineDelta(TransactionStatus status, Accumulator accumulator, int step, long value) {
        Accumulator.Delta delta;
        for (delta = status.getDelta(); delta != null; delta = delta.getNext()) {
            if (!delta.canMerge(accumulator, step)) continue;
            delta.merge(value);
            return;
        }
        delta = this.addDelta(status);
        delta.setAccumulator(accumulator);
        delta.setStep(step);
        delta.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentCount() {
        int currentCount = 0;
        for (TransactionIndexBucket bucket : this._hashTable) {
            bucket.lock();
            try {
                currentCount += bucket.getCurrentCount();
            }
            finally {
                bucket.unlock();
            }
        }
        return currentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLongRunningCount() {
        int longRunningCount = 0;
        for (TransactionIndexBucket bucket : this._hashTable) {
            bucket.lock();
            try {
                longRunningCount += bucket.getLongRunningCount();
            }
            finally {
                bucket.unlock();
            }
        }
        return longRunningCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAbortedCount() {
        int abortedCount = 0;
        for (TransactionIndexBucket bucket : this._hashTable) {
            bucket.lock();
            try {
                abortedCount += bucket.getAbortedCount();
            }
            finally {
                bucket.unlock();
            }
        }
        return abortedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFreeCount() {
        int freeCount = 0;
        for (TransactionIndexBucket bucket : this._hashTable) {
            bucket.lock();
            try {
                freeCount += bucket.getFreeCount();
            }
            finally {
                bucket.unlock();
            }
        }
        return freeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDroppedCount() {
        int droppedCount = 0;
        for (TransactionIndexBucket bucket : this._hashTable) {
            bucket.lock();
            try {
                droppedCount += bucket.getDroppedCount();
            }
            finally {
                bucket.unlock();
            }
        }
        return droppedCount;
    }

    long[] oldestTransactions(int max) {
        long[] array = new long[Math.max(max, 1000)];
        int count = 0;
        for (int retry = 0; retry < 10; ++retry) {
            ActiveTransactionCache atCache = this.getActiveTransactionCache();
            count = Math.min(max, atCache._count);
            System.arraycopy(atCache._tsArray, 0, array, 0, count);
            if (this.getActiveTransactionCache() == atCache) break;
            count = -1;
        }
        if (count == -1) {
            return null;
        }
        long[] result = new long[count];
        System.arraycopy(array, 0, result, 0, count);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < this._hashTable.length; ++index) {
            TransactionIndexBucket bucket = this._hashTable[index];
            if (bucket.isEmpty()) continue;
            sb.append(String.format("%5d: %s\n", index, bucket));
        }
        return sb.toString();
    }

    static String minMaxString(long floor) {
        return floor == Long.MAX_VALUE ? "MAX" : (floor == Long.MIN_VALUE ? "MIN" : String.format("%,d", floor));
    }

    void start(Persistit persistit) {
        this._activeTransactionCachePollTask = new ActiveTransactionCachePollTask(persistit);
        this._activeTransactionCachePollTask.start(POLLING_TASK_NAME, 10L);
    }

    ActiveTransactionCachePollTask close() {
        ActiveTransactionCachePollTask task = this._activeTransactionCachePollTask;
        if (task != null) {
            task.close();
            this._activeTransactionCachePollTask = null;
        }
        return task;
    }

    void crash() {
        ActiveTransactionCachePollTask task = this._activeTransactionCachePollTask;
        if (task != null) {
            task.crash();
            this._activeTransactionCachePollTask = null;
        }
    }

    long incrementAccumulatorSnapshotRetryCounter() {
        return this._accumulatorSnapshotRetryCounter.incrementAndGet();
    }

    long incrementAccumulatorCheckpointRetryCounter() {
        return this._accumulatorCheckpointRetryCounter.incrementAndGet();
    }

    class ActiveTransactionCache {
        private volatile long _ceiling;
        private volatile long _floor;
        private volatile long[] _tsArray = new long[1000];
        private volatile int _count;

        ActiveTransactionCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recompute() {
            long timestampAtStart;
            this._count = 0;
            long floor = timestampAtStart = TransactionIndex.this._timestampAllocator.updateTimestamp();
            for (TransactionIndexBucket bucket : TransactionIndex.this._hashTable) {
                if (bucket.getCurrent() == null && bucket.getLongRunning() == null) continue;
                bucket.lock();
                try {
                    TransactionStatus status;
                    if (bucket.hasFloorMoved()) {
                        bucket.reduce();
                    }
                    for (status = bucket.getCurrent(); status != null; status = status.getNext()) {
                        if (status.getTs() > timestampAtStart || status.isNotified()) continue;
                        this.add(status.getTs());
                        if (status.getTs() >= floor) continue;
                        floor = status.getTs();
                    }
                    for (status = bucket.getLongRunning(); status != null; status = status.getNext()) {
                        if (status.getTs() > timestampAtStart || status.isNotified()) continue;
                        this.add(status.getTs());
                        if (status.getTs() >= floor) continue;
                        floor = status.getTs();
                    }
                }
                finally {
                    bucket.unlock();
                }
            }
            Arrays.sort(this._tsArray, 0, this._count);
            this._ceiling = timestampAtStart;
            this._floor = floor;
        }

        private void add(long ts) {
            int index = this._count++;
            if (this._count >= this._tsArray.length) {
                long[] temp = new long[this._count + 1000];
                System.arraycopy(this._tsArray, 0, temp, 0, this._tsArray.length);
                this._tsArray = temp;
            }
            this._tsArray[index] = ts;
        }

        boolean hasConcurrentTransaction(long ts1, long ts2) {
            if (ts2 > this._ceiling) {
                return true;
            }
            if (ts1 > ts2 || ts2 < this._floor) {
                return false;
            }
            for (int index = 0; index < this._count; ++index) {
                long ts = this._tsArray[index];
                if (ts > ts2) {
                    return false;
                }
                if (ts <= ts1) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            long low = Long.MAX_VALUE;
            long high = Long.MIN_VALUE;
            for (int index = 0; index < this._count; ++index) {
                low = Math.min(low, this._tsArray[index]);
                high = Math.max(high, this._tsArray[index]);
            }
            return String.format("Floor=%,d Ceiling=%,d Low=%s High=%s Count=%,d", this._floor, this._ceiling, TransactionIndex.minMaxString(low), TransactionIndex.minMaxString(high), this._count);
        }
    }

    class ActiveTransactionCachePollTask
    extends IOTaskRunnable {
        AtomicBoolean _closed;

        ActiveTransactionCachePollTask(Persistit persistit) {
            super(persistit);
            this._closed = new AtomicBoolean();
        }

        void close() {
            this._closed.set(true);
        }

        @Override
        protected boolean shouldStop() {
            return this._closed.get();
        }

        @Override
        protected void runTask() throws Exception {
            TransactionIndex.this.updateActiveTransactionCache();
        }
    }
}

