/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.util.Util;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class TreeStatistics {
    static final int MAX_SERIALIZED_SIZE = 54;
    private final AtomicLong _fetchCounter = new AtomicLong();
    private final AtomicLong _traverseCounter = new AtomicLong();
    private final AtomicLong _storeCounter = new AtomicLong();
    private final AtomicLong _removeCounter = new AtomicLong();
    private final AtomicBoolean _dirty = new AtomicBoolean();
    private final AtomicLong[] _statsArray = new AtomicLong[]{this._fetchCounter, this._traverseCounter, this._storeCounter, this._removeCounter};
    private static final String[] _statsArrayNames = new String[]{"fetchCounter", "traverseCounter", "storeCounter", "removeCounter"};

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < _statsArrayNames.length; ++index) {
            String name = _statsArrayNames[index];
            AtomicLong value = this._statsArray[index];
            if (name == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name);
            sb.append("=");
            sb.append(value == null ? "" : String.format("%,d", value.get()));
        }
        return sb.toString();
    }

    public long getFetchCounter() {
        return this._fetchCounter.get();
    }

    public long getTraverseCounter() {
        return this._traverseCounter.get();
    }

    public long getStoreCounter() {
        return this._storeCounter.get();
    }

    public long getRemoveCounter() {
        return this._removeCounter.get();
    }

    boolean isDirty() {
        return this._dirty.get();
    }

    void setDirty(boolean dirty) {
        this._dirty.set(dirty);
    }

    void reset() {
        this._fetchCounter.set(0L);
        this._traverseCounter.set(0L);
        this._storeCounter.set(0L);
        this._removeCounter.set(0L);
        this.setDirty(true);
    }

    void bumpFetchCounter() {
        this._fetchCounter.incrementAndGet();
        this.setDirty(true);
    }

    void bumpTraverseCounter() {
        this._traverseCounter.incrementAndGet();
        this.setDirty(true);
    }

    void bumpStoreCounter() {
        this._storeCounter.incrementAndGet();
        this.setDirty(true);
    }

    void bumpRemoveCounter() {
        this._removeCounter.incrementAndGet();
        this.setDirty(true);
    }

    int store(byte[] bytes, int index) {
        long bits = 0L;
        int offset = index + 8;
        int field = 0;
        for (AtomicLong a : this._statsArray) {
            if (a != null) {
                long v = a.get();
                bits |= (long)(1 << field);
                Util.putLong(bytes, offset, v);
                offset += 8;
            }
            ++field;
        }
        Util.putLong(bytes, index, bits);
        return offset - index;
    }

    int load(byte[] bytes, int index, int length) {
        int offset = index + 8;
        int end = index + length;
        long bits = Util.getLong(bytes, index);
        for (int field = 0; field < 64; ++field) {
            AtomicLong a;
            AtomicLong atomicLong = a = field < this._statsArray.length ? this._statsArray[field] : null;
            if ((bits & (long)(1 << field)) == 0L) continue;
            if (a != null) {
                this.checkEnd(offset + 8, end);
                a.set(Util.getLong(bytes, offset));
            }
            offset += 8;
        }
        return length;
    }

    private void checkEnd(int index, int end) {
        if (index > end) {
            throw new IllegalStateException("TreeStatistics record is too short at offset " + index);
        }
    }
}

