/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import java.util.concurrent.atomic.AtomicLong;

class VolumeStatistics {
    private volatile long _openTime;
    private volatile long _lastReadTime;
    private volatile long _lastWriteTime;
    private volatile long _lastExtensionTime;
    private volatile long _nextAvailablePage;
    private volatile long _createTime;
    private volatile long _lastGlobalTimestamp;
    private final AtomicLong _readCounter = new AtomicLong();
    private final AtomicLong _writeCounter = new AtomicLong();
    private final AtomicLong _getCounter = new AtomicLong();
    private final AtomicLong _fetchCounter = new AtomicLong();
    private final AtomicLong _traverseCounter = new AtomicLong();
    private final AtomicLong _storeCounter = new AtomicLong();
    private final AtomicLong _removeCounter = new AtomicLong();

    VolumeStatistics() {
    }

    public long getReadCounter() {
        return this._readCounter.get();
    }

    public long getWriteCounter() {
        return this._writeCounter.get();
    }

    public long getGetCounter() {
        return this._getCounter.get();
    }

    public long getFetchCounter() {
        return this._fetchCounter.get();
    }

    public long getTraverseCounter() {
        return this._traverseCounter.get();
    }

    public long getStoreCounter() {
        return this._storeCounter.get();
    }

    public long getRemoveCounter() {
        return this._removeCounter.get();
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public long getOpenTime() {
        return this._openTime;
    }

    public long getLastReadTime() {
        return this._lastReadTime;
    }

    public long getLastWriteTime() {
        return this._lastWriteTime;
    }

    public long getLastExtensionTime() {
        return this._lastExtensionTime;
    }

    public long getLastGlobalTimestamp() {
        return this._lastGlobalTimestamp;
    }

    void reset() {
        this._openTime = 0L;
        this._lastReadTime = 0L;
        this._lastWriteTime = 0L;
        this._lastExtensionTime = 0L;
        this._nextAvailablePage = 0L;
        this._createTime = 0L;
        this._readCounter.set(0L);
        this._writeCounter.set(0L);
        this._getCounter.set(0L);
        this._fetchCounter.set(0L);
        this._traverseCounter.set(0L);
        this._storeCounter.set(0L);
        this._readCounter.set(0L);
    }

    void bumpReadCounter() {
        this._readCounter.incrementAndGet();
        this._lastReadTime = System.currentTimeMillis();
    }

    void bumpWriteCounter() {
        this._writeCounter.incrementAndGet();
        this._lastWriteTime = System.currentTimeMillis();
    }

    void bumpGetCounter() {
        this._getCounter.incrementAndGet();
    }

    void bumpFetchCounter() {
        this._fetchCounter.incrementAndGet();
    }

    void bumpTraverseCounter() {
        this._traverseCounter.incrementAndGet();
    }

    void bumpStoreCounter() {
        this._storeCounter.incrementAndGet();
    }

    void bumpRemoveCounter() {
        this._removeCounter.incrementAndGet();
    }

    long getNextAvailablePage() {
        return this._nextAvailablePage;
    }

    void setOpenTime(long openTime) {
        this._openTime = openTime;
    }

    void setLastReadTime(long lastReadTime) {
        this._lastReadTime = lastReadTime;
    }

    void setLastWriteTime(long lastWriteTime) {
        this._lastWriteTime = lastWriteTime;
    }

    void setLastExtensionTime(long lastExtensionTime) {
        this._lastExtensionTime = lastExtensionTime;
    }

    void setNextAvailablePage(long nextAvailablePage) {
        this._nextAvailablePage = nextAvailablePage;
    }

    void setCreateTime(long createTime) {
        this._createTime = createTime;
    }

    void setLastGlobalTimestamp(long lastGlobalTimestamp) {
        this._lastGlobalTimestamp = lastGlobalTimestamp;
    }
}

