/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.encoding;

import com.persistit.Value;
import com.persistit.encoding.CoderContext;
import com.persistit.encoding.ValueDisplayer;
import com.persistit.encoding.ValueRenderer;
import com.persistit.exception.ConversionException;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CollectionValueCoder
implements ValueRenderer,
ValueDisplayer {
    @Override
    public void put(Value value, Object object, CoderContext context) throws ConversionException {
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                value.put(entry.getKey(), context);
                value.put(entry.getValue(), context);
            }
        } else if (object instanceof List && !(object instanceof AbstractSequentialList)) {
            List list = (List)object;
            int size = list.size();
            for (int index = 0; index < size; ++index) {
                value.put(list.get(index), context);
            }
        } else if (object instanceof Collection) {
            Iterator iter = ((Collection)object).iterator();
            while (iter.hasNext()) {
                value.put(iter.next(), context);
            }
        } else {
            throw new ConversionException("CollectionValueCoder cannot encode an object of type " + object.getClass().getName());
        }
    }

    @Override
    public Object get(Value value, Class<?> clazz, CoderContext context) throws ConversionException {
        try {
            Object target = clazz.newInstance();
            value.registerEncodedObject(target);
            this.render(value, target, (Class)clazz, context);
            return target;
        }
        catch (InstantiationException ce) {
            throw new ConversionException(ce + " while decoding a Collection value");
        }
        catch (IllegalAccessException iae) {
            throw new ConversionException(iae + " while decoding a Collection value");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void render(Value value, Object target, Class clazz, CoderContext context) throws ConversionException {
        if (target instanceof Map) {
            if (!Map.class.isAssignableFrom(clazz)) throw new ConversionException("Cannot convert a " + clazz.getName() + " to a Map");
            Map map = (Map)target;
            while (value.hasMoreItems()) {
                Object itemKey = value.get(null, context);
                if (!value.hasMoreItems()) {
                    throw new ConversionException("Encoded Map entry has missing value");
                }
                Object itemValue = value.get(null, context);
                map.put(itemKey, itemValue);
            }
            return;
        } else {
            if (!(target instanceof Collection)) throw new ConversionException("CollectionValueCoder cannot render to an object of class " + target.getClass().getName());
            if (!Collection.class.isAssignableFrom(clazz)) throw new ConversionException("Cannot convert " + clazz.getName() + " to a Collection");
            Collection collection = (Collection)target;
            while (value.hasMoreItems()) {
                Object itemValue = value.get(null, context);
                collection.add(itemValue);
            }
        }
    }

    @Override
    public void display(Value value, StringBuilder target, Class<?> clazz, CoderContext context) throws ConversionException {
        if (Map.class.isAssignableFrom(clazz)) {
            target.append('[');
            boolean first = true;
            while (value.hasMoreItems()) {
                if (first) {
                    first = false;
                } else {
                    target.append(',');
                }
                value.decodeDisplayable(true, target);
                target.append("->");
                if (!value.hasMoreItems()) {
                    throw new ConversionException("Encoded Map entry has missing value");
                }
                value.decodeDisplayable(true, target);
            }
            target.append(']');
        } else if (Collection.class.isAssignableFrom(clazz)) {
            target.append('[');
            boolean first = true;
            while (value.hasMoreItems()) {
                if (first) {
                    first = false;
                } else {
                    target.append(',');
                }
                value.decodeDisplayable(true, target);
            }
            target.append(']');
        } else {
            throw new ConversionException("Cannot display value that is neither a Map nor a Collection");
        }
    }
}

