/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.encoding;

import com.persistit.Value;
import com.persistit.encoding.CoderContext;
import com.persistit.encoding.ValueCoder;
import com.persistit.exception.ConversionException;
import java.io.ObjectStreamClass;

public final class SerialValueCoder
implements ValueCoder {
    private final ObjectStreamClass _classDescriptor;

    public SerialValueCoder(Class<?> clazz) {
        this._classDescriptor = ObjectStreamClass.lookup(clazz);
        if (this._classDescriptor == null) {
            throw new ConversionException("Not Serializable: " + clazz.getName());
        }
    }

    @Override
    public Object get(Value value, Class<?> clazz, CoderContext context) {
        try {
            Value.OldValueInputStream stream = value.oldValueInputStream(this._classDescriptor);
            Object object = stream.readObject();
            stream.close();
            return object;
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public void put(Value value, Object object, CoderContext context) {
        try {
            Value.OldValueOutputStream stream = value.oldValueOutputStream(this._classDescriptor);
            stream.writeObject(object);
            stream.close();
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }
}

