/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.logging;

import com.persistit.logging.PersistitLevel;
import com.persistit.logging.PersistitLogger;
import java.util.EnumMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDK14LoggingAdapter
implements PersistitLogger {
    private static final EnumMap<PersistitLevel, Level> LEVEL_MAP = new EnumMap(PersistitLevel.class);
    private final Logger _logger;

    public JDK14LoggingAdapter(Logger logger) {
        this._logger = logger;
    }

    @Override
    public boolean isLoggable(PersistitLevel level) {
        return this._logger.isLoggable(LEVEL_MAP.get((Object)level));
    }

    @Override
    public void log(PersistitLevel level, String message) {
        this._logger.log(LEVEL_MAP.get((Object)level), message);
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    static {
        LEVEL_MAP.put(PersistitLevel.NONE, Level.OFF);
        LEVEL_MAP.put(PersistitLevel.TRACE, Level.FINER);
        LEVEL_MAP.put(PersistitLevel.DEBUG, Level.FINE);
        LEVEL_MAP.put(PersistitLevel.INFO, Level.INFO);
        LEVEL_MAP.put(PersistitLevel.WARNING, Level.WARNING);
        LEVEL_MAP.put(PersistitLevel.ERROR, Level.SEVERE);
    }
}

