/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Management;
import com.persistit.ui.AdminCommand;
import com.persistit.ui.AdminPanel;
import com.persistit.ui.AdminUI;
import com.persistit.ui.ManagementTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AdminUIBufferPanel
extends AdminPanel
implements AdminCommand {
    AdminUI _adminUI;
    private ManagementTableModel _bufferPoolInfoArrayModel;
    private ManagementTableModel _bufferInfoArrayModel;
    private final Map _menuMap = new HashMap();
    private int _bufferPoolIndex = -1;
    private int _selectedTraversalType = 0;
    private String _selectedIncludeMask = null;
    private String _selectedExcludeMask = null;
    private final String _detailMask = "";
    private List _toggleList;
    private boolean _refreshing;
    private TitledBorder _poolDetailBorder;
    private String _poolDetailBorderPattern;
    private JPanel _poolInfoPanel;
    private JPanel _poolDetailPanel;

    @Override
    protected void setup(AdminUI ui) throws NoSuchMethodException, RemoteException {
        this._adminUI = ui;
        this._poolInfoPanel = new JPanel(new BorderLayout());
        this._poolDetailPanel = new JPanel(new BorderLayout());
        this._bufferPoolInfoArrayModel = new ManagementTableModel(Management.BufferPoolInfo.class, "BufferPoolInfo", ui);
        this._bufferInfoArrayModel = new ManagementTableModel(Management.BufferInfo.class, "BufferInfo", ui);
        final JTable table1 = new JTable(this._bufferPoolInfoArrayModel);
        table1.setAutoCreateRowSorter(true);
        table1.setPreferredScrollableViewportSize(new Dimension(800, 80));
        table1.setAutoCreateColumnsFromModel(false);
        table1.setSelectionMode(0);
        this._bufferPoolInfoArrayModel.formatColumns(table1, "");
        JTable table2 = new JTable(this._bufferInfoArrayModel);
        table2.setAutoCreateRowSorter(true);
        table2.setPreferredScrollableViewportSize(new Dimension(800, 400));
        table2.setAutoCreateColumnsFromModel(false);
        table2.setSelectionMode(0);
        this._bufferInfoArrayModel.formatColumns(table2, "");
        this._poolInfoPanel.setBorder(this._adminUI.createTitledBorder("BufferPanel.summaryCaption"));
        this._poolInfoPanel.add((Component)new JScrollPane(table1), "Center");
        this._poolDetailBorderPattern = this._adminUI.getProperty("BufferPanel.detailCaption");
        this._poolDetailBorder = this._adminUI.createTitledBorder("BufferPanel.detailCaptionEmpty");
        this._poolDetailPanel.setBorder(this._poolDetailBorder);
        this._poolDetailPanel.add((Component)new JScrollPane(table2), "Center");
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.add(this._poolInfoPanel);
        splitPane.add(this._poolDetailPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        this.add((Component)this.createBufferSelectorPanel(), "South");
        table1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                int index = table1.getSelectedRow();
                if (!AdminUIBufferPanel.this._refreshing && !lse.getValueIsAdjusting() && index >= 0) {
                    AdminUIBufferPanel.this._bufferPoolIndex = index;
                    AdminUIBufferPanel.this._adminUI.scheduleRefresh(-1);
                }
            }
        });
        this._adminUI.scheduleRefresh(-1);
    }

    private JPanel createBufferSelectorPanel() {
        String s;
        JPanel panel = new JPanel(new FlowLayout(1));
        this._toggleList = new ArrayList();
        int index = 0;
        while ((s = this._adminUI.getProperty("BufferPanel.toggle." + index)) != null) {
            AdminUI.AdminAction action = this._adminUI.createAction(this, s);
            JToggleButton toggle = new JToggleButton(action);
            action.addButton(toggle);
            panel.add(toggle);
            this._toggleList.add(toggle);
            ++index;
        }
        return panel;
    }

    @Override
    public void actionPerformed(AdminUI.AdminAction action, ActionEvent ae) {
        String name = action.getName();
        Object source = ae.getSource();
        if ("VALID".equals(name) || "DIRTY".equals(name) || "READER".equals(name) || "WRITER".equals(name)) {
            int p;
            boolean selected = ((JToggleButton)source).isSelected();
            char selectionChar = name.toLowerCase().charAt(0);
            int n = p = this._selectedIncludeMask == null ? -1 : this._selectedIncludeMask.indexOf(selectionChar);
            if (selected && p < 0) {
                if (this._selectedIncludeMask == null) {
                    this._selectedIncludeMask = "";
                }
                this._selectedIncludeMask = this._selectedIncludeMask + selectionChar;
            }
            if (!selected && p >= 0) {
                this._selectedIncludeMask = new StringBuilder(this._selectedIncludeMask).deleteCharAt(p).toString();
                if (this._selectedIncludeMask.length() == 0) {
                    this._selectedIncludeMask = null;
                }
            }
            this._adminUI.scheduleRefresh(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refresh(boolean reset) {
        AdminUIBufferPanel adminUIBufferPanel = this;
        synchronized (adminUIBufferPanel) {
            if (this._refreshing) {
                return;
            }
            this._refreshing = true;
        }
        try {
            Management management = this._adminUI.getManagement();
            if (reset) {
                this._bufferPoolIndex = -1;
                this._selectedExcludeMask = null;
                this._selectedIncludeMask = null;
                this._selectedTraversalType = 0;
                if (this._toggleList != null) {
                    for (int index = 0; index < this._toggleList.size(); ++index) {
                        JToggleButton toggle = (JToggleButton)this._toggleList.get(index);
                        toggle.setSelected(false);
                    }
                }
            }
            Object[] bufferPoolInfoArray = management == null ? null : management.getBufferPoolInfoArray();
            this._bufferPoolInfoArrayModel.setInfoArray(bufferPoolInfoArray);
            if (this._bufferPoolIndex < 0) {
                this._bufferPoolIndex = 0;
            }
            if (this._bufferPoolIndex >= 0 && bufferPoolInfoArray != null && this._bufferPoolIndex < bufferPoolInfoArray.length) {
                int bufferSize = ((Management.BufferPoolInfo)bufferPoolInfoArray[this._bufferPoolIndex]).getBufferSize();
                this._bufferInfoArrayModel.setInfoArray(management.getBufferInfoArray(bufferSize, this._selectedTraversalType, this._selectedIncludeMask, this._selectedExcludeMask));
                this._poolDetailBorder.setTitle(MessageFormat.format(this._poolDetailBorderPattern, this._adminUI.formatInteger(bufferSize)));
                this._poolDetailPanel.repaint(0, 0, 1000, 30);
            } else {
                this._bufferInfoArrayModel.setInfoArray(null);
                this._poolDetailBorder.setTitle(this._adminUI.getProperty("BufferPanel.detailCaptionEmpty"));
            }
        }
        catch (RemoteException re) {
            this._adminUI.postException(re);
        }
        finally {
            AdminUIBufferPanel adminUIBufferPanel2 = this;
            synchronized (adminUIBufferPanel2) {
                this._refreshing = false;
            }
        }
    }

    @Override
    protected Map getMenuMap() {
        return this._menuMap;
    }

    @Override
    protected void setDefaultButton() {
        this.getRootPane().setDefaultButton(null);
    }
}

