/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Management;
import com.persistit.ui.AbstractInspector;
import com.persistit.ui.AdminUI;
import com.persistit.ui.InspectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class InspectorDisplayablePanel
extends AbstractInspector {
    private JTextArea _textArea;

    InspectorDisplayablePanel() {
    }

    @Override
    protected void setup(AdminUI ui, InspectorPanel host) {
        super.setup(ui, host);
        this.setLayout(new BorderLayout());
        this._textArea = new JTextArea();
        this._textArea.setEditable(false);
        ui.registerTextComponent(this._textArea);
        JScrollPane scrollPane = new JScrollPane(this._textArea, 20, 30);
        scrollPane.setPreferredSize(new Dimension(500, 100));
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
    }

    @Override
    protected void refreshed() {
        Management.LogicalRecord lr = this._host.getLogicalRecord();
        if (lr == null) {
            this.nullData();
        } else if (this._host.isShowValue()) {
            this._textArea.setText(lr.getValueString());
        } else {
            this._textArea.setText(lr.getKeyString());
        }
    }

    void nullMessage() {
        this._textArea.setText(this._adminUI.getNullMessage());
    }

    @Override
    protected void waiting() {
        this._textArea.setText(this._adminUI.getWaitingMessage());
    }
}

