/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.util;

import com.persistit.KeyState;
import com.persistit.ValueState;
import com.persistit.exception.AppendableIOException;
import com.persistit.exception.PersistitInterruptedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class Util {
    static final byte[] NULLS = new byte[1024];
    static final String SPACES = "                                                                    ";
    private static final String UTF8 = "UTF-8";
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static final String REGEX_QUOTE = "^$*+?()[].";
    public static final long NS_PER_S = 1000000000L;
    public static final long MS_PER_S = 1000L;
    public static final long NS_PER_MS = 1000000L;
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static int getByte(byte[] bytes, int index) {
        return bytes[index + 0] & 0xFF;
    }

    public static int getShort(byte[] bytes, int index) {
        return bytes[index + 1] & 0xFF | bytes[index + 0] << 8;
    }

    public static int getChar(byte[] bytes, int index) {
        return bytes[index + 1] & 0xFF | (bytes[index + 0] & 0xFF) << 8;
    }

    public static int getInt(byte[] bytes, int index) {
        return bytes[index + 3] & 0xFF | (bytes[index + 2] & 0xFF) << 8 | (bytes[index + 1] & 0xFF) << 16 | (bytes[index + 0] & 0xFF) << 24;
    }

    public static long getLong(byte[] bytes, int index) {
        return (long)(bytes[index + 7] & 0xFF) | (long)(bytes[index + 6] & 0xFF) << 8 | (long)(bytes[index + 5] & 0xFF) << 16 | (long)(bytes[index + 4] & 0xFF) << 24 | (long)(bytes[index + 3] & 0xFF) << 32 | (long)(bytes[index + 2] & 0xFF) << 40 | (long)(bytes[index + 1] & 0xFF) << 48 | (long)(bytes[index + 0] & 0xFF) << 56;
    }

    public static void putByte(byte[] bytes, int index, int value) {
        bytes[index + 0] = (byte)value;
    }

    public static void putShort(byte[] bytes, int index, int value) {
        bytes[index + 1] = (byte)value;
        bytes[index + 0] = (byte)(value >>> 8);
    }

    public static void putChar(byte[] bytes, int index, int value) {
        bytes[index + 1] = (byte)value;
        bytes[index + 0] = (byte)(value >>> 8);
    }

    public static void putInt(byte[] bytes, int index, int value) {
        bytes[index + 3] = (byte)value;
        bytes[index + 2] = (byte)(value >>> 8);
        bytes[index + 1] = (byte)(value >>> 16);
        bytes[index + 0] = (byte)(value >>> 24);
    }

    public static void putLong(byte[] bytes, int index, long value) {
        bytes[index + 7] = (byte)value;
        bytes[index + 6] = (byte)(value >>> 8);
        bytes[index + 5] = (byte)(value >>> 16);
        bytes[index + 4] = (byte)(value >>> 24);
        bytes[index + 3] = (byte)(value >>> 32);
        bytes[index + 2] = (byte)(value >>> 40);
        bytes[index + 1] = (byte)(value >>> 48);
        bytes[index + 0] = (byte)(value >>> 56);
    }

    public static int putBytes(byte[] bytes, int index, byte[] value) {
        System.arraycopy(value, 0, bytes, index, value.length);
        return value.length;
    }

    public static boolean changeBytes(byte[] bytes, int index, byte[] value) {
        boolean same = Util.equalsByteSubarray(bytes, index, value);
        if (same) {
            return false;
        }
        Util.putBytes(bytes, index, value);
        return true;
    }

    public static boolean changeByte(byte[] bytes, int index, byte value) {
        if (Util.getByte(bytes, index) == value) {
            return false;
        }
        Util.putByte(bytes, index, value);
        return true;
    }

    public static boolean changeChar(byte[] bytes, int index, char value) {
        if (Util.getChar(bytes, index) == value) {
            return false;
        }
        Util.putChar(bytes, index, value);
        return true;
    }

    public static boolean changeShort(byte[] bytes, int index, short value) {
        if (Util.getShort(bytes, index) == value) {
            return false;
        }
        Util.putShort(bytes, index, value);
        return true;
    }

    public static boolean changeInt(byte[] bytes, int index, int value) {
        if (Util.getInt(bytes, index) == value) {
            return false;
        }
        Util.putInt(bytes, index, value);
        return true;
    }

    public static boolean changeLong(byte[] bytes, int index, long value) {
        if (Util.getLong(bytes, index) == value) {
            return false;
        }
        Util.putLong(bytes, index, value);
        return true;
    }

    public static String format(String s, int width, boolean right) {
        int pad = width - s.length();
        if (pad < 0) {
            return s.substring(0, width - 1) + "&";
        }
        if (pad == 0) {
            return s;
        }
        if (right) {
            return SPACES.substring(0, pad) + s;
        }
        return s + SPACES.substring(0, pad);
    }

    public static String format(int i) {
        return Util.format(i, 10);
    }

    public static String format(long i) {
        return Util.format(i, 22);
    }

    public static String format(long i, int width) {
        return Util.format(Long.toString(i), width, true);
    }

    public static String abridge(String s, int maxLength) {
        if (s.length() > maxLength) {
            return s.substring(0, maxLength - 3) + "...";
        }
        return s;
    }

    public static boolean equalsByteSubarray(byte[] source, int next, byte[] target) {
        return Util.equalsByteSubarray(source, next, target, 0, target.length);
    }

    public static boolean equalsByteSubarray(byte[] source, int soffset, byte[] target, int toffset, int length) {
        for (int index = 0; index < length; ++index) {
            if (source[soffset + index] == target[toffset + index]) continue;
            return false;
        }
        return true;
    }

    public static void fill(StringBuilder sb, long value, int width) {
        Util.fill(sb, Long.toString(value), width);
    }

    public static void fill(StringBuilder sb, String s, int width) {
        for (int i = s.length(); i < width; ++i) {
            sb.append(' ');
        }
        sb.append(s);
    }

    public static String dump(KeyState ks) {
        byte[] bytes = ks.getBytes();
        return Util.dump(bytes, 0, bytes.length);
    }

    public static String dump(ValueState vs) {
        byte[] bytes = vs.getEncodedBytes();
        return Util.dump(bytes, 0, bytes.length);
    }

    public static String dump(byte[] b, int offset, int size) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (int m = 0; m < size - offset; m += 16) {
            sb2.setLength(0);
            Util.hex(sb, m, 4);
            sb.append(": ");
            for (int i = 0; i < 16; ++i) {
                int j;
                sb.append(" ");
                if (i % 8 == 0) {
                    sb.append(" ");
                }
                if ((j = m + i) < size - offset) {
                    Util.hex(sb, b[j + offset], 2);
                    char c = (char)(b[j + offset] & 0xFF);
                    if (c >= ' ' && c < '\u007f') {
                        sb2.append(c);
                        continue;
                    }
                    sb2.append(".");
                    continue;
                }
                sb.append("  ");
            }
            sb.append("   ");
            sb.append(sb2.toString());
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    public static String dump(char[] c, int offset, int size) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (int m = 0; m < size - offset; m += 8) {
            sb2.setLength(0);
            Util.hex(sb, m, 4);
            sb.append(":");
            for (int i = 0; i < 8; ++i) {
                int j;
                sb.append("  ");
                if (i % 4 == 0) {
                    sb.append(" ");
                }
                if ((j = m + i) < size - offset) {
                    Util.hex(sb, c[j + offset], 4);
                    if (c[j + offset] >= ' ' && c[j] < '\u007f') {
                        sb2.append(c[j]);
                        continue;
                    }
                    sb2.append(".");
                    continue;
                }
                sb.append("    ");
            }
            sb.append("    ");
            sb.append(sb2.toString());
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    public static String hexDump(byte[] b) {
        return Util.hexDump(b, 0, b.length);
    }

    public static String hexDump(byte[] b, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        sb2.setLength(0);
        for (int i = offset; i < offset + length; ++i) {
            sb.append(" ");
            Util.hex(sb, b[i], 2);
            char c = (char)(b[i] & 0xFF);
            if (c >= ' ' && c < '\u007f') {
                sb2.append(c);
                continue;
            }
            sb2.append(".");
        }
        sb.append(" / ");
        sb.append(sb2.toString());
        return sb.toString();
    }

    public static Appendable hex(Appendable sb, long value, int length) {
        for (int i = length - 1; i >= 0; --i) {
            Util.append(sb, HEX_DIGITS[(int)(value >> i * 4) & 0xF]);
        }
        return sb;
    }

    public static byte[] stringToBytes(String s) {
        if (s == null) {
            return new byte[0];
        }
        try {
            return s.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes();
        }
    }

    public static boolean isValidName(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        Util.bytesToHex(sb, bytes, 0, bytes.length);
        return sb.toString();
    }

    public static void bytesToHex(Appendable sb, byte[] bytes, int offset, int length) {
        length += offset;
        for (int i = offset; i < length; ++i) {
            Util.append(sb, HEX_DIGITS[bytes[i] >>> 4 & 0xF]);
            Util.append(sb, HEX_DIGITS[bytes[i] >>> 0 & 0xF]);
        }
    }

    public static byte[] hexToBytes(String hex) {
        char c;
        char c2;
        int count = 0;
        for (int i = 0; i < hex.length() && (c2 = hex.charAt(i)) != '/' && c2 != '}'; ++i) {
            if (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F') {
                ++count;
                continue;
            }
            if (c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n') continue;
            throw new IllegalArgumentException();
        }
        if (count % 2 == 1) {
            throw new IllegalArgumentException();
        }
        byte[] result = new byte[count / 2];
        int t = 0;
        count = 0;
        for (int i = 0; i < hex.length() && (c = hex.charAt(i)) != '/' && c != '}'; ++i) {
            if (c >= '0' && c <= '9') {
                t = t * 16 + c - 48;
            } else if (c >= 'a' && c <= 'f') {
                t = t * 16 + c - 97 + 10;
            } else {
                if (c < 'A' || c > 'F') continue;
                t = t * 16 + c - 65 + 10;
            }
            if (++count % 2 != 0) continue;
            result[count / 2 - 1] = (byte)t;
            t = 0;
        }
        return result;
    }

    public static String replaceFileSuffix(String name, String suffix) {
        int q;
        if (suffix.indexOf(47) >= 0 || suffix.indexOf(92) > 0) {
            return suffix;
        }
        int p = name.lastIndexOf(47);
        p = Math.max(p, name.lastIndexOf(92));
        if (suffix.startsWith(".") && (q = name.lastIndexOf(46)) > p) {
            p = q - 1;
        }
        if (p > 0) {
            return name.substring(0, p + 1) + suffix;
        }
        return name + suffix;
    }

    public static void clearBytes(byte[] bytes, int from, int to) {
        for (int offset = from; offset < to; offset += NULLS.length) {
            int count = to - offset;
            if (count > NULLS.length) {
                count = NULLS.length;
            }
            System.arraycopy(NULLS, 0, bytes, offset, count);
        }
    }

    public static void appendQuotedString(Appendable sb, String s, int start, int length) {
        int end = Math.min(start + length, s.length());
        for (int index = start; index < end; ++index) {
            Util.appendQuotedChar(sb, s.charAt(index));
        }
    }

    public static void append(Appendable sb, char c) {
        try {
            sb.append(c);
        }
        catch (IOException e) {
            throw new AppendableIOException(e);
        }
    }

    public static void append(Appendable sb, CharSequence s) {
        try {
            sb.append(s);
        }
        catch (IOException e) {
            throw new AppendableIOException(e);
        }
    }

    public static void appendQuotedChar(Appendable sb, int c) {
        int q = 0;
        if (c == 8) {
            q = 98;
        } else if (c == 10) {
            q = 110;
        } else if (c == 13) {
            q = 114;
        } else if (c == 9) {
            q = 116;
        } else if (c == 34 || c == 92) {
            q = c;
        }
        if (q != 0) {
            Util.append(sb, '\\');
            Util.append(sb, (char)q);
        } else if (c >= 127 || c < 20) {
            Util.append(sb, '\\');
            Util.append(sb, 'u');
            Util.hex(sb, c, 4);
        } else {
            Util.append(sb, (char)c);
        }
    }

    public static String date(long t) {
        if (t == 0L) {
            return "none";
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(t));
    }

    public static void println(String template, Object ... args) {
        System.out.println(String.format(template, args));
    }

    public static boolean bytesEqual(byte[] source, int offset, byte[] target) {
        for (int index = 0; index < target.length; ++index) {
            if (source[index + offset] == target[index]) continue;
            return false;
        }
        return true;
    }

    public static void sleep(long millis) throws PersistitInterruptedException {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            throw new PersistitInterruptedException(ie);
        }
    }

    public static void spinSleep() throws PersistitInterruptedException {
        Util.sleep(1L);
    }

    public static String toString(Object object) {
        return object == null ? null : object.toString();
    }

    public static int rangeCheck(int value, int min, int max) {
        if (value >= min && value <= max) {
            return value;
        }
        if (min == Integer.MIN_VALUE) {
            throw new IllegalArgumentException(String.format("Value must be less than or equals to %,d: %,d", max, value));
        }
        if (max == Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Value must be greater than or equal to %,d: %,d", min, value));
        }
        throw new IllegalArgumentException(String.format("Value must be between %d and %d, inclusive: ", min, max, value));
    }

    public static long rangeCheck(long value, long min, long max) {
        if (value >= min && value <= max) {
            return value;
        }
        if (min == Long.MIN_VALUE) {
            throw new IllegalArgumentException(String.format("Value must be less than or equals to %,d: %,d", max, value));
        }
        if (max == Long.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Value must be greater than or equal to %,d: %,d", min, value));
        }
        throw new IllegalArgumentException(String.format("Value must be between %d and %d, inclusive: ", min, max, value));
    }

    public static float rangeCheck(float value, float min, float max) {
        if (value >= min && value <= max) {
            return value;
        }
        if (min == Float.MIN_VALUE) {
            throw new IllegalArgumentException(String.format("Value must be less than or equals to %,f: %,f", Float.valueOf(max), Float.valueOf(value)));
        }
        if (max == Float.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Value must be greater than or equal to %,f: %,f", Float.valueOf(min), Float.valueOf(value)));
        }
        throw new IllegalArgumentException(String.format("Value must be between %f and %f, inclusive: ", Float.valueOf(min), Float.valueOf(max), Float.valueOf(value)));
    }

    public static Pattern pattern(String s, boolean caseInsensitive) {
        StringBuilder sb = new StringBuilder();
        if (s == null) {
            sb.append(".*");
        } else {
            for (int index = 0; index < s.length(); ++index) {
                char c = s.charAt(index);
                if (c == '*') {
                    sb.append(".*");
                    continue;
                }
                if (c == '?') {
                    sb.append(".");
                    continue;
                }
                if (REGEX_QUOTE.indexOf(c) != -1) {
                    sb.append('\\');
                    sb.append(c);
                    continue;
                }
                sb.append(c);
            }
        }
        return Pattern.compile(sb.toString(), caseInsensitive ? 2 : 0);
    }
}

