/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.Assert;

public abstract class AbstractRabbitListenerEndpoint
implements RabbitListenerEndpoint,
BeanFactoryAware {
    private String id;
    private final Collection<Queue> queues = new ArrayList<Queue>();
    private final Collection<String> queueNames = new ArrayList<String>();
    private boolean exclusive;
    private Integer priority;
    private RabbitAdmin admin;
    private BeanFactory beanFactory;
    private BeanExpressionResolver resolver;
    private BeanExpressionContext expressionContext;
    private String group;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected BeanExpressionResolver getResolver() {
        return this.resolver;
    }

    protected BeanExpressionContext getBeanExpressionContext() {
        return this.expressionContext;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setQueues(Queue ... queues) {
        Assert.notNull((Object)queues, (String)"'queues' must not be null");
        this.queues.clear();
        this.queues.addAll(Arrays.asList(queues));
    }

    public Collection<Queue> getQueues() {
        return this.queues;
    }

    public Collection<String> getQueueNames() {
        return this.queueNames;
    }

    public void setQueueNames(String ... queueNames) {
        Assert.notNull((Object)queueNames, (String)"'queueNames' must not be null");
        this.queueNames.clear();
        this.queueNames.addAll(Arrays.asList(queueNames));
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setAdmin(RabbitAdmin admin) {
        this.admin = admin;
    }

    public RabbitAdmin getAdmin() {
        return this.admin;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public void setupListenerContainer(MessageListenerContainer listenerContainer) {
        SimpleMessageListenerContainer container = (SimpleMessageListenerContainer)listenerContainer;
        boolean queuesEmpty = this.getQueues().isEmpty();
        boolean queueNamesEmpty = this.getQueueNames().isEmpty();
        if (!queuesEmpty && !queueNamesEmpty) {
            throw new IllegalStateException("Queues or queue names must be provided but not both for " + this);
        }
        if (queuesEmpty) {
            Collection<String> names = this.getQueueNames();
            container.setQueueNames(names.toArray(new String[names.size()]));
        } else {
            Collection<Queue> instances = this.getQueues();
            container.setQueues(instances.toArray(new Queue[instances.size()]));
        }
        container.setExclusive(this.isExclusive());
        if (this.getPriority() != null) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("x-priority", this.getPriority());
            container.setConsumerArguments(args);
        }
        if (this.getAdmin() != null) {
            container.setRabbitAdmin(this.getAdmin());
        }
        this.setupMessageListener(listenerContainer);
    }

    protected abstract MessageListener createMessageListener(MessageListenerContainer var1);

    private void setupMessageListener(MessageListenerContainer container) {
        MessageListener messageListener = this.createMessageListener(container);
        Assert.state((messageListener != null ? 1 : 0) != 0, (String)("Endpoint [" + this + "] must provide a non null message listener"));
        container.setupMessageListener(messageListener);
    }

    protected StringBuilder getEndpointDescription() {
        StringBuilder result = new StringBuilder();
        return result.append(this.getClass().getSimpleName()).append("[").append(this.id).append("] queues=").append(this.queues).append("' | queueNames='").append(this.queueNames).append("' | exclusive='").append(this.exclusive).append("' | priority='").append(this.priority).append("' | admin='").append(this.admin).append("'");
    }

    public String toString() {
        return this.getEndpointDescription().toString();
    }
}

