/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.support.SimpleJobOperator;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.batch.BasicBatchConfigurer;
import org.springframework.boot.autoconfigure.batch.BatchDatabaseInitializer;
import org.springframework.boot.autoconfigure.batch.JobExecutionExitCodeGenerator;
import org.springframework.boot.autoconfigure.batch.JobLauncherCommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={JobLauncher.class, DataSource.class, JdbcOperations.class})
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
@ConditionalOnBean(value={JobLauncher.class})
public class BatchAutoConfiguration {
    @Value(value="${spring.batch.job.names:}")
    private String jobNames;
    @Autowired(required=false)
    private JobParametersConverter jobParametersConverter;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DataSource.class})
    public BatchDatabaseInitializer batchDatabaseInitializer() {
        return new BatchDatabaseInitializer();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="${spring.batch.job.enabled:true}")
    public JobLauncherCommandLineRunner jobLauncherCommandLineRunner(JobLauncher jobLauncher, JobExplorer jobExplorer) {
        JobLauncherCommandLineRunner runner = new JobLauncherCommandLineRunner(jobLauncher, jobExplorer);
        if (StringUtils.hasText((String)this.jobNames)) {
            runner.setJobNames(this.jobNames);
        }
        return runner;
    }

    @Bean
    @ConditionalOnMissingBean
    public ExitCodeGenerator jobExecutionExitCodeGenerator() {
        return new JobExecutionExitCodeGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DataSource.class})
    public JobExplorer jobExplorer(DataSource dataSource) throws Exception {
        JobExplorerFactoryBean factory = new JobExplorerFactoryBean();
        factory.setDataSource(dataSource);
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    @Bean
    @ConditionalOnMissingBean
    public JobOperator jobOperator(JobExplorer jobExplorer, JobLauncher jobLauncher, ListableJobLocator jobRegistry, JobRepository jobRepository) throws Exception {
        SimpleJobOperator factory = new SimpleJobOperator();
        factory.setJobExplorer(jobExplorer);
        factory.setJobLauncher(jobLauncher);
        factory.setJobRegistry(jobRegistry);
        factory.setJobRepository(jobRepository);
        if (this.jobParametersConverter != null) {
            factory.setJobParametersConverter(this.jobParametersConverter);
        }
        return factory;
    }

    @ConditionalOnClass(name={"javax.persistence.EntityManagerFactory"})
    @ConditionalOnMissingBean(value={BatchConfigurer.class})
    @Configuration
    protected static class JpaBatchConfiguration {
        protected JpaBatchConfiguration() {
        }

        @Bean
        @ConditionalOnBean(name={"entityManagerFactory"})
        public BatchConfigurer jpaBatchConfigurer(DataSource dataSource, EntityManagerFactory entityManagerFactory) {
            return new BasicBatchConfigurer(dataSource, entityManagerFactory);
        }

        @Bean
        @ConditionalOnMissingBean(name={"entityManagerFactory"})
        public BatchConfigurer basicBatchConfigurer(DataSource dataSource) {
            return new BasicBatchConfigurer(dataSource);
        }
    }
}

