/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.remote.server;

import org.springframework.boot.devtools.remote.server.Handler;
import org.springframework.boot.devtools.remote.server.HandlerMapper;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.util.Assert;

public class UrlHandlerMapper
implements HandlerMapper {
    private final String requestUri;
    private final Handler handler;

    public UrlHandlerMapper(String url, Handler handler) {
        Assert.hasLength((String)url, (String)"'url' must not be empty");
        Assert.isTrue((boolean)url.startsWith("/"), (String)"'url' must start with '/'");
        this.requestUri = url;
        this.handler = handler;
    }

    @Override
    public Handler getHandler(ServerHttpRequest request) {
        if (this.requestUri.equals(request.getURI().getPath())) {
            return this.handler;
        }
        return null;
    }
}

