/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.converter.autoconfigure;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConverters;
import org.springframework.boot.http.converter.autoconfigure.ServerHttpMessageConvertersCustomizer;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.KotlinSerializationJsonHttpMessageConverter;
import org.springframework.util.MimeType;

class DefaultServerHttpMessageConvertersCustomizer
implements ServerHttpMessageConvertersCustomizer {
    private final @Nullable HttpMessageConverters legacyConverters;
    private final Collection<HttpMessageConverter<?>> converters;

    DefaultServerHttpMessageConvertersCustomizer(@Nullable HttpMessageConverters legacyConverters, Collection<HttpMessageConverter<?>> converters) {
        this.legacyConverters = legacyConverters;
        this.converters = converters;
    }

    @Override
    public void customize(HttpMessageConverters.ServerBuilder builder) {
        if (this.legacyConverters != null) {
            this.legacyConverters.forEach(arg_0 -> ((HttpMessageConverters.ServerBuilder)builder).addCustomConverter(arg_0));
        } else {
            builder.registerDefaults();
            this.converters.forEach(converter -> {
                if (converter instanceof StringHttpMessageConverter) {
                    builder.withStringConverter(converter);
                } else if (converter instanceof KotlinSerializationJsonHttpMessageConverter) {
                    builder.withKotlinSerializationJsonConverter(converter);
                } else if (DefaultServerHttpMessageConvertersCustomizer.supportsMediaType(converter, MediaType.APPLICATION_JSON)) {
                    builder.withJsonConverter(converter);
                } else if (DefaultServerHttpMessageConvertersCustomizer.supportsMediaType(converter, MediaType.APPLICATION_XML)) {
                    builder.withXmlConverter(converter);
                } else {
                    builder.addCustomConverter(converter);
                }
            });
        }
    }

    private static boolean supportsMediaType(HttpMessageConverter<?> converter, MediaType mediaType) {
        for (MediaType supportedMediaType : converter.getSupportedMediaTypes()) {
            if (!supportedMediaType.equalsTypeAndSubtype((MimeType)mediaType)) continue;
            return true;
        }
        return false;
    }
}

