/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public abstract class FileUtils {
    public static void removeDuplicatesFromOutputDirectory(File outputDirectory, File originDirectory) {
        if (originDirectory.isDirectory()) {
            String[] files = originDirectory.list();
            Assert.state((files != null ? 1 : 0) != 0, (String)"'files' must not be null");
            for (String name : files) {
                File targetFile = new File(outputDirectory, name);
                if (!targetFile.exists() || !targetFile.canWrite()) continue;
                if (!targetFile.isDirectory()) {
                    targetFile.delete();
                    continue;
                }
                FileUtils.removeDuplicatesFromOutputDirectory(targetFile, new File(originDirectory, name));
            }
        }
    }

    public static boolean isSignedJarFile(@Nullable File file) throws IOException {
        if (file == null) {
            return false;
        }
        try (JarFile jarFile = new JarFile(file);){
            if (FileUtils.hasDigestEntry(jarFile.getManifest())) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static boolean hasDigestEntry(@Nullable Manifest manifest) {
        return manifest != null && manifest.getEntries().values().stream().anyMatch(FileUtils::hasDigestName);
    }

    private static boolean hasDigestName(Attributes attributes) {
        return attributes.keySet().stream().anyMatch(FileUtils::isDigestName);
    }

    private static boolean isDigestName(Object name) {
        return String.valueOf(name).toUpperCase(Locale.ROOT).endsWith("-DIGEST");
    }
}

