/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.springframework.boot.json.JsonWriter;
import org.springframework.boot.logging.StackTracePrinter;
import org.springframework.boot.logging.log4j2.Extractor;
import org.springframework.boot.logging.log4j2.StructuredMessage;
import org.springframework.boot.logging.structured.ContextPairs;
import org.springframework.boot.logging.structured.ElasticCommonSchemaProperties;
import org.springframework.boot.logging.structured.JsonWriterStructuredLogFormatter;
import org.springframework.boot.logging.structured.StructuredLoggingJsonMembersCustomizer;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

class ElasticCommonSchemaStructuredLogFormatter
extends JsonWriterStructuredLogFormatter<LogEvent> {
    ElasticCommonSchemaStructuredLogFormatter(Environment environment, StackTracePrinter stackTracePrinter, ContextPairs contextPairs, StructuredLoggingJsonMembersCustomizer.Builder<?> customizerBuilder) {
        super(members -> ElasticCommonSchemaStructuredLogFormatter.jsonMembers(environment, stackTracePrinter, contextPairs, members), customizerBuilder.nested().build());
    }

    private static void jsonMembers(Environment environment, StackTracePrinter stackTracePrinter, ContextPairs contextPairs, JsonWriter.Members<LogEvent> members) {
        Extractor extractor = new Extractor(stackTracePrinter);
        members.add("@timestamp", LogEvent::getInstant).as(ElasticCommonSchemaStructuredLogFormatter::asTimestamp);
        members.add("log").usingMembers(log -> {
            log.add("level", LogEvent::getLevel).as(Level::name);
            log.add("logger", LogEvent::getLoggerName);
        });
        members.add("process").usingMembers(process -> {
            process.add("pid", (Long)environment.getProperty("spring.application.pid", Long.class)).when(Objects::nonNull);
            process.add("thread").usingMembers(thread -> thread.add("name", LogEvent::getThreadName));
        });
        ElasticCommonSchemaProperties.get(environment).jsonMembers(members);
        members.add("message", LogEvent::getMessage).as(StructuredMessage::get);
        members.from(LogEvent::getContextData).usingPairs(contextPairs.nested(ElasticCommonSchemaStructuredLogFormatter::addContextDataPairs));
        members.from(LogEvent::getThrownProxy).whenNotNull().usingMembers(thrownProxyMembers -> thrownProxyMembers.add("error").usingMembers(error -> {
            error.add("type", ThrowableProxy::getThrowable).whenNotNull().as(ObjectUtils::nullSafeClassName);
            error.add("message", ThrowableProxy::getMessage);
            error.add("stack_trace", extractor::stackTrace);
        }));
        members.add("tags", LogEvent::getMarker).whenNotNull().as(ElasticCommonSchemaStructuredLogFormatter::getMarkers).whenNotEmpty();
        members.add("ecs").usingMembers(ecs -> ecs.add("version", "8.11"));
    }

    private static void addContextDataPairs(ContextPairs.Pairs<ReadOnlyStringMap> contextPairs) {
        contextPairs.add((contextData, pairs) -> contextData.forEach(pairs::accept));
    }

    private static Instant asTimestamp(org.apache.logging.log4j.core.time.Instant instant) {
        return Instant.ofEpochMilli(instant.getEpochMillisecond()).plusNanos(instant.getNanoOfMillisecond());
    }

    private static Set<String> getMarkers(Marker marker) {
        TreeSet<String> result = new TreeSet<String>();
        ElasticCommonSchemaStructuredLogFormatter.addMarkers(result, marker);
        return result;
    }

    private static void addMarkers(Set<String> result, Marker marker) {
        result.add(marker.getName());
        if (marker.hasParents()) {
            for (Marker parent : marker.getParents()) {
                ElasticCommonSchemaStructuredLogFormatter.addMarkers(result, parent);
            }
        }
    }
}

