/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.util.StringUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ClasspathStubProvider
implements StubDownloaderBuilder {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver((ResourceLoader)new DefaultResourceLoader());

    @Override
    public StubDownloader build(final StubRunnerOptions stubRunnerOptions) {
        return new StubDownloader(){

            @Override
            public Map.Entry<StubConfiguration, File> downloadAndUnpackStubJar(StubConfiguration config) {
                List repoRoots = ClasspathStubProvider.this.repoRoot(stubRunnerOptions, config);
                List paths = ClasspathStubProvider.this.toPaths(repoRoots);
                List<Resource> resources = ClasspathStubProvider.this.resolveResources(paths);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("For paths " + paths + " found following resources " + resources));
                }
                if (resources.isEmpty()) {
                    throw new IllegalStateException("No stubs were found on classpath for [" + config.getGroupId() + ":" + config.getArtifactId() + "]");
                }
                File tmp = ClasspathStubProvider.this.createTempDir();
                tmp.deleteOnExit();
                Pattern groupAndArtifactPattern = Pattern.compile("^(.*)(" + config.getGroupId() + "." + config.getArtifactId() + ")(.*)$");
                String version = config.getVersion();
                for (Resource resource : resources) {
                    try {
                        String relativePath = this.relativePathPicker(resource, groupAndArtifactPattern);
                        int lastIndexOf = relativePath.lastIndexOf(File.separator);
                        String relativePathWithoutFile = lastIndexOf > -1 ? relativePath.substring(0, lastIndexOf) : relativePath;
                        Path directory = Files.createDirectories(new File(tmp, relativePathWithoutFile).toPath(), new FileAttribute[0]);
                        File newFile = new File(directory.toFile(), resource.getFilename());
                        if (!newFile.exists() && !this.isDirectory(resource)) {
                            Files.copy(resource.getInputStream(), newFile.toPath(), new CopyOption[0]);
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Stored file [" + newFile + "]"));
                    }
                    catch (IOException e) {
                        log.error((Object)"Exception occurred while trying to create dirs", (Throwable)e);
                        throw new IllegalStateException(e);
                    }
                }
                log.info((Object)("Unpacked files for [" + config.getGroupId() + ":" + config.getArtifactId() + ":" + version + "] to folder [" + tmp + "]"));
                return new AbstractMap.SimpleEntry<StubConfiguration, File>(new StubConfiguration(config.getGroupId(), config.getArtifactId(), version, config.getClassifier()), tmp);
            }

            boolean isDirectory(Resource resource) {
                try {
                    return resource.getFile().isDirectory();
                }
                catch (Exception e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Exception occurred while trying to convert path to file for resource [" + resource + "]"), (Throwable)e);
                    }
                    return false;
                }
            }

            String relativePathPicker(Resource resource, Pattern groupAndArtifactPattern) throws IOException {
                String uri = resource.getURI().toString();
                Matcher groupAndArtifactMatcher = groupAndArtifactPattern.matcher(uri);
                if (groupAndArtifactMatcher.matches()) {
                    MatchResult groupAndArtifactResult = groupAndArtifactMatcher.toMatchResult();
                    return groupAndArtifactResult.group(2) + File.separator + groupAndArtifactResult.group(3);
                }
                throw new IllegalArgumentException("Illegal uri [${uri}]");
            }
        };
    }

    private List<String> toPaths(List<RepoRoot> repoRoots) {
        ArrayList<String> list = new ArrayList<String>();
        for (RepoRoot repoRoot : repoRoots) {
            list.add(repoRoot.fullPath);
        }
        return list;
    }

    List<Resource> resolveResources(List<String> paths) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String path : paths) {
            try {
                List<Resource> list = Arrays.asList(this.resolver.getResources(path));
                resources.addAll(list);
            }
            catch (IOException e) {
                log.error((Object)("Exception occurred while trying to fetch resources from [" + path + "]"));
                throw new IllegalStateException(e);
            }
        }
        return resources;
    }

    private List<RepoRoot> repoRoot(StubRunnerOptions stubRunnerOptions, StubConfiguration configuration) {
        if (StringUtils.hasText(stubRunnerOptions.getStubRepositoryRoot())) {
            return Collections.singletonList(new RepoRoot(stubRunnerOptions.getStubRepositoryRoot()));
        }
        String path = "/**/" + configuration.getGroupId() + "/" + configuration.getArtifactId();
        return Arrays.asList(new RepoRoot("classpath*:/META-INF" + path, "/**/*.*"), new RepoRoot("classpath*:/contracts" + path, "/**/*.*"), new RepoRoot("classpath*:/mappings" + path, "/**/*.*"));
    }

    private File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ")");
    }

    private static class RepoRoot {
        final String repoRoot;
        final String fullPath;

        RepoRoot(String repoRoot) {
            this.repoRoot = repoRoot;
            this.fullPath = repoRoot + "";
        }

        RepoRoot(String repoRoot, String suffix) {
            this.repoRoot = repoRoot;
            this.fullPath = repoRoot + suffix;
        }
    }
}

