/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.provider.wiremock;

import com.github.jknack.handlebars.Helper;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.stubrunner.HttpServerStub;
import org.springframework.cloud.contract.verifier.builder.handlebars.HandlebarsEscapeHelper;
import org.springframework.cloud.contract.verifier.builder.handlebars.HandlebarsJsonPathHelper;
import org.springframework.cloud.contract.wiremock.WireMockSpring;
import org.springframework.util.ClassUtils;
import org.springframework.util.SocketUtils;
import org.springframework.util.StreamUtils;

public class WireMockHttpServerStub
implements HttpServerStub {
    private static final Logger log = LoggerFactory.getLogger(WireMockHttpServerStub.class);
    private static final int INVALID_PORT = -1;
    private WireMockServer wireMockServer;

    private WireMockConfiguration config() {
        if (ClassUtils.isPresent((String)"org.springframework.cloud.contract.wiremock.WireMockSpring", null)) {
            return WireMockSpring.options().extensions(new Extension[]{this.responseTemplateTransformer()});
        }
        return new WireMockConfiguration().extensions(new Extension[]{this.responseTemplateTransformer()});
    }

    private ResponseTemplateTransformer responseTemplateTransformer() {
        return new ResponseTemplateTransformer(false, this.helpers());
    }

    protected Map<String, Helper> helpers() {
        HashMap<String, Helper> helpers = new HashMap<String, Helper>();
        helpers.put("jsonpath", (Helper)new HandlebarsJsonPathHelper());
        helpers.put("escapejsonbody", (Helper)new HandlebarsEscapeHelper());
        return helpers;
    }

    @Override
    public int port() {
        return this.isRunning() ? this.wireMockServer.port() : -1;
    }

    @Override
    public boolean isRunning() {
        return this.wireMockServer != null && this.wireMockServer.isRunning();
    }

    @Override
    public HttpServerStub start() {
        if (this.isRunning()) {
            if (log.isDebugEnabled()) {
                log.debug("The server is already running at port [" + this.port() + "]");
            }
            return this;
        }
        return this.start(SocketUtils.findAvailableTcpPort());
    }

    @Override
    public HttpServerStub start(int port) {
        this.wireMockServer = new WireMockServer((Options)this.config().port(port));
        this.wireMockServer.start();
        return this;
    }

    @Override
    public HttpServerStub stop() {
        if (!this.isRunning()) {
            if (log.isDebugEnabled()) {
                log.debug("Trying to stop a non started server!");
            }
            return this;
        }
        this.wireMockServer.stop();
        return this;
    }

    @Override
    public HttpServerStub registerMappings(Collection<File> stubFiles) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Server not started!");
        }
        this.registerStubMappings(stubFiles);
        return this;
    }

    @Override
    public boolean isAccepted(File file) {
        return file.getName().endsWith(".json");
    }

    StubMapping getMapping(File file) {
        try {
            return StubMapping.buildFrom((String)StreamUtils.copyToString((InputStream)new FileInputStream(file), (Charset)Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read file", e);
        }
    }

    private void registerStubMappings(Collection<File> stubFiles) {
        WireMock wireMock = new WireMock("localhost", this.port(), "");
        this.registerDefaultHealthChecks(wireMock);
        this.registerStubs(stubFiles, wireMock);
    }

    private void registerDefaultHealthChecks(WireMock wireMock) {
        this.registerHealthCheck(wireMock, "/ping");
        this.registerHealthCheck(wireMock, "/health");
    }

    private void registerStubs(Collection<File> sortedMappings, WireMock wireMock) {
        for (File mappingDescriptor : sortedMappings) {
            try {
                wireMock.register(this.getMapping(mappingDescriptor));
                if (!log.isDebugEnabled()) continue;
                log.debug("Registered stub mappings from [" + mappingDescriptor + "]");
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Failed to register the stub mapping [" + mappingDescriptor + "]", (Throwable)e);
            }
        }
    }

    private void registerHealthCheck(WireMock wireMock, String url) {
        this.registerHealthCheck(wireMock, url, "OK");
    }

    private void registerHealthCheck(WireMock wireMock, String url, String body) {
        wireMock.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withBody(body).withStatus(200)));
    }
}

