/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.util.StringUtils;

class StubRunnerRibbonServerList
implements ServerList<Server> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final ServerList<Server> serverList;

    StubRunnerRibbonServerList(StubFinder stubFinder, final StubMapperProperties stubMapperProperties, IClientConfig clientConfig, final ServerList<?> delegate) {
        String serviceName = clientConfig.getClientName();
        String mappedServiceName = StringUtils.hasText(stubMapperProperties.fromServiceIdToIvyNotation(serviceName)) ? stubMapperProperties.fromServiceIdToIvyNotation(serviceName) : serviceName;
        RunningStubs runningStubs = stubFinder.findAllRunningStubs();
        final Map.Entry<StubConfiguration, Integer> entry = runningStubs.getEntry(mappedServiceName);
        final ArrayList<1> servers = new ArrayList<1>();
        if (entry != null) {
            servers.add(new Server("localhost", entry.getValue()){

                public Server.MetaInfo getMetaInfo() {
                    return new Server.MetaInfo(){

                        public String getAppName() {
                            return stubMapperProperties.fromIvyNotationToId(((StubConfiguration)entry.getKey()).toColonSeparatedDependencyNotation());
                        }

                        public String getServerGroup() {
                            return null;
                        }

                        public String getServiceIdForDiscovery() {
                            return stubMapperProperties.fromIvyNotationToId(((StubConfiguration)entry.getKey()).getArtifactId());
                        }

                        public String getInstanceId() {
                            return stubMapperProperties.fromIvyNotationToId(((StubConfiguration)entry.getKey()).getArtifactId());
                        }
                    };
                }
            });
        }
        this.serverList = new ServerList<Server>(){

            public List<Server> getInitialListOfServers() {
                ArrayList<Server> combinedList;
                block2: {
                    combinedList = new ArrayList<Server>();
                    combinedList.addAll(servers);
                    try {
                        combinedList.addAll(delegate.getInitialListOfServers());
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block2;
                        log.debug((Object)"Exception occurred while trying to get list of servers", (Throwable)e);
                    }
                }
                return combinedList;
            }

            public List<Server> getUpdatedListOfServers() {
                ArrayList<Server> combinedList;
                block2: {
                    combinedList = new ArrayList<Server>();
                    combinedList.addAll(servers);
                    try {
                        combinedList.addAll(delegate.getUpdatedListOfServers());
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block2;
                        log.debug((Object)"Exception occurred while trying to get list of servers", (Throwable)e);
                    }
                }
                return combinedList;
            }
        };
    }

    public List<Server> getInitialListOfServers() {
        return this.serverList.getInitialListOfServers();
    }

    public List<Server> getUpdatedListOfServers() {
        return this.serverList.getUpdatedListOfServers();
    }
}

