/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.SQLType;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.SqlGenerator;
import org.springframework.data.jdbc.core.convert.SqlIdentifierParameterSource;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SqlParametersFactory {
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final Dialect dialect;

    public SqlParametersFactory(RelationalMappingContext context, JdbcConverter converter, Dialect dialect) {
        this.context = context;
        this.converter = converter;
        this.dialect = dialect;
    }

    <T> SqlIdentifierParameterSource forInsert(T instance, Class<T> domainType, Identifier identifier, IdValueSource idValueSource) {
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredPersistentEntity(domainType);
        SqlIdentifierParameterSource parameterSource = this.getParameterSource(instance, persistentEntity, "", PersistentProperty::isIdProperty, this.dialect.getIdentifierProcessing());
        identifier.forEach((name, value, type) -> this.addConvertedPropertyValue(parameterSource, name, value, type));
        if (IdValueSource.PROVIDED.equals((Object)idValueSource)) {
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)persistentEntity.getRequiredIdProperty();
            Object idValue = persistentEntity.getIdentifierAccessor(instance).getRequiredIdentifier();
            this.addConvertedPropertyValue(parameterSource, idProperty, idValue, idProperty.getColumnName());
        }
        return parameterSource;
    }

    <T> SqlIdentifierParameterSource forUpdate(T instance, Class<T> domainType) {
        return this.getParameterSource(instance, this.getRequiredPersistentEntity(domainType), "", Predicates.includeAll(), this.dialect.getIdentifierProcessing());
    }

    <T> SqlIdentifierParameterSource forQueryById(Object id, Class<T> domainType, SqlIdentifier name) {
        SqlIdentifierParameterSource parameterSource = new SqlIdentifierParameterSource(this.dialect.getIdentifierProcessing());
        this.addConvertedPropertyValue(parameterSource, (RelationalPersistentProperty)this.getRequiredPersistentEntity(domainType).getRequiredIdProperty(), id, name);
        return parameterSource;
    }

    <T> SqlIdentifierParameterSource forQueryByIds(Iterable<?> ids, Class<T> domainType) {
        SqlIdentifierParameterSource parameterSource = new SqlIdentifierParameterSource(this.dialect.getIdentifierProcessing());
        this.addConvertedPropertyValuesAsList(parameterSource, (RelationalPersistentProperty)this.getRequiredPersistentEntity(domainType).getRequiredIdProperty(), ids);
        return parameterSource;
    }

    SqlIdentifierParameterSource forQueryByIdentifier(Identifier identifier) {
        SqlIdentifierParameterSource parameterSource = new SqlIdentifierParameterSource(this.dialect.getIdentifierProcessing());
        identifier.toMap().forEach((name, value) -> this.addConvertedPropertyValue(parameterSource, (SqlIdentifier)name, value, value.getClass()));
        return parameterSource;
    }

    private void addConvertedPropertyValue(SqlIdentifierParameterSource parameterSource, RelationalPersistentProperty property, @Nullable Object value, SqlIdentifier name) {
        this.addConvertedValue(parameterSource, value, name, this.converter.getColumnType(property), this.converter.getTargetSqlType(property));
    }

    private void addConvertedPropertyValue(SqlIdentifierParameterSource parameterSource, SqlIdentifier name, Object value, Class<?> javaType) {
        this.addConvertedValue(parameterSource, value, name, javaType, JdbcUtil.targetSqlTypeFor(javaType));
    }

    private void addConvertedValue(SqlIdentifierParameterSource parameterSource, @Nullable Object value, SqlIdentifier paramName, Class<?> javaType, SQLType sqlType) {
        JdbcValue jdbcValue = this.converter.writeJdbcValue(value, javaType, sqlType);
        parameterSource.addValue(paramName, jdbcValue.getValue(), jdbcValue.getJdbcType().getVendorTypeNumber());
    }

    private void addConvertedPropertyValuesAsList(SqlIdentifierParameterSource parameterSource, RelationalPersistentProperty property, Iterable<?> values) {
        ArrayList<Object> convertedIds = new ArrayList<Object>();
        JdbcValue jdbcValue = null;
        for (Object id : values) {
            Class<?> columnType = this.converter.getColumnType(property);
            SQLType sqlType = this.converter.getTargetSqlType(property);
            jdbcValue = this.converter.writeJdbcValue(id, columnType, sqlType);
            convertedIds.add(jdbcValue.getValue());
        }
        Assert.state((jdbcValue != null ? 1 : 0) != 0, (String)"JdbcValue must be not null at this point. Please report this as a bug.");
        SQLType jdbcType = jdbcValue.getJdbcType();
        int typeNumber = jdbcType == null ? Integer.MIN_VALUE : jdbcType.getVendorTypeNumber();
        parameterSource.addValue(SqlGenerator.IDS_SQL_PARAMETER, convertedIds, typeNumber);
    }

    private <S> RelationalPersistentEntity<S> getRequiredPersistentEntity(Class<S> domainType) {
        return (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
    }

    private <S, T> SqlIdentifierParameterSource getParameterSource(@Nullable S instance, RelationalPersistentEntity<S> persistentEntity, String prefix, Predicate<RelationalPersistentProperty> skipProperty, IdentifierProcessing identifierProcessing) {
        SqlIdentifierParameterSource parameters = new SqlIdentifierParameterSource(identifierProcessing);
        PersistentPropertyAccessor propertyAccessor = instance != null ? persistentEntity.getPropertyAccessor(instance) : NoValuePropertyAccessor.instance();
        persistentEntity.doWithAll(property -> {
            if (skipProperty.test((RelationalPersistentProperty)property) || !property.isWritable()) {
                return;
            }
            if (property.isEntity() && !property.isEmbedded()) {
                return;
            }
            if (property.isEmbedded()) {
                Object value = propertyAccessor.getProperty(property);
                RelationalPersistentEntity embeddedEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(property.getType());
                SqlIdentifierParameterSource additionalParameters = this.getParameterSource(value, embeddedEntity, prefix + property.getEmbeddedPrefix(), skipProperty, identifierProcessing);
                parameters.addAll(additionalParameters);
            } else {
                Object value = propertyAccessor.getProperty(property);
                SqlIdentifier paramName = property.getColumnName().transform(prefix::concat);
                this.addConvertedPropertyValue(parameters, (RelationalPersistentProperty)property, value, paramName);
            }
        });
        return parameters;
    }

    static class NoValuePropertyAccessor<T>
    implements PersistentPropertyAccessor<T> {
        private static final NoValuePropertyAccessor INSTANCE = new NoValuePropertyAccessor();

        NoValuePropertyAccessor() {
        }

        static <T> NoValuePropertyAccessor<T> instance() {
            return INSTANCE;
        }

        public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
            throw new UnsupportedOperationException("Cannot set value on 'null' target object.");
        }

        public Object getProperty(PersistentProperty<?> property) {
            return null;
        }

        public T getBean() {
            return null;
        }
    }

    static class Predicates {
        Predicates() {
        }

        static Predicate<RelationalPersistentProperty> includeAll() {
            return it -> false;
        }
    }
}

