/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.core.BoundKeyExpirationOperations;
import org.springframework.data.redis.core.ExpireChanges;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.Expirations;
import org.springframework.lang.Nullable;

class DefaultBoundKeyExpirationOperations<K>
implements BoundKeyExpirationOperations {
    private final RedisOperations<K, ?> operations;
    private final K key;

    public DefaultBoundKeyExpirationOperations(RedisOperations<K, ?> operations, K key) {
        this.operations = operations;
        this.key = key;
    }

    @Override
    @Nullable
    public ExpireChanges.ExpiryChangeState expire(Expiration expiration, ExpirationOptions options) {
        return this.operations.expire(this.key, expiration, options);
    }

    @Override
    @Nullable
    public ExpireChanges.ExpiryChangeState expire(Duration timeout) {
        Boolean expire = this.operations.expire(this.key, timeout);
        return DefaultBoundKeyExpirationOperations.toExpiryChangeState(expire);
    }

    @Override
    @Nullable
    public ExpireChanges.ExpiryChangeState expireAt(Instant expireAt) {
        return DefaultBoundKeyExpirationOperations.toExpiryChangeState(this.operations.expireAt(this.key, expireAt));
    }

    @Override
    @Nullable
    public ExpireChanges.ExpiryChangeState persist() {
        return DefaultBoundKeyExpirationOperations.toExpiryChangeState(this.operations.persist(this.key));
    }

    @Override
    @Nullable
    public Expirations.TimeToLive getTimeToLive() {
        Long expire = this.operations.getExpire(this.key);
        return expire == null ? null : Expirations.TimeToLive.of(expire, TimeUnit.SECONDS);
    }

    @Override
    @Nullable
    public Expirations.TimeToLive getTimeToLive(TimeUnit timeUnit) {
        Long expire = this.operations.getExpire(this.key, timeUnit);
        return expire == null ? null : Expirations.TimeToLive.of(expire, timeUnit);
    }

    @Nullable
    private static ExpireChanges.ExpiryChangeState toExpiryChangeState(@Nullable Boolean result) {
        if (result == null) {
            return null;
        }
        return ExpireChanges.ExpiryChangeState.of(result);
    }
}

