/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.Objects;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.domain.RowDocument;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RowDocumentAccessor {
    private final RowDocument document;

    RowDocumentAccessor(RowDocument document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        this.document = document;
    }

    public RowDocument getDocument() {
        return this.document;
    }

    public void putAll(RowDocument source) {
        this.document.putAll(source);
    }

    public void put(RelationalPersistentProperty prop, @Nullable Object value) {
        Assert.notNull((Object)prop, (String)"RelationalPersistentProperty must not be null");
        String fieldName = this.getColumnName(prop);
        this.document.put(fieldName, value);
    }

    @Nullable
    public Object get(RelationalPersistentProperty property) {
        return this.document.get(this.getColumnName(property));
    }

    public boolean hasValue(RelationalPersistentProperty property) {
        Assert.notNull((Object)property, (String)"Property must not be null");
        return this.document.get(this.getColumnName(property)) != null;
    }

    String getColumnName(RelationalPersistentProperty prop) {
        return prop.getColumnName().getReference();
    }

    public RowDocument document() {
        return this.document;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RowDocumentAccessor that = (RowDocumentAccessor)obj;
        return Objects.equals(this.document, that.document);
    }

    public int hashCode() {
        return Objects.hash(this.document);
    }

    public String toString() {
        return "RowDocumentAccessor[document=" + this.document + "]";
    }
}

