/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.Objects;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.lang.Nullable;

@Deprecated
public class TopicPartitionInitialOffset {
    private final TopicPartition topicPartition;
    private final Long initialOffset;
    private final boolean relativeToCurrent;
    private final SeekPosition position;

    public TopicPartitionInitialOffset(String topic, int partition) {
        this(topic, partition, null, false);
    }

    public TopicPartitionInitialOffset(String topic, int partition, Long initialOffset) {
        this(topic, partition, initialOffset, false);
    }

    public TopicPartitionInitialOffset(String topic, int partition, Long initialOffset, boolean relativeToCurrent) {
        this.topicPartition = new TopicPartition(topic, partition);
        this.initialOffset = initialOffset;
        this.relativeToCurrent = relativeToCurrent;
        this.position = null;
    }

    public TopicPartitionInitialOffset(String topic, int partition, SeekPosition position) {
        this.topicPartition = new TopicPartition(topic, partition);
        this.initialOffset = null;
        this.relativeToCurrent = false;
        this.position = position;
    }

    public TopicPartitionInitialOffset(String topic, int partition, Long offset, @Nullable SeekPosition position) {
        this.topicPartition = new TopicPartition(topic, partition);
        this.initialOffset = offset;
        this.relativeToCurrent = false;
        this.position = position;
    }

    public TopicPartitionInitialOffset(TopicPartition topicPartition, Long offset, @Nullable SeekPosition position) {
        this.topicPartition = topicPartition;
        this.initialOffset = offset;
        this.relativeToCurrent = false;
        this.position = position;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int partition() {
        return this.topicPartition.partition();
    }

    public String topic() {
        return this.topicPartition.topic();
    }

    public Long initialOffset() {
        return this.initialOffset;
    }

    public boolean isRelativeToCurrent() {
        return this.relativeToCurrent;
    }

    public SeekPosition getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartitionInitialOffset that = (TopicPartitionInitialOffset)o;
        return Objects.equals(this.topicPartition, that.topicPartition);
    }

    public int hashCode() {
        return this.topicPartition.hashCode();
    }

    public String toString() {
        return "TopicPartitionInitialOffset{topicPartition=" + this.topicPartition + ", initialOffset=" + this.initialOffset + ", relativeToCurrent=" + this.relativeToCurrent + (this.position == null ? "" : ", position=" + this.position.name()) + '}';
    }

    public static TopicPartitionInitialOffset fromTPO(TopicPartitionOffset offset) {
        return new TopicPartitionInitialOffset(offset.getTopicPartition(), offset.getOffset(), offset.getPosition() == null ? null : SeekPosition.valueOf(offset.getPosition().name()));
    }

    public static TopicPartitionOffset toTPO(TopicPartitionInitialOffset offset) {
        return new TopicPartitionOffset(offset.topicPartition(), offset.initialOffset(), offset.getPosition() == null ? null : TopicPartitionOffset.SeekPosition.valueOf(offset.getPosition().name()));
    }

    public static enum SeekPosition {
        BEGINNING,
        END,
        TIMESTAMP;

    }
}

