/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.MethodOverrides;
import org.springframework.util.ClassUtils;

public abstract class AbstractBeanDefinition
implements BeanDefinition {
    public static final int AUTOWIRE_NO = 0;
    public static final int AUTOWIRE_BY_NAME = 1;
    public static final int AUTOWIRE_BY_TYPE = 2;
    public static final int AUTOWIRE_CONSTRUCTOR = 3;
    public static final int AUTOWIRE_AUTODETECT = 4;
    public static final int DEPENDENCY_CHECK_NONE = 0;
    public static final int DEPENDENCY_CHECK_OBJECTS = 1;
    public static final int DEPENDENCY_CHECK_SIMPLE = 2;
    public static final int DEPENDENCY_CHECK_ALL = 3;
    private Object beanClass;
    private boolean abstractFlag = false;
    private boolean singleton = true;
    private boolean lazyInit = false;
    private ConstructorArgumentValues constructorArgumentValues;
    private MutablePropertyValues propertyValues;
    private MethodOverrides methodOverrides = new MethodOverrides();
    private int autowireMode = 0;
    private int dependencyCheck = 0;
    private String initMethodName;
    private String destroyMethodName;
    private String factoryMethodName;
    private String factoryBeanName;
    private String[] dependsOn;
    private String resourceDescription;

    protected AbstractBeanDefinition() {
        this(null, null);
    }

    protected AbstractBeanDefinition(ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        this.setConstructorArgumentValues(cargs);
        this.setPropertyValues(pvs);
    }

    protected AbstractBeanDefinition(AbstractBeanDefinition original) {
        this.beanClass = original.beanClass;
        this.setAbstract(original.isAbstract());
        this.setSingleton(original.isSingleton());
        this.setLazyInit(original.isLazyInit());
        this.setConstructorArgumentValues(new ConstructorArgumentValues(original.getConstructorArgumentValues()));
        this.setPropertyValues(new MutablePropertyValues(original.getPropertyValues()));
        this.setMethodOverrides(new MethodOverrides(original.getMethodOverrides()));
        this.setAutowireMode(original.getAutowireMode());
        this.setDependencyCheck(original.getDependencyCheck());
        this.setInitMethodName(original.getInitMethodName());
        this.setDestroyMethodName(original.getDestroyMethodName());
        this.setFactoryMethodName(original.getFactoryMethodName());
        this.setFactoryBeanName(original.getFactoryBeanName());
        this.setDependsOn(original.getDependsOn());
        this.setResourceDescription(original.getResourceDescription());
    }

    public void overrideFrom(AbstractBeanDefinition other) {
        if (other.beanClass != null) {
            this.beanClass = other.beanClass;
        }
        this.setAbstract(other.isAbstract());
        this.setSingleton(other.isSingleton());
        this.setLazyInit(other.isLazyInit());
        this.getConstructorArgumentValues().addArgumentValues(other.getConstructorArgumentValues());
        this.getPropertyValues().addPropertyValues(other.getPropertyValues());
        this.getMethodOverrides().addOverrides(other.getMethodOverrides());
        if (other.getInitMethodName() != null) {
            this.setInitMethodName(other.getInitMethodName());
        }
        if (other.getDestroyMethodName() != null) {
            this.setDestroyMethodName(other.getDestroyMethodName());
        }
        if (other.getFactoryMethodName() != null) {
            this.setFactoryMethodName(other.getFactoryMethodName());
        }
        if (other.getFactoryBeanName() != null) {
            this.setFactoryBeanName(other.getFactoryBeanName());
        }
        this.setDependsOn(other.getDependsOn());
        this.setAutowireMode(other.getAutowireMode());
        this.setDependencyCheck(other.getDependencyCheck());
        this.setResourceDescription(other.getResourceDescription());
    }

    public boolean hasBeanClass() {
        return this.beanClass instanceof Class;
    }

    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    public Class getBeanClass() throws IllegalStateException {
        if (!(this.beanClass instanceof Class)) {
            throw new IllegalStateException("Bean definition does not carry a resolved bean class");
        }
        return (Class)this.beanClass;
    }

    public void setBeanClassName(String beanClassName) {
        this.beanClass = beanClassName;
    }

    public String getBeanClassName() {
        if (this.beanClass instanceof Class) {
            return ((Class)this.beanClass).getName();
        }
        return (String)this.beanClass;
    }

    public void setAbstract(boolean abstractFlag) {
        this.abstractFlag = abstractFlag;
    }

    public boolean isAbstract() {
        return this.abstractFlag;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void setConstructorArgumentValues(ConstructorArgumentValues constructorArgumentValues) {
        this.constructorArgumentValues = constructorArgumentValues != null ? constructorArgumentValues : new ConstructorArgumentValues();
    }

    public ConstructorArgumentValues getConstructorArgumentValues() {
        return this.constructorArgumentValues;
    }

    public boolean hasConstructorArgumentValues() {
        return this.constructorArgumentValues != null && !this.constructorArgumentValues.isEmpty();
    }

    public void setPropertyValues(MutablePropertyValues propertyValues) {
        this.propertyValues = propertyValues != null ? propertyValues : new MutablePropertyValues();
    }

    public MutablePropertyValues getPropertyValues() {
        return this.propertyValues;
    }

    public void setMethodOverrides(MethodOverrides methodOverrides) {
        this.methodOverrides = methodOverrides != null ? methodOverrides : new MethodOverrides();
    }

    public MethodOverrides getMethodOverrides() {
        return this.methodOverrides;
    }

    public void setAutowireMode(int autowireMode) {
        this.autowireMode = autowireMode;
    }

    public int getAutowireMode() {
        return this.autowireMode;
    }

    public int getResolvedAutowireMode() {
        if (this.autowireMode == 4) {
            Constructor<?>[] constructors = this.getBeanClass().getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                if (constructors[i].getParameterTypes().length != 0) continue;
                return 2;
            }
            return 3;
        }
        return this.autowireMode;
    }

    public void setDependencyCheck(int dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public int getDependencyCheck() {
        return this.dependencyCheck;
    }

    public void setInitMethodName(String initMethodName) {
        this.initMethodName = initMethodName;
    }

    public String getInitMethodName() {
        return this.initMethodName;
    }

    public void setDestroyMethodName(String destroyMethodName) {
        this.destroyMethodName = destroyMethodName;
    }

    public String getDestroyMethodName() {
        return this.destroyMethodName;
    }

    public void setFactoryMethodName(String factoryMethodName) {
        this.factoryMethodName = factoryMethodName;
    }

    public String getFactoryMethodName() {
        return this.factoryMethodName;
    }

    public void setFactoryBeanName(String factoryBeanName) {
        this.factoryBeanName = factoryBeanName;
    }

    public String getFactoryBeanName() {
        return this.factoryBeanName;
    }

    public void setDependsOn(String[] dependsOn) {
        this.dependsOn = dependsOn;
    }

    public String[] getDependsOn() {
        return this.dependsOn;
    }

    public void setResourceDescription(String resourceDescription) {
        this.resourceDescription = resourceDescription;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void validate() throws BeanDefinitionValidationException {
        if (this.lazyInit && !this.singleton) {
            throw new BeanDefinitionValidationException("Lazy initialization is only applicable to singleton beans");
        }
        if (!this.getMethodOverrides().isEmpty() && this.getFactoryMethodName() != null) {
            throw new BeanDefinitionValidationException("Cannot combine static factory method with method overrides: the static factory method must create the instance");
        }
        if (this.hasBeanClass()) {
            Iterator it = this.getMethodOverrides().getOverrides().iterator();
            while (it.hasNext()) {
                MethodOverride mo = (MethodOverride)it.next();
                this.validateMethodOverride(mo);
            }
        }
    }

    protected void validateMethodOverride(MethodOverride mo) throws BeanDefinitionValidationException {
        int count = ClassUtils.getMethodCountForName((Class)this.getBeanClass(), (String)mo.getMethodName());
        if (count == 0) {
            throw new BeanDefinitionValidationException("Invalid method override: no method with name '" + mo.getMethodName() + "' on class [" + this.getBeanClassName() + "]");
        }
        if (count == 1) {
            mo.setOverloaded(false);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("class [");
        sb.append(this.getBeanClassName()).append("]");
        sb.append("; abstract=").append(this.abstractFlag);
        sb.append("; singleton=").append(this.singleton);
        sb.append("; lazyInit=").append(this.lazyInit);
        sb.append("; autowire=").append(this.autowireMode);
        sb.append("; dependencyCheck=").append(this.dependencyCheck);
        sb.append("; initMethodName=").append(this.initMethodName);
        sb.append("; destroyMethodName=").append(this.destroyMethodName);
        sb.append("; factoryMethodName=").append(this.factoryMethodName);
        sb.append("; factoryBeanName=").append(this.factoryBeanName);
        if (this.getResourceDescription() != null) {
            sb.append("; defined in ").append(this.getResourceDescription());
        }
        return sb.toString();
    }
}

