/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultListableBeanFactory
extends AbstractAutowireCapableBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry {
    private boolean allowBeanDefinitionOverriding = true;
    private boolean allowEagerClassLoading = true;
    private final Map beanDefinitionMap = CollectionFactory.createConcurrentMapIfPossible((int)16);
    private final List beanDefinitionNames = new ArrayList();
    private AutowireCandidateResolver autowireCandidateResolver = AutowireUtils.createAutowireCandidateResolver();
    private final Map resolvableDependencies = new HashMap();

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setAutowireCandidateResolver(AutowireCandidateResolver autowireCandidateResolver) {
        Assert.notNull((Object)autowireCandidateResolver, (String)"AutowireCandidateResolver must not be null");
        this.autowireCandidateResolver = autowireCandidateResolver;
    }

    public AutowireCandidateResolver getAutowireCandidateResolver() {
        return this.autowireCandidateResolver;
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public void setAllowEagerClassLoading(boolean allowEagerClassLoading) {
        this.allowEagerClassLoading = allowEagerClassLoading;
    }

    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        super.copyConfigurationFrom(otherFactory);
        if (otherFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory otherListableFactory = (DefaultListableBeanFactory)otherFactory;
            this.allowBeanDefinitionOverriding = otherListableFactory.allowBeanDefinitionOverriding;
            this.allowEagerClassLoading = otherListableFactory.allowEagerClassLoading;
        }
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.beanDefinitionMap.containsKey(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getBeanDefinitionNames() {
        Map map = this.beanDefinitionMap;
        synchronized (map) {
            return StringUtils.toStringArray((Collection)this.beanDefinitionNames);
        }
    }

    public String[] getBeanNamesForType(Class type) {
        return this.getBeanNamesForType(type, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getBeanNamesForType(Class type, boolean includePrototypes, boolean allowEagerInit) {
        ArrayList<String> result = new ArrayList<String>();
        String[] beanDefinitionNames = null;
        Map map = this.beanDefinitionMap;
        synchronized (map) {
            beanDefinitionNames = StringUtils.toStringArray((Collection)this.beanDefinitionNames);
        }
        for (int i = 0; i < beanDefinitionNames.length; ++i) {
            String beanName = beanDefinitionNames[i];
            if (this.isAlias(beanName)) continue;
            try {
                boolean matchFound;
                RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
                if (mbd.isAbstract() || !allowEagerInit && !mbd.hasBeanClass() && mbd.isLazyInit() && !this.allowEagerClassLoading) continue;
                Class beanClass = this.predictBeanType(beanName, mbd, true);
                boolean isFactoryBean = beanClass != null && (class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass);
                boolean bl = matchFound = !(!allowEagerInit && this.requiresEagerInitForType(beanName, isFactoryBean, mbd.getFactoryBeanName()) || !includePrototypes && !this.isSingleton(beanName) || !this.isTypeMatch(beanName, type));
                if (!matchFound && isFactoryBean) {
                    beanName = "&" + beanName;
                    boolean bl2 = matchFound = (includePrototypes || mbd.isSingleton()) && this.isTypeMatch(beanName, type);
                }
                if (!matchFound) continue;
                result.add(beanName);
                continue;
            }
            catch (CannotLoadBeanClassException ex) {
                if (allowEagerInit) {
                    throw ex;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring bean class loading failure for bean '" + beanName + "'"), (Throwable)((Object)ex));
                }
                this.onSuppressedException((Exception)((Object)ex));
                continue;
            }
            catch (BeanDefinitionStoreException ex) {
                if (allowEagerInit) {
                    throw ex;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring unresolvable metadata in bean definition '" + beanName + "'"), (Throwable)((Object)ex));
                }
                this.onSuppressedException((Exception)((Object)ex));
            }
        }
        String[] singletonNames = this.getSingletonNames();
        for (int i = 0; i < singletonNames.length; ++i) {
            String beanName = singletonNames[i];
            if (this.containsBeanDefinition(beanName)) continue;
            if (this.isFactoryBean(beanName)) {
                if ((includePrototypes || this.isSingleton(beanName)) && this.isTypeMatch(beanName, type)) {
                    result.add(beanName);
                    continue;
                }
                beanName = "&" + beanName;
            }
            if (!this.isTypeMatch(beanName, type)) continue;
            result.add(beanName);
        }
        return StringUtils.toStringArray(result);
    }

    private boolean requiresEagerInitForType(String beanName, boolean isFactoryBean, String factoryBeanName) {
        return isFactoryBean && !this.containsSingleton(beanName) || factoryBeanName != null && this.isFactoryBean(factoryBeanName) && !this.containsSingleton(factoryBeanName);
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean allowEagerInit) throws BeansException {
        String[] beanNames = this.getBeanNamesForType(type, includePrototypes, allowEagerInit);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(beanNames.length);
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            try {
                result.put(beanName, this.getBean(beanName));
                continue;
            }
            catch (BeanCreationException ex) {
                BeanCreationException bce;
                Throwable rootCause = ex.getMostSpecificCause();
                if (rootCause instanceof BeanCurrentlyInCreationException && this.isCurrentlyInCreation((bce = (BeanCreationException)((Object)rootCause)).getBeanName())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring match to currently created bean '" + beanName + "': " + ex.getMessage()));
                    }
                    this.onSuppressedException((Exception)((Object)ex));
                    continue;
                }
                throw ex;
            }
        }
        return result;
    }

    public void registerResolvableDependency(Class dependencyType, Object autowiredValue) {
        Assert.notNull((Object)dependencyType, (String)"Type must not be null");
        Assert.isTrue((boolean)dependencyType.isInstance(autowiredValue), (String)"Value does not implement specified type");
        this.resolvableDependencies.put(dependencyType, autowiredValue);
    }

    public boolean isAutowireCandidate(String beanName, DependencyDescriptor descriptor) throws NoSuchBeanDefinitionException {
        boolean isFactoryBean;
        boolean bl = descriptor != null && descriptor.getDependencyType() != null && FactoryBean.class.isAssignableFrom(descriptor.getDependencyType()) ? true : (isFactoryBean = false);
        if (isFactoryBean) {
            beanName = BeanFactoryUtils.transformedBeanName(beanName);
        }
        if (!this.containsBeanDefinition(beanName)) {
            if (this.containsSingleton(beanName)) {
                return true;
            }
            if (this.getParentBeanFactory() instanceof ConfigurableListableBeanFactory) {
                return ((ConfigurableListableBeanFactory)this.getParentBeanFactory()).isAutowireCandidate(beanName, descriptor);
            }
        }
        return this.isAutowireCandidate(beanName, this.getMergedLocalBeanDefinition(beanName), descriptor);
    }

    protected boolean isAutowireCandidate(String beanName, RootBeanDefinition mbd, DependencyDescriptor descriptor) {
        return this.getAutowireCandidateResolver().isAutowireCandidate(new BeanDefinitionHolder(mbd, beanName, this.getAliases(beanName)), descriptor);
    }

    public boolean isPrimary(String beanName, Object beanInstance) {
        return super.isPrimary(beanName, beanInstance) || this.resolvableDependencies.values().contains(beanInstance);
    }

    protected String determinePrimaryCandidate(Map candidateBeans, Class type) {
        String primaryBeanName = null;
        Iterator it = candidateBeans.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String candidateBeanName = (String)entry.getKey();
            if (!this.isPrimary(candidateBeanName, entry.getValue())) continue;
            if (primaryBeanName != null) {
                throw new NoSuchBeanDefinitionException(type, "more than one 'primary' bean found among candidates: " + candidateBeans.keySet());
            }
            primaryBeanName = candidateBeanName;
        }
        return primaryBeanName;
    }

    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        BeanDefinition bd = (BeanDefinition)this.beanDefinitionMap.get(beanName);
        if (bd == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No bean named '" + beanName + "' found in " + this));
            }
            throw new NoSuchBeanDefinitionException(beanName);
        }
        return bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInstantiateSingletons() throws BeansException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Pre-instantiating singletons in " + this));
        }
        Map map = this.beanDefinitionMap;
        synchronized (map) {
            Iterator it = this.beanDefinitionNames.iterator();
            while (it.hasNext()) {
                String beanName = (String)it.next();
                RootBeanDefinition bd = this.getMergedLocalBeanDefinition(beanName);
                if (bd.isAbstract() || !bd.isSingleton() || bd.isLazyInit()) continue;
                if (this.isFactoryBean(beanName)) {
                    FactoryBean factory = (FactoryBean)this.getBean("&" + beanName);
                    if (!(factory instanceof SmartFactoryBean) || !((SmartFactoryBean)factory).isEagerInit()) continue;
                    this.getBean(beanName);
                    continue;
                }
                this.getBean(beanName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        Assert.hasText((String)beanName, (String)"'beanName' must not be empty");
        Assert.notNull((Object)beanDefinition, (String)"BeanDefinition must not be null");
        if (beanDefinition instanceof AbstractBeanDefinition) {
            try {
                ((AbstractBeanDefinition)beanDefinition).validate();
            }
            catch (BeanDefinitionValidationException ex) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Validation of bean definition failed", (Throwable)((Object)ex));
            }
        }
        Map map = this.beanDefinitionMap;
        synchronized (map) {
            Object oldBeanDefinition = this.beanDefinitionMap.get(beanName);
            if (oldBeanDefinition != null) {
                if (!this.allowBeanDefinitionOverriding) {
                    throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Cannot register bean definition [" + beanDefinition + "] for bean '" + beanName + "': There is already [" + oldBeanDefinition + "] bound.");
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Overriding bean definition for bean '" + beanName + "': replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]"));
                }
            } else {
                this.beanDefinitionNames.add(beanName);
            }
            this.beanDefinitionMap.put(beanName, beanDefinition);
            this.resetBeanDefinition(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        Assert.hasText((String)beanName, (String)"'beanName' must not be empty");
        Map map = this.beanDefinitionMap;
        synchronized (map) {
            BeanDefinition bd = (BeanDefinition)this.beanDefinitionMap.remove(beanName);
            if (bd == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("No bean named '" + beanName + "' found in " + this));
                }
                throw new NoSuchBeanDefinitionException(beanName);
            }
            this.beanDefinitionNames.remove(beanName);
            this.resetBeanDefinition(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetBeanDefinition(String beanName) {
        this.clearMergedBeanDefinition(beanName);
        Object object = this.getSingletonMutex();
        synchronized (object) {
            this.destroySingleton(beanName);
        }
        Iterator it = this.beanDefinitionNames.iterator();
        while (it.hasNext()) {
            BeanDefinition bd;
            String bdName = (String)it.next();
            if (beanName.equals(bdName) || !beanName.equals((bd = (BeanDefinition)this.beanDefinitionMap.get(bdName)).getParentName())) continue;
            this.resetBeanDefinition(bdName);
        }
    }

    protected Map findAutowireCandidates(String beanName, Class requiredType, DependencyDescriptor descriptor) {
        String[] candidateNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this, requiredType);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(candidateNames.length);
        Iterator it = this.resolvableDependencies.keySet().iterator();
        while (it.hasNext()) {
            Object autowiringValue;
            Class autowiringType = (Class)it.next();
            if (!autowiringType.isAssignableFrom(requiredType) || !requiredType.isInstance(autowiringValue = this.resolvableDependencies.get(autowiringType))) continue;
            result.put(ObjectUtils.identityToString(autowiringValue), autowiringValue);
            break;
        }
        for (int i = 0; i < candidateNames.length; ++i) {
            String candidateName = candidateNames[i];
            if (candidateName.equals(beanName) || !this.isAutowireCandidate(candidateName, descriptor)) continue;
            result.put(candidateName, this.getBean(candidateName));
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(ObjectUtils.identityToString((Object)this));
        sb.append(": defining beans [");
        sb.append(StringUtils.arrayToCommaDelimitedString((Object[])this.getBeanDefinitionNames()));
        sb.append("]; ");
        BeanFactory parent = this.getParentBeanFactory();
        if (parent == null) {
            sb.append("root of factory hierarchy");
        } else {
            sb.append("parent: " + ObjectUtils.identityToString((Object)parent));
        }
        return sb.toString();
    }
}

