/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;

public class WebLogicNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String JDBC_EXTENSION_NAME = "weblogic.jdbc.extensions.WLConnection";
    private final Class jdbcExtensionClass;
    private final Method getVendorConnectionMethod;

    public WebLogicNativeJdbcExtractor() {
        try {
            this.jdbcExtensionClass = this.getClass().getClassLoader().loadClass(JDBC_EXTENSION_NAME);
            this.getVendorConnectionMethod = this.jdbcExtensionClass.getMethod("getVendorConnection", null);
        }
        catch (Exception ex) {
            throw new InvalidDataAccessApiUsageException("Could not initialize WebLogicNativeJdbcExtractor because WebLogic API classes are not available", (Throwable)ex);
        }
    }

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (this.jdbcExtensionClass.isAssignableFrom(con.getClass())) {
            try {
                return (Connection)this.getVendorConnectionMethod.invoke((Object)con, (Object[])null);
            }
            catch (InvocationTargetException ex) {
                throw new DataAccessResourceFailureException("WebLogic's getVendorConnection method failed", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not access WebLogic's getVendorConnection method", (Throwable)ex);
            }
        }
        return con;
    }
}

