/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.support;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.JdkVersion;
import org.springframework.ldap.AuthenticationSource;
import org.springframework.ldap.ContextSource;
import org.springframework.ldap.DefaultNamingExceptionTranslator;
import org.springframework.ldap.NamingExceptionTranslator;
import org.springframework.ldap.support.DistinguishedName;

public abstract class AbstractContextSource
implements ContextSource,
InitializingBean {
    private static final Class DEFAULT_CONTEXT_FACTORY = class$com$sun$jndi$ldap$LdapCtxFactory == null ? (class$com$sun$jndi$ldap$LdapCtxFactory = AbstractContextSource.class$("com.sun.jndi.ldap.LdapCtxFactory")) : class$com$sun$jndi$ldap$LdapCtxFactory;
    private static final Class DEFAULT_DIR_OBJECT_FACTORY = class$org$springframework$ldap$support$DefaultDirObjectFactory == null ? (class$org$springframework$ldap$support$DefaultDirObjectFactory = AbstractContextSource.class$("org.springframework.ldap.support.DefaultDirObjectFactory")) : class$org$springframework$ldap$support$DefaultDirObjectFactory;
    private Class dirObjectFactory = DEFAULT_DIR_OBJECT_FACTORY;
    private Class contextFactory = DEFAULT_CONTEXT_FACTORY;
    private DistinguishedName base;
    protected String userName = "";
    protected String password = "";
    private String[] urls;
    private boolean pooled = true;
    private Hashtable baseEnv = new Hashtable();
    private Hashtable anonymousEnv;
    private AuthenticationSource authenticationSource;
    private boolean cacheEnvironmentProperties = true;
    private boolean anonymousReadOnly = false;
    private NamingExceptionTranslator exceptionTranslator = new DefaultNamingExceptionTranslator();
    private static final Log log = LogFactory.getLog((Class)(class$org$springframework$ldap$support$LdapContextSource == null ? (class$org$springframework$ldap$support$LdapContextSource = AbstractContextSource.class$("org.springframework.ldap.support.LdapContextSource")) : class$org$springframework$ldap$support$LdapContextSource));
    public static final String SUN_LDAP_POOLING_FLAG = "com.sun.jndi.ldap.connect.pool";
    private static final String JDK_142 = "1.4.2";
    static /* synthetic */ Class class$com$sun$jndi$ldap$LdapCtxFactory;
    static /* synthetic */ Class class$org$springframework$ldap$support$DefaultDirObjectFactory;
    static /* synthetic */ Class class$org$springframework$ldap$support$LdapContextSource;

    public DirContext getReadOnlyContext() {
        if (!this.anonymousReadOnly) {
            return this.createContext(this.getAuthenticatedEnv());
        }
        return this.createContext(this.getAnonymousEnv());
    }

    public DirContext getReadWriteContext() {
        return this.createContext(this.getAuthenticatedEnv());
    }

    protected void setupAuthenticatedEnvironment(Hashtable env) {
        env.put("java.naming.security.principal", this.authenticationSource.getPrincipal());
        log.debug((Object)("Principal: '" + this.userName + "'"));
        env.put("java.naming.security.credentials", this.authenticationSource.getCredentials());
    }

    private void closeContext(DirContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected String assembleProviderUrlString(String[] ldapUrls) {
        StringBuffer providerUrlBuffer = new StringBuffer(1024);
        for (int i = 0; i < ldapUrls.length; ++i) {
            providerUrlBuffer.append(ldapUrls[i]);
            if (this.base != null) {
                if (!ldapUrls[i].endsWith("/")) {
                    providerUrlBuffer.append("/");
                }
                providerUrlBuffer.append(this.base.toUrl());
            }
            providerUrlBuffer.append(' ');
        }
        return providerUrlBuffer.toString().trim();
    }

    public void setBase(String base) {
        this.base = new DistinguishedName(base);
    }

    DirContext createContext(Hashtable environment) {
        DirContext ctx = null;
        try {
            ctx = this.getDirContextInstance(environment);
            if (log.isInfoEnabled()) {
                Hashtable<?, ?> ctxEnv = ctx.getEnvironment();
                String ldapUrl = (String)ctxEnv.get("java.naming.provider.url");
                log.debug((Object)("Got Ldap context on server '" + ldapUrl + "'"));
            }
            return ctx;
        }
        catch (NamingException e) {
            this.closeContext(ctx);
            throw this.getExceptionTranslator().translate(e);
        }
    }

    public void setContextFactory(Class contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void setDirObjectFactory(Class dirObjectFactory) {
        this.dirObjectFactory = dirObjectFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (ArrayUtils.isEmpty((Object[])this.urls)) {
            throw new IllegalArgumentException("At least one server url must be set");
        }
        if (this.base != null && this.getJdkVersion().compareTo(JDK_142) < 0) {
            throw new IllegalArgumentException("Base path is not supported for JDK versions < 1.4.2");
        }
        if (this.authenticationSource == null) {
            log.debug((Object)"AuthenticationSource not set - using default implementation");
            if (StringUtils.isBlank((String)this.userName)) {
                log.warn((Object)"Property 'userName' not set - anonymous context will be used for read-write operations");
            } else if (StringUtils.isBlank((String)this.password)) {
                log.warn((Object)"Property 'password' not set - blank password will be used");
            }
            this.authenticationSource = new SimpleAuthenticationSource();
        }
        if (this.cacheEnvironmentProperties) {
            this.anonymousEnv = this.setupAnonymousEnv();
        }
    }

    private Hashtable setupAnonymousEnv() {
        if (this.pooled) {
            this.baseEnv.put(SUN_LDAP_POOLING_FLAG, "true");
            log.debug((Object)"Using LDAP pooling.");
        } else {
            log.debug((Object)"Not using LDAP pooling");
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>(this.baseEnv);
        env.put("java.naming.factory.initial", this.contextFactory.getName());
        env.put("java.naming.provider.url", this.assembleProviderUrlString(this.urls));
        if (this.dirObjectFactory != null) {
            env.put("java.naming.factory.object", this.dirObjectFactory.getName());
        }
        if (this.base != null) {
            env.put("org.springframework.ldap.base.path", this.base);
        }
        log.debug((Object)("Trying provider Urls: " + this.assembleProviderUrlString(this.urls)));
        return env;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUrls(String[] urls) {
        this.urls = urls;
    }

    public void setUrl(String url) {
        this.urls = new String[]{url};
    }

    public void setPooled(boolean pooled) {
        this.pooled = pooled;
    }

    public void setBaseEnvironmentProperties(Map baseEnvironmentProperties) {
        this.baseEnv = new Hashtable(baseEnvironmentProperties);
    }

    String getJdkVersion() {
        return JdkVersion.getJavaVersion();
    }

    protected Hashtable getAnonymousEnv() {
        if (this.cacheEnvironmentProperties) {
            return this.anonymousEnv;
        }
        return this.setupAnonymousEnv();
    }

    protected Hashtable getAuthenticatedEnv() {
        Hashtable env = new Hashtable(this.getAnonymousEnv());
        this.setupAuthenticatedEnvironment(env);
        return env;
    }

    public void setAuthenticationSource(AuthenticationSource authenticationProvider) {
        this.authenticationSource = authenticationProvider;
    }

    public void setCacheEnvironmentProperties(boolean cacheEnvironmentProperties) {
        this.cacheEnvironmentProperties = cacheEnvironmentProperties;
    }

    public void setAnonymousReadOnly(boolean anonymousReadOnly) {
        this.anonymousReadOnly = anonymousReadOnly;
    }

    public void setExceptionTranslator(NamingExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    public NamingExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    protected abstract DirContext getDirContextInstance(Hashtable var1) throws NamingException;

    protected String[] getUrls() {
        return this.urls;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SimpleAuthenticationSource
    implements AuthenticationSource {
        SimpleAuthenticationSource() {
        }

        public String getPrincipal() {
            return AbstractContextSource.this.userName;
        }

        public String getCredentials() {
            return AbstractContextSource.this.password;
        }
    }
}

